@echo off

rem  6/98: Modified to be compatible with QED-Flash as well as QED-3.
rem  0xB000 - 0xB1FF is available ONCHIP_RAM (in HC11 processor);
rem  0xB200 - 0xB3CF declared as EXTRA_RAM: reserved for flash routines;
rem  0xB3D0 - 0xB3FF reserved for watch and ForthIRQ stacks.
rem  Changes PAGE6 end address to 0x064FFF:
rem  5000\6 to 5FFF\6 holds approximately 130 _Q debug names & code;
rem  see QMDLOAD.BAT.

rem  2/97: updated version of QMLINK.BAT.  This file assures
rem  proper string access in multipage applications by putting
rem  all strings in the PAGE4RUN section which gets replicated on each
rem  page. It also places the 16bit .code section in the PAGE4RUN area
rem  to accommodate certain assembly-coded library functions.
rem  There is room for about 5 Kbytes of strings plus 3Kbytes of
rem  runtime code.

rem  This file is called by CCM.BAT to make the linker file
rem  for multi-page applications ( > 32KBytes ) compiled on the QED Board.
rem  This file supports programs that reside on 3 pages (pages 4, 5 & 6).
rem  Currently, page 7 is reserved; it is flash on QED4, RAM/ROM on QED3.
rem  Use heap RAM at 0x4600 - 0x7FFF on page 0x0F for 2 dimensional arrays.

rem  Remember to edit the PATHS command to match the path for your installation!

echo /* Generated by new batch scripts jlw - 7.3.1 */           > %1.lnk
echo PATHS   C:\FABIUS\LIB;                                     >> %1.lnk

echo OBJECTS                                                    >> %1.lnk
echo         startqed.o11, /* sets up and calls main()  */      >> %1.lnk
echo         io_qed.o11,   /* QED serial I/O primitives */      >> %1.lnk
echo         qeddrvrs.o11  /* PROMmed onboard drivers   */      >> %1.lnk
for %%1 in ( %1*.o11 ) do echo         , %%1                    >> %1.lnk
echo.         ;                                                  >> %1.lnk


echo LIBS BANKED_C.LIB, /* ANSI-C banked functions library */   >> %1.lnk
echo      RUNTIME.LIB,  /* Runtime functions library */         >> %1.lnk
echo      QED.LIB;      /* More QED I/O Functions */            >> %1.lnk


echo VAR     .StackEnd     = 0x8B00;                            >> %1.lnk
echo         .StackSize    =    730;                            >> %1.lnk
echo         .StackStart   = .StackEnd - .StackSize;            >> %1.lnk
echo         .stackBankEnd = 0x8BA0; /* Bank stack address */   >> %1.lnk
echo         .stackDataEnd = 0x8800; /* _forth fn Data stack */ >> %1.lnk
echo         .VarStart = 0x8E00;                                >> %1.lnk


echo ENVIRONMENT                                                  >> %1.lnk
echo    STACK(start=0x008204,end=0x008210)                        >> %1.lnk
LESS.EXE >> %1.lnk
echo - .forthStack; /* ptrs */                                    >> %1.lnk
echo    RAM  (start=.VarStart,end=0x00ADFF)           >> %1.lnk
LESS.EXE >> %1.lnk
echo - .init, .data;                                              >> %1.lnk
echo    ONCHIP_RAM  (start=0x00B000,end=0x00B1FF)                 >> %1.lnk
LESS.EXE >> %1.lnk
echo - .init, .data, .onchipRAM;                                  >> %1.lnk
echo    EXTRA_RAM  (start=0x00B200,end=0x00B3CF)                  >> %1.lnk
LESS.EXE >> %1.lnk
echo - .init, .data, .onchipRAM;                                  >> %1.lnk
echo    EEPROM  (start=0x00AEC0,end=0x00AFFF)                     >> %1.lnk
LESS.EXE >> %1.lnk
echo - .eeprom;                                                   >> %1.lnk

echo    PAGE4(start=0x040000,end=0x045FFF)                        >> %1.lnk
LESS.EXE >> %1.lnk
echo - .startup, .doubleword,  .bank;                             >> %1.lnk
echo    PAGE4RUN(start=0x046000,end=0x047FF9)                     >> %1.lnk
LESS.EXE >> %1.lnk
echo - .runtime, .code, .strings;                                 >> %1.lnk
echo    PAGE5(start=0x050000,end=0x055FFF)                        >> %1.lnk
LESS.EXE >> %1.lnk
echo - .doubleword, .bank;                                        >> %1.lnk
echo    PAGE6(start=0x060000,end=0x064FFF)                        >> %1.lnk
LESS.EXE >> %1.lnk
echo - .doubleword, .bank, .alternate;                            >> %1.lnk

echo /* NOTE: if code resides on more than 1 page, runtime  */   >> %1.lnk
echo /*    code in PAGE4RUN must be copied to all code pages.*/  >> %1.lnk
echo /*    This is done automatically by QMDLOAD.BAT.*/          >> %1.lnk

echo TARGET  %1.s (Motorola2)   /* should match ENVIRONMENT: */  >> %1.lnk
LESS.EXE >> %1.lnk
echo - STACK,RAM,ONCHIP_RAM,EXTRA_RAM,EEPROM,PAGE4,PAGE4RUN,PAGE5,PAGE6; >> %1.lnk
echo         %1.srn (Motorola2)                                  >> %1.lnk
LESS.EXE >> %1.lnk
echo - PAGE4RUN;                                                 >> %1.lnk
echo         %1.bug (Debug)                                      >> %1.lnk
LESS.EXE >> %1.lnk
echo - STACK,RAM,ONCHIP_RAM,EXTRA_RAM,EEPROM,PAGE4,PAGE4RUN,PAGE5,PAGE6; >> %1.lnk


echo REPORTS %1.MAP                                              >> %1.lnk
LESS.EXE >> %1.lnk
echo - alphalist, memorymap, sectionlist,                        >> %1.lnk
echo         addresslist, crosslist, errorlist,  filelist;       >> %1.lnk

echo         %1.OUT                                             >> %1.lnk
LESS.EXE >> %1.lnk
echo - absolute(%1.O11), custom(ALPHA,"\t%%15s\t0x%%06X\n");    >> %1.lnk
echo OPTIONS statics;  /* Add static symbols to map-file */     >> %1.lnk
echo         entry=.begin; /* Program entry point */            >> %1.lnk


