@echo off

rem  9/21/1:  Added .VarStart as a variable that controls the beginning
rem  of the variable area.

rem  6/98: Modified to be compatible with QED-Flash as well as QED-3.
rem  0xB000 - 0xB1FF is available ONCHIP_RAM (in HC11 processor);
rem  0xB200 - 0xB3CF declared as EXTRA_RAM: reserved for QED-4 flash routines;
rem  0xB3D0 - 0xB3FF reserved for watch and ForthIRQ stacks.

rem  This QLINK.BAT file is called by CC.BAT to make the linker file for a
rem  program that fits on a single 32Kbyte page (page 4) of the QED Board.
rem  See CCM.BAT and QMLINK.BAT to compile multi-page programs
rem   that require more than 32Kbytes of code space.

rem  Remember to edit the PATHS command to match the path for your installation!
echo /* Generated by new batch scripts jlw - 7.3.1 */           > %1.lnk
echo PATHS   C:\FABIUS\LIB;                                     >> %1.lnk

echo OBJECTS                                                    >> %1.lnk
echo         startqed.o11, /* sets up and calls main()  */      >> %1.lnk
echo         io_qed.o11,    /* QED serial I/O primitives */     >> %1.lnk
echo         qeddrvrs.o11  /* PROMmed onboard drivers   */      >> %1.lnk
for %%1 in ( %1*.o11 ) do echo         , %%1                    >> %1.lnk
echo.         ;                                                 >> %1.lnk


echo LIBS ANSI_C.LIB,  /* fast library (code is on one page)*/  >> %1.lnk
echo      RUNTIME.LIB, /* Runtime functions library */          >> %1.lnk
echo      QED.LIB;     /* More QED I/O Functions */             >> %1.lnk



echo VAR     .StackEnd     = 0x8B00;                            >> %1.lnk
echo         .StackSize    =    730;                            >> %1.lnk
echo         .StackStart   = .StackEnd - .StackSize;            >> %1.lnk
echo         .stackBankEnd = 0x8BA0; /* Bank stack address */   >> %1.lnk
echo         .stackDataEnd = 0x8800; /* _forth fn Data stack */ >> %1.lnk
echo         .VarStart = 0x8E00;                                >> %1.lnk


echo ENVIRONMENT                                                 >> %1.lnk
echo    STACK(start=0x008204,end=0x008210)                       >> %1.lnk
LESS.EXE >> %1.lnk
echo - .forthStack; /* ptrs */                                   >> %1.lnk
echo    RAM  (start=.VarStart,end=0x00ADFF)           >> %1.lnk
LESS.EXE >> %1.lnk
echo - .init, .data;                                             >> %1.lnk
echo    ONCHIP_RAM  (start=0x00B000,end=0x00B1FF)                 >> %1.lnk
LESS.EXE >> %1.lnk
echo - .init, .data, .onchipRAM;                                  >> %1.lnk
echo    EXTRA_RAM  (start=0x00B200,end=0x00B3CF)                  >> %1.lnk
LESS.EXE >> %1.lnk
echo - .init, .data, .onchipRAM;                                  >> %1.lnk
echo    EEPROM  (start=0x00AEC0,end=0x00AFFF)                    >> %1.lnk
LESS.EXE >> %1.lnk
echo - .eeprom;                                                  >> %1.lnk
echo    PAGE4(start=0x040000,end=0x047FF0)                       >> %1.lnk
LESS.EXE >> %1.lnk
echo - .startup, .strings,                                       >> %1.lnk
echo   .code, .runtime, .bank, .doubleword, .alternate;          >> %1.lnk

echo TARGET  %1.s (Motorola2)   /* should match ENVIRONMENT: */  >> %1.lnk
LESS.EXE >> %1.lnk
echo - STACK, RAM, ONCHIP_RAM, EXTRA_RAM, EEPROM, PAGE4;         >> %1.lnk
echo         %1.bug (Debug)                                      >> %1.lnk
LESS.EXE >> %1.lnk
echo - STACK, RAM, ONCHIP_RAM, EXTRA_RAM, EEPROM, PAGE4;         >> %1.lnk


echo REPORTS %1.MAP                                              >> %1.lnk
LESS.EXE >> %1.lnk
echo - alphalist, memorymap, sectionlist,                        >> %1.lnk
echo         addresslist, crosslist, errorlist,  filelist;       >> %1.lnk

echo         %1.OUT                                             >> %1.lnk
LESS.EXE >> %1.lnk
echo - absolute(%1.O11), custom(ALPHA,"\t%%15s\t0x%%06X\n");    >> %1.lnk
echo OPTIONS statics;  /* Add static symbols to map-file */     >> %1.lnk
echo         entry=.begin; /* Program entry point */            >> %1.lnk


