# Local library configuration.  Packages in this library are targetted
# to the QED 4.08 kernels.

$pkg_source_path="./kx_libs/qed_V4.0x";  # Sets architecture
$install_pre_filename="install_preamble_to_xflash.txt";
$install_post_filename="install_postamble_to_xflash.txt";

$package_vp_granularity=0x10;       # The granularity for the package to
                                    # end the vp

# Define memory below.  This array of hashes can contain as many memory areas
# listed as necessary.
# No section may be more than 1 page in span.
@target_memory=(
  { # Page 7.  Available on all products, not ram swappable
    'start_ptr'       =>  0x070000,   # xaddr of beginning of this area
    'end_ptr'         =>  0x078000,   # xaddr of end of this area
    'type'            =>  "code"      # Valid types are code and variable
  },
  { # Variable area at 8e00; standard
    'start_ptr'       =>  0x008e00,   # xaddr of beginning of variables
    'end_ptr'         =>  0x00ae00,   # xaddr of end of variables area
    'type'            =>  "variable"  # Valid types are code and variable
  },
  { # On chip RAM may be used.  Note that for ethersmart, this will
    # Likely be made into a special section for slave packages, since
    # the slave cannot run anything out of the normal RAM.
    'start_ptr'       =>  0x00b000,   # xaddr of beginning of variables
    'end_ptr'         =>  0x00b3d0,   # xaddr of end of variables area
    'type'            =>  "variable"  # Valid types are code and variable
  },
  { # Page d.  Also available on all products, and not RAM swappable
    'start_ptr'       =>  0x0d0000,   # xaddr of beginning of this area
    'end_ptr'         =>  0x0d8000,   # xaddr of end of this area
    'type'            =>  "code"      # Valid types are code and variable
  },
  {
    'start_ptr'       =>  0x730000,   # xaddr of beginning of this area
    'end_ptr'         =>  0x738000,   # xaddr of end of this area
    'type'            =>  "code"      # Valid types are code and variable
  },
  {
    'start_ptr'       =>  0x720000,   # xaddr of beginning of this area
    'end_ptr'         =>  0x728000,   # xaddr of end of this area
    'type'            =>  "code"      # Valid types are code and variable
  },
  {
    'start_ptr'       =>  0x710000,   # xaddr of beginning of this area
    'end_ptr'         =>  0x718000,   # xaddr of end of this area
    'type'            =>  "code"      # Valid types are code and variable
  },
  {
    'start_ptr'       =>  0x700000,   # xaddr of beginning of this area
    'end_ptr'         =>  0x708000,   # xaddr of end of this area
    'type'            =>  "code"      # Valid types are code and variable
  }
);
