# Local library configuration.  Packages in this library are targetted
# to the QED 4.08 kernels.

$pkg_source_path="./kx_libs/qed_V4.0x";  # Sets architecture

$copy_directive="cmove";

$package_vp_granularity=0x10;       # The granularity for the package to
                                    # end the vp

# Define memory below.  This array of hashes can contain as many memory areas
# listed as necessary.
# No section may be more than 1 page in span.
@target_memory=(
  { # Page F RAM area for temporary drivers.
    'start_ptr'       =>  0x0f4000,   # xaddr of beginning of this area
    'end_ptr'         =>  0x0f8000,   # xaddr of end of this area
    'type'            =>  "code"      # Valid types are code and variable
  },
  { # Wildcard Carrier Board Page 40 RAM.
    'start_ptr'       =>  0x400000,   # xaddr of beginning of this area
    'end_ptr'         =>  0x408000,   # xaddr of end of this area
    'type'            =>  "code"      # Valid types are code and variable
  },
  { # Wildcard Carrier Board Page 41 RAM.
    'start_ptr'       =>  0x410000,   # xaddr of beginning of this area
    'end_ptr'         =>  0x418000,   # xaddr of end of this area
    'type'            =>  "code"      # Valid types are code and variable
  },
  { # Wildcard Carrier Board Page 42 RAM.
    'start_ptr'       =>  0x420000,   # xaddr of beginning of this area
    'end_ptr'         =>  0x428000,   # xaddr of end of this area
    'type'            =>  "code"      # Valid types are code and variable
  },
  { # Wildcard Carrier Board Page 43 RAM.
    'start_ptr'       =>  0x430000,   # xaddr of beginning of this area
    'end_ptr'         =>  0x438000,   # xaddr of end of this area
    'type'            =>  "code"      # Valid types are code and variable
  },
  { # Wildcard Carrier Board Page 44 RAM.
    'start_ptr'       =>  0x440000,   # xaddr of beginning of this area
    'end_ptr'         =>  0x448000,   # xaddr of end of this area
    'type'            =>  "code"      # Valid types are code and variable
  },
  { # Wildcard Carrier Board Page 45 RAM.
    'start_ptr'       =>  0x450000,   # xaddr of beginning of this area
    'end_ptr'         =>  0x458000,   # xaddr of end of this area
    'type'            =>  "code"      # Valid types are code and variable
  },
  { # Wildcard Carrier Board Page 46 RAM.
    'start_ptr'       =>  0x460000,   # xaddr of beginning of this area
    'end_ptr'         =>  0x468000,   # xaddr of end of this area
    'type'            =>  "code"      # Valid types are code and variable
  },
  { # Wildcard Carrier Board Page 47 RAM.
    'start_ptr'       =>  0x470000,   # xaddr of beginning of this area
    'end_ptr'         =>  0x478000,   # xaddr of end of this area
    'type'            =>  "code"      # Valid types are code and variable
  },
  { # Wildcard Carrier Board Page 48 RAM.
    'start_ptr'       =>  0x480000,   # xaddr of beginning of this area
    'end_ptr'         =>  0x488000,   # xaddr of end of this area
    'type'            =>  "code"      # Valid types are code and variable
  },
  { # Wildcard Carrier Board Page 49 RAM.
    'start_ptr'       =>  0x490000,   # xaddr of beginning of this area
    'end_ptr'         =>  0x498000,   # xaddr of end of this area
    'type'            =>  "code"      # Valid types are code and variable
  },
  { # Wildcard Carrier Board Page 4A RAM.
    'start_ptr'       =>  0x4a0000,   # xaddr of beginning of this area
    'end_ptr'         =>  0x4a8000,   # xaddr of end of this area
    'type'            =>  "code"      # Valid types are code and variable
  },
  { # Wildcard Carrier Board Page 4B RAM.
    'start_ptr'       =>  0x4b0000,   # xaddr of beginning of this area
    'end_ptr'         =>  0x4b8000,   # xaddr of end of this area
    'type'            =>  "code"      # Valid types are code and variable
  },
  { # Wildcard Carrier Board Page 4C RAM.
    'start_ptr'       =>  0x4c0000,   # xaddr of beginning of this area
    'end_ptr'         =>  0x4c8000,   # xaddr of end of this area
    'type'            =>  "code"      # Valid types are code and variable
  },
  { # Wildcard Carrier Board Page 4D RAM.
    'start_ptr'       =>  0x4d0000,   # xaddr of beginning of this area
    'end_ptr'         =>  0x4d8000,   # xaddr of end of this area
    'type'            =>  "code"      # Valid types are code and variable
  },
  { # Wildcard Carrier Board Page 4E RAM.
    'start_ptr'       =>  0x4e0000,   # xaddr of beginning of this area
    'end_ptr'         =>  0x4e8000,   # xaddr of end of this area
    'type'            =>  "code"      # Valid types are code and variable
  },
  { # Wildcard Carrier Board Page 4F RAM.
    'start_ptr'       =>  0x4f0000,   # xaddr of beginning of this area
    'end_ptr'         =>  0x4f8000,   # xaddr of end of this area
    'type'            =>  "code"      # Valid types are code and variable
  },
  { # Variable area at 8e00; standard
    'start_ptr'       =>  0x008e00,   # xaddr of beginning of variables
    'end_ptr'         =>  0x00ae00,   # xaddr of end of variables area
    'type'            =>  "variable"  # Valid types are code and variable
  },
  { # On chip RAM may be used.  Note that for ethersmart, this will
    # Likely be made into a special section for slave packages, since
    # the slave cannot run anything out of the normal RAM.
    'start_ptr'       =>  0x00b000,   # xaddr of beginning of variables
    'end_ptr'         =>  0x00b3d0,   # xaddr of end of variables area
    'type'            =>  "variable"  # Valid types are code and variable
  }
);
