# This schema was created for the Antek stack tester.
# May be used in any scenario where kernel extensions need to be in
# flash pages that are swapped with RAM in the download map.

$pkg_source_path="./kx_libs/qed_V4.0x";  # Sets architecture

$package_vp_granularity=0x10;       # The granularity for the package to
                                    # end the vp

# Define memory below.  This array of hashes can contain as many memory areas
# listed as necessary.
# No section may be more than 1 page in span.
@target_memory=(
  { # Page 6.
    'start_ptr'       =>  0x060000,   # xaddr of beginning of this area
    'end_ptr'         =>  0x068000,   # xaddr of end of this area
    'type'            =>  "code"      # Valid types are code and variable
  },
  { # Page 5.
    'start_ptr'       =>  0x050000,   # xaddr of beginning of this area
    'end_ptr'         =>  0x058000,   # xaddr of end of this area
    'type'            =>  "code"      # Valid types are code and variable
  },
  { # Page 4.
    'start_ptr'       =>  0x040000,   # xaddr of beginning of this area
    'end_ptr'         =>  0x047ffa,   # xaddr of end of this area; 6b autostart at top
    'type'            =>  "code"      # Valid types are code and variable
  },
  { # Variable area at 8e00; standard
    'start_ptr'       =>  0x008e00,   # xaddr of beginning of variables
    'end_ptr'         =>  0x00ae00,   # xaddr of end of variables area
    'type'            =>  "variable"  # Valid types are code and variable
  },
  { # On chip RAM may be used.  Note that for ethersmart, this will
    # Likely be made into a special section for slave packages, since
    # the slave cannot run anything out of the normal RAM.
    'start_ptr'       =>  0x00b000,   # xaddr of beginning of variables
    'end_ptr'         =>  0x00b3d0,   # xaddr of end of variables area
    'type'            =>  "variable"  # Valid types are code and variable
  }
);
