# Packages built with this schema are targeted to the QCard 4.4x kernels.

$pkg_source_path="./kx_libs/QCard_V4.4x";  # Sets architecture

$package_vp_granularity=0x10;       # The granularity for the package to
                                    # end the vp

# Define memory below.  This array of hashes can contain as many memory areas
# listed as necessary.
# No section may be more than 1 page in span.
@target_memory=(
  { # Variable area at 8e00; standard
    'start_ptr'       =>  0x008e00,   # xaddr of beginning of variables
    'end_ptr'         =>  0x00ae00,   # xaddr of end of variables area
    'type'            =>  "variable"  # Valid types are code and variable
  },
  { # On chip RAM may be used.
    'start_ptr'       =>  0x00b000,   # xaddr of beginning of variables
    'end_ptr'         =>  0x00b3d0,   # xaddr of end of variables area
    'type'            =>  "variable"  # Valid types are code and variable
  },
  { # Page 7.  Available on all products, not ram swappable
    'start_ptr'       =>  0x070000,   # xaddr of beginning of this area
    'end_ptr'         =>  0x078000,   # xaddr of end of this area
    'type'            =>  "code"      # Valid types are code and variable
  },
  { # Page c.  Not available on QED, not ram swappable
    'start_ptr'       =>  0x0c0000,   # xaddr of beginning of this area
    'end_ptr'         =>  0x0c7ffa,   # xaddr of end of this area; 6b autostart at top
    'type'            =>  "code"      # Valid types are code and variable
  },
  { # Page d.  Also available on all products, and not RAM swappable
    'start_ptr'       =>  0x0d0000,   # xaddr of beginning of this area
    'end_ptr'         =>  0x0d8000,   # xaddr of end of this area
    'type'            =>  "code"      # Valid types are code and variable
  },
  {
    'start_ptr'       =>  0x2f0000,   # xaddr of beginning of this area
    'end_ptr'         =>  0x2f8000,   # xaddr of end of this area
    'type'            =>  "code"      # Valid types are code and variable
  },
  {
    'start_ptr'       =>  0x2e0000,   # xaddr of beginning of this area
    'end_ptr'         =>  0x2e8000,   # xaddr of end of this area
    'type'            =>  "code"      # Valid types are code and variable
  },
  {
    'start_ptr'       =>  0x2d0000,   # xaddr of beginning of this area
    'end_ptr'         =>  0x2d8000,   # xaddr of end of this area
    'type'            =>  "code"      # Valid types are code and variable
  },
  {
    'start_ptr'       =>  0x2c0000,   # xaddr of beginning of this area
    'end_ptr'         =>  0x2c8000,   # xaddr of end of this area
    'type'            =>  "code"      # Valid types are code and variable
  },
  {
    'start_ptr'       =>  0x2b0000,   # xaddr of beginning of this area
    'end_ptr'         =>  0x2b8000,   # xaddr of end of this area
    'type'            =>  "code"      # Valid types are code and variable
  },
  {
    'start_ptr'       =>  0x2a0000,   # xaddr of beginning of this area
    'end_ptr'         =>  0x2a8000,   # xaddr of end of this area
    'type'            =>  "code"      # Valid types are code and variable
  },
  {
    'start_ptr'       =>  0x290000,   # xaddr of beginning of this area
    'end_ptr'         =>  0x298000,   # xaddr of end of this area
    'type'            =>  "code"      # Valid types are code and variable
  },
  {
    'start_ptr'       =>  0x280000,   # xaddr of beginning of this area
    'end_ptr'         =>  0x288000,   # xaddr of end of this area
    'type'            =>  "code"      # Valid types are code and variable
  },
  {
    'start_ptr'       =>  0x270000,   # xaddr of beginning of this area
    'end_ptr'         =>  0x278000,   # xaddr of end of this area
    'type'            =>  "code"      # Valid types are code and variable
  },
  {
    'start_ptr'       =>  0x260000,   # xaddr of beginning of this area
    'end_ptr'         =>  0x268000,   # xaddr of end of this area
    'type'            =>  "code"      # Valid types are code and variable
  },
  {
    'start_ptr'       =>  0x250000,   # xaddr of beginning of this area
    'end_ptr'         =>  0x258000,   # xaddr of end of this area
    'type'            =>  "code"      # Valid types are code and variable
  },
  {
    'start_ptr'       =>  0x240000,   # xaddr of beginning of this area
    'end_ptr'         =>  0x248000,   # xaddr of end of this area
    'type'            =>  "code"      # Valid types are code and variable
  },
  {
    'start_ptr'       =>  0x230000,   # xaddr of beginning of this area
    'end_ptr'         =>  0x238000,   # xaddr of end of this area
    'type'            =>  "code"      # Valid types are code and variable
  },
  {
    'start_ptr'       =>  0x220000,   # xaddr of beginning of this area
    'end_ptr'         =>  0x228000,   # xaddr of end of this area
    'type'            =>  "code"      # Valid types are code and variable
  },
  {
    'start_ptr'       =>  0x210000,   # xaddr of beginning of this area
    'end_ptr'         =>  0x218000,   # xaddr of end of this area
    'type'            =>  "code"      # Valid types are code and variable
  },
  {
    'start_ptr'       =>  0x200000,   # xaddr of beginning of this area
    'end_ptr'         =>  0x208000,   # xaddr of end of this area
    'type'            =>  "code"      # Valid types are code and variable
  },
  {
    'start_ptr'       =>  0x170000,   # xaddr of beginning of this area
    'end_ptr'         =>  0x178000,   # xaddr of end of this area
    'type'            =>  "code"      # Valid types are code and variable
  },
  {
    'start_ptr'       =>  0x160000,   # xaddr of beginning of this area
    'end_ptr'         =>  0x168000,   # xaddr of end of this area
    'type'            =>  "code"      # Valid types are code and variable
  },
  {
    'start_ptr'       =>  0x150000,   # xaddr of beginning of this area
    'end_ptr'         =>  0x158000,   # xaddr of end of this area
    'type'            =>  "code"      # Valid types are code and variable
  },
  {
    'start_ptr'       =>  0x140000,   # xaddr of beginning of this area
    'end_ptr'         =>  0x148000,   # xaddr of end of this area
    'type'            =>  "code"      # Valid types are code and variable
  },
  {
    'start_ptr'       =>  0x130000,   # xaddr of beginning of this area
    'end_ptr'         =>  0x138000,   # xaddr of end of this area
    'type'            =>  "code"      # Valid types are code and variable
  },
  {
    'start_ptr'       =>  0x120000,   # xaddr of beginning of this area
    'end_ptr'         =>  0x128000,   # xaddr of end of this area
    'type'            =>  "code"      # Valid types are code and variable
  },
  {
    'start_ptr'       =>  0x110000,   # xaddr of beginning of this area
    'end_ptr'         =>  0x118000,   # xaddr of end of this area
    'type'            =>  "code"      # Valid types are code and variable
  },
  {
    'start_ptr'       =>  0x100000,   # xaddr of beginning of this area
    'end_ptr'         =>  0x108000,   # xaddr of end of this area
    'type'            =>  "code"      # Valid types are code and variable
  }
);
