
# Yet another file in the configuration file.  This file is parsed by
# the kem CGI script to tell it what schemas to display.  Really, this
# could be automated into a directory scan, but this does have the benefit
# of allowing us to control the order in which the choices appear.  A better
# way would be a front end that had a wizard like interface.

# Schema setup.  This list determines which schemas are offered on the main
# start page.  An error will occur if the specified schema config file is
# absent.

@schemas= (
  {
    'path' => "qcard512.pl",
    'description' => "QCard Controller with 512K of Flash",
    'photo' => "/kemimages/qcard.jpg"
  },

  {
    'path' => "qcard1024.pl",
    'description' => "QScreen or Handheld with 1024K Flash",
    'photo' => "/kemimages/qscreen.jpg"
  },

  {
    'path' => "wcb512.pl",
    'description' => "WildCard Carrier board equipped QED Board with 512K Flash",
    'photo' => "/kemimages/WCB.jpg"
  },

  {
    'path' => "wcb512-only.pl",
    'description' => "WildCard Carrier board with 512K Flash, use no QED pages (Special purposes only)",
    'photo' => "/kemimages/WCB.jpg"
  },

  {
    'path' => "wcb128.pl",
    'description' => "WildCard Carrier board equipped QED Board with 128K Flash",
    'photo' => "/kemimages/WCB.jpg"
  },

  {
    'path' => "qvga512.pl",
    'description' => "QVGA Controller with 512K Flash",
    'photo' => "/kemimages/QVGAweb.jpg"
  },

  {
    'path' => "qvga128.pl",
    'description' => "QVGA Controller with 128K Flash",
    'photo' => "/kemimages/QVGAweb.jpg"
  },

  {
    'path' => "qed.pl",
    'description' => "QED Board with 256K Flash",
    'photo' => "/kemimages/QED.jpg"
  },

  {
    'path' => "qed-wcb-ram.pl",        # QED Controller- RAM for creating temporary (kx preamble) drivers
    'description' => "QED and WC Carrier Board RAM (Special purposes only)",
    'photo' => "/kemimages/QED.jpg"
  },

  {
    'path' => "qed-swappable.pl",  # QED Controller- page 6,5,4 for transfer to devices under test
    'description' => "QED Board Swappable Pages (Special purposes only)",
    'photo' => "/kemimages/QED.jpg"
  }
);

# The following causes all packages (Even hidden ones) to be displayed
# $listcmd="/usr/bin/perl -T /usr/bin/kem.pl detail_list -a ";


# This is printed at the top of the page indicating that the package has been
# built successfully.

$been_built=<<ENDHTML;
<p><font size=+1 color=lime>Your package has been successfully built. </font>
<font size=+1>Scroll to the end of this page to get the zip file.</font><p>
<font color=yellow size=+1>Output:</font><p>
<font color=lime><pre>
ENDHTML

# HTML Description of Schema meaning. This is the html code that is printed
# at the top of the initial page asking you to select a schema

$schema_explanation=<<ENDHTML;
<font size=+1 color=lime>Product configuration selection</font>
You must select the product for which you are developing.  This
information is used to determine what kernel extension library is to be used
and what memory map settings are applied.  <p>For support,
<a href="http://www.mosaic-industries.com/embedded-systems/dokuwiki/help-for-readers/contact-us">
contact Mosaic Industries.</a><p>
ENDHTML


$maintitle="<B><FONT SIZE=+2 color=blue> Kernel Extension Manager</FONT></B>";

# Define the css stylesheet to use.  We may want to make this an external
# file soon.

$css_style_sheet= <<ENDHTML;
  <style type="text/css">

  h1.error
  {
    color: red;
  }

  img {
    border: 0;
    }

  table
  {
    font-family: sans-serif;
    background: black;
  }
  th
  {
    font-family: sans-serif;
    color: white;
    background: purple;
    table-height: 90;
  }
  td
  {
    font-family: sans-serif;
    color: silver;
    background: navy;
  }

  input
  {
    color: black;
  }
  </style>
ENDHTML

