
_forth  void Initialize_GUI ( xaddr heap_start, xaddr heap_end )
{
#asm
    dey
    dey
    dey
    dey
    ldx #INITIALIZE_GUI_ADDR
    stx 2,y
    ldx #INITIALIZE_GUI_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int New_Object ( int object_type )
{
#asm
    dey
    dey
    dey
    dey
    ldx #NEW_OBJECT_ADDR
    stx 2,y
    ldx #NEW_OBJECT_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Set_Property ( int object, int property, ulong value )
{
#asm
    dey
    dey
    dey
    dey
    ldx #SET_PROPERTY_ADDR
    stx 2,y
    ldx #SET_PROPERTY_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  ulong Get_Property ( int object, int property )
{
#asm
    dey
    dey
    dey
    dey
    ldx #GET_PROPERTY_ADDR
    stx 2,y
    ldx #GET_PROPERTY_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Load ( int screen, int object, int x_coord, int y_coord )
{
#asm
    dey
    dey
    dey
    dey
    ldx #LOAD_ADDR
    stx 2,y
    ldx #LOAD_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Un_Load ( int screen, int object, int x_coord, int y_coord )
{
#asm
    dey
    dey
    dey
    dey
    ldx #UN_LOAD_ADDR
    stx 2,y
    ldx #UN_LOAD_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int Read_Error ( void )
{
#asm
    dey
    dey
    dey
    dey
    ldx #READ_ERROR_ADDR
    stx 2,y
    ldx #READ_ERROR_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Clear_Error ( void )
{
#asm
    dey
    dey
    dey
    dey
    ldx #CLEAR_ERROR_ADDR
    stx 2,y
    ldx #CLEAR_ERROR_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Buzz ( void )
{
#asm
    dey
    dey
    dey
    dey
    ldx #BUZZ_ADDR
    stx 2,y
    ldx #BUZZ_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Refresh ( int screen )
{
#asm
    dey
    dey
    dey
    dey
    ldx #REFRESH_ADDR
    stx 2,y
    ldx #REFRESH_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Redraw ( int screen )
{
#asm
    dey
    dey
    dey
    dey
    ldx #REDRAW_ADDR
    stx 2,y
    ldx #REDRAW_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Draw ( int x_coord, int y_coord )
{
#asm
    dey
    dey
    dey
    dey
    ldx #DRAW_ADDR
    stx 2,y
    ldx #DRAW_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Clear ( int object )
{
#asm
    dey
    dey
    dey
    dey
    ldx #CLEAR_ADDR
    stx 2,y
    ldx #CLEAR_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Calibrate ( ulong raw_coord0, ulong raw_coord1, ulong raw_coord2 )
{
#asm
    dey
    dey
    dey
    dey
    ldx #CALIBRATE_ADDR
    stx 2,y
    ldx #CALIBRATE_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Add_Data ( int plot, int value )
{
#asm
    dey
    dey
    dey
    dey
    ldx #ADD_DATA_ADDR
    stx 2,y
    ldx #ADD_DATA_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Service_GUI_Events ( void )
{
#asm
    dey
    dey
    dey
    dey
    ldx #SERVICE_GUI_EVENTS_ADDR
    stx 2,y
    ldx #SERVICE_GUI_EVENTS_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int Screen_To_Image ( xaddr buffer, int buffer_size, int format )
{
#asm
    dey
    dey
    dey
    dey
    ldx #SCREEN_TO_IMAGE_ADDR
    stx 2,y
    ldx #SCREEN_TO_IMAGE_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int Graphic_To_Image ( uint graphic_object, xaddr buffer, int buffer_size, int format )
{
#asm
    dey
    dey
    dey
    dey
    ldx #GRAPHIC_TO_IMAGE_ADDR
    stx 2,y
    ldx #GRAPHIC_TO_IMAGE_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  long Simulate_Touch ( int x_coord, int y_coord )
{
#asm
    dey
    dey
    dey
    dey
    ldx #SIMULATE_TOUCH_ADDR
    stx 2,y
    ldx #SIMULATE_TOUCH_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Screen_Has_Changed ( void )
{
#asm
    dey
    dey
    dey
    dey
    ldx #SCREEN_HAS_CHANGED_ADDR
    stx 2,y
    ldx #SCREEN_HAS_CHANGED_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int Has_Screen_Changed ( void )
{
#asm
    dey
    dey
    dey
    dey
    ldx #HAS_SCREEN_CHANGED_ADDR
    stx 2,y
    ldx #HAS_SCREEN_CHANGED_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int Simulated_Touch_To_Image ( xaddr buffer, int buffer_size, int format_id, int x, int y )
{
#asm
    dey
    dey
    dey
    dey
    ldx #SIMULATED_TOUCH_TO_IMAGE_ADDR
    stx 2,y
    ldx #SIMULATED_TOUCH_TO_IMAGE_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void String_To_Textbox ( int object, char *strAddr, int strPage, int count, int row, int col )
{
#asm
    dey
    dey
    dey
    dey
    ldx #CSTRING_TO_TEXTBOX_ADDR
    stx 2,y
    ldx #CSTRING_TO_TEXTBOX_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int Textbox_To_String ( int object, int num_bytes, int row, int col )
{
#asm
    dey
    dey
    dey
    dey
    ldx #CTEXTBOX_TO_STRING_ADDR
    stx 2,y
    ldx #CTEXTBOX_TO_STRING_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}
