
// ******************************** Object Types *******************************

// Used with New_Object method to create a new instance of the object.
#define GRAPHIC 1
#define FONT    2
#define TEXTBOX 3
#define PEN     4
#define PLOT    5
#define BUTTON  6
#define SCREEN  7

// ********************* Pre-instantiated object indicies **********************

// These objects are initialized in Initialize_GUI.
#define GUI_TOOLKIT     0
#define GUI_ERROR       1
#define GUI_DISPLAY     2
#define GUI_TOUCHSCREEN 3
#define GUI_SCREEN0     4
#define GUI_SCREEN1     5
#define GUI_SCREEN2     6
#define GUI_SCREEN3     7
#define GUI_SCREEN4     8
#define GUI_SCREEN5     9
#define GUI_PEN         10
#define GUI_FONT        11
#define GUI_BUZZER      12

// **************************** Properties of Objects **************************

// Object properties used by Get_Property or Set_Property
#define WIDTH_IN_PIXELS         0 // Read or write depending on the object.
#define HEIGHT_IN_PIXELS        1 // Read or write depending on the object.

// GUI Ojbect properties.
#define HORIZONTAL_SNAP_TO_GRID 2 // Read only, always true.
#define VERTICAL_SNAP_TO_GRID   3 // Read or write.
#define SERVICE_EVENTS          4 // Read or write.
#define STANDARD_FONT           5 // Read or write.
#define AVAILABLE_HEAP_SPACE    6 // Read only.

// Error object properties
#define ERROR_CODE              7 // Read or write.
#define ABORT_ON_ERROR          8 // Read or write.

// Buzzer object properties
#define BUZZER_ON                9 // Read or write.
#define BEEP_TIME               10 // Read or write.  In TCNTs (2us).

// Display object properties.
#define BACKLIGHT_ON            11 // Read or write.
#define INVERT_DISPLAY          12 // Read or write.
#define BLANK_DISPLAY           13 // Read or write.
#define CONTRAST                14 // Read or write.

// Touchscreen object properties
#define LAST_EVENT              16 // Read only.
#define RAW_COORDS              17 // Read only.
#define CAL_COORDS              18 // Read only.

// Graphic and Font object property for image data.
#define IMAGE                   19 // Read or write.

// Textbox object properties
#define COLUMNS                 20 // Read or write.
#define ROWS                    21 // Read or write.
#define TEXTBOX_FONT            22 // Read or write.
#define BORDER                  23 // Read or write. Draws a 1 pixel border around object.

// Button object properties
#define DRAW_GRAPHIC            24 // Read or write.
#define PRESS_GRAPHIC           25 // Read or write.
#define RELEASE_GRAPHIC         26 // Read or write.
#define PRESS_EVENT_PROCEDURE   27 // Read or write.
#define HELD_EVENT_PROCEDURE    28 // Read or write.
#define RELEASE_EVENT_PROCEDURE 29 // Read or write.
#define BUTTON_TEXTBOX          30 // Read or write.
#define BEEP_ON_PRESS           31 // Read or write.
#define BEEP_ON_RELEASE         32 // Read or write.
#define BEEP_ON_HOLD            33 // Read or write.
#define BLOCK_ON_PRESS          43 // Read or write.
#define BLOCK_ON_HOLD           44 // Read or write.
#define BLOCK_ON_RELEASE        45 // Read or write.

// Plot object properties
#define BUFFER_SIZE             34 // Read or write. Size of the data buffer in bytes.

// Screen object properties
#define VISIBLE                 35 // Read only.
#define IN_DISPLAY              36 // Read only.
#define NUM_OBJECTS             37 // Reads num objects in the screen.
#define SCREEN_ADDRESS          38 // Reads address of the screen where data is located.

// Pen object properties
#define TARGET_SCREEN           39 // Read or Write. Screen that pen is drawing to.
#define PEN_TYPE                40 // Read or Write. Set to draw, unset to erase.
#define SHAPE                   41 // Read or Write. Pixel or line.
#define LAST_COORDS             42 // Read only.

// -------------------------- Misc constants -----------------------------------

// Valuess for pen object properties.  All values are 32 bit numbers.
#define SET   0L          // option for PEN_TYPE to draw a pixel or line.
#define UNSET 1L          // option for PEN_TYPE to erase a pixel or line.

#define POINT 0L          // option for SHAPE to draw or erase a point.
#define LINE  1L          // option for SHAPE to draw or erase a line.

#define INVALID_INDEX -1  // index returned by init_touch or init_display if
                          // there were problems with the initialization.

// Values for the LAST_EVENT touchscreen property.  These are 32 bit versions of
// the events.
#define NO_EVENT      0x0000L
#define PRESS_EVENT   0x1000L
#define HELD_EVENT    0x2000L
#define RELEASE_EVENT 0x3000L

#define GUI_TRUE   0xFFFFFFFFL // 32 bit value for true. Used in get & set property
#define GUI_FALSE  0x0L        // 32 bit value for false.  Used in get & set property

// -------------------------- Error constants -----------------------------------

#define NO_ERROR 0

// There was an error reading the id from display controller in Init_Display.
#define DISPLAY_INITIALIZATION_FAILURE 1

// The heap is full.  No room to allocate new objects or resize current ones.
#define HEAP_FULL 2

// Checksum failed for the header of the image. Used in load_graphic and load_font.
#define INVALID_IMAGE 3

// Object reference is invalid. Used in New_Object, Get & Set Prop, Load, Unload, Clear
#define INVALID_OBJECT 4

// Property passed to Set_Property or Get_Property is invalid.
#define INVALID_PROPERTY 5

// Reference does not correspond to a graphic object.  Used in Set_Button_Property.
#define INVALID_GRAPHIC 6

// Reference does not correspond to a font object.  Used in Load_Font.
#define INVALID_FONT 7

// Reference does not correspond to a textbox object. Used in Associate_Font,
// Resize_Textbox, String_To_Textbox, and Textbox_To_String
#define INVALID_TEXTBOX 8

// Reference does not correspond to a pen object.
#define INVALID_PEN 9

// Reference does not correspond to a plot object.
#define INVALID_PLOT 10

// Reference does not correspond to a screen object. Used in Load and Un_Load
#define INVALID_SCREEN 11

// Column input parameter to string_to_textbox & textbox_to_string is out of range.
// Also used in Resize_Col.
#define COLUMN_OUT_OF_RANGE 12

// Row input parameter to string_to_textbox & textbox_to_string is out of range.
// Also used in Resize_Row.
#define ROW_OUT_OF_RANGE 13

// String is longer than textbox in string_to_textbox.
#define STRING_LENGTH_OUT_OF_RANGE 14

// X must be between 0 and the screen width when specifying a location of an object
// on a screen in Load, Un_Load, and Draw.
#define X_OUT_OF_RANGE 15

// Y must be between 0 and the screen height when specifying a location of an object
// on a screen in Load, Un_Load, and Draw
#define Y_OUT_OF_RANGE 16

// The width passed to Set_Plot_Width: 0 < width <= screen width
#define WIDTH_OUT_OF_RANGE 17

// The height passed to Set_Plot_Height: 0 < height <= screen height
#define HEIGHT_OUT_OF_RANGE 18

// Out of range value passed to Set_Plot_Data: value > plot height
#define DATA_OUT_OF_RANGE 19

// The size of the buffer for a plot must be greater than or equal to the width of
// the plot.
#define BUFFER_SIZE_OUT_OF_RANGE 20

// Initialize_GUI has already been called and a gui task already exists.
#define GUI_EXISTS 21

// Flash write protection is on.  Can't program calibration coefficients into flash.
// Used in Calibrate_Touch
#define FLASH_NOT_PROGRAMMABLE 22

// There was an error reading the id from touchscreen controller in Init_Touchscreen.
#define TOUCHSCREEN_INITIALIZATION_FAILURE 23

// The specified format is invalid.
#define INVALID_IMAGE_FORMAT 24

// The buffer size is too small to render an image into.
#define BUFFER_SIZE_TOO_SMALL 25

