#define USING_QSC 0
// GUI Tools-- These #defines provide an interface between the GUI Toolkit
// and the programmer.  Information can be found in the GUI Toolkit manual.

#include <mosaic/gui_tk/to_large.h>

#ifndef __QED_GUI_TOOLS__
#define __QED_GUI_TOOLS__

#define __QED_GUI_TOOLS_VERSION__ 1.7

#define TVARS &tvars, 0

#define DRAW_MASK (GRAPHICS_MASK | DRAW_TEXTONLY_ACTION |\
ERASE_TEXTONLY_ACTION)
// BEGIN Macros

// Builds a button from the given parameters.   The text defined
// in quotes should also be on the page specified as GUI_STRINGS_PAGE
// (or in common RAM).  That shouldn't be too much of a problem since
// the strings are copied to each page anyway.


// the following are useful to transform a 32-bit xaddr into separate 16-bit addr, page
#ifndef XADDR_TO_ADDR
#define XADDR_TO_ADDR(xaddress)    ((uint) (0xFFFF & (xaddress)))
#define XADDR_TO_PAGE(xaddress)    ((int) (0xFF & ((xaddress)>>16)))

#endif  //   XADDR_TO_ADDR

// the following is useful to transform a separate 16-bit addr, page into a 32-bit xaddress
#ifndef TO_XADDR
#define TO_XADDR(address,page)     ((xaddr) (((page)<<16)+ (0xFFFF & (address))))

#endif  //   TO_XADDR


#define BLANKBUTTON( flags, draw_graphic,\
release_graphic, press_graphic, press_action,\
release_action, label1, label2, label3, label4, buttonname )\
BUTTON buttonname##_struct_={\
(flags)|C_STYLE_TEXT_FLAG,\
TO_XADDR((DO_GRAPHIC_ADDR),(DO_GRAPHIC_PAGE)),\
draw_graphic,\
release_graphic,\
press_graphic,\
press_action,\
release_action,\
(label1),\
(label2),\
(label3),\
(label4) \
}; BUTTON * buttonname=&buttonname##_struct_


// Builds a graphical button that uses direct screen I/O to handle touchscreen
// presses and releases.  Buttonname is that of the button being
// created.  Flags referes to the configuration flags for the new button.
// Draw_graphic, release_graphic, and press_graphic are pointers to the
// respective graphics.  These are usually generated by pcx2qed, a pc utility
// for generating images from pcx graphics files.  Each of these three graphics
// MUST be defined.  The func_addr is the action to be executed upon press,
// release, or both depending on which configuration flags are set.  The Labels
// are displayed inside the button if the DRAW_TEXT_FLAG is set.

#define FASTBUTTON_FLAGS \
( DRAW_GRAPHIC_FLAG |\
RELEASE_GRAPHIC_FLAG |\
DIR_RELEASE_GRAPHIC_FLAG |\
PRESS_GRAPHIC_FLAG |\
DIR_PRESS_GRAPHIC_FLAG |\
C_STYLE_TEXT_FLAG )

#define FASTBUTTON( flags,\
draw_graphic,\
release_graphic,\
press_graphic,\
action, label1, label2, label3, label4, buttonname )\
BUTTON buttonname##_struct_={\
(flags) | FASTBUTTON_FLAGS,\
TO_XADDR((DO_GRAPHIC_ADDR),(DO_GRAPHIC_PAGE)),\
draw_graphic,\
release_graphic,\
press_graphic,\
action,\
action,\
(label1),\
(label2),\
(label3),\
(label4) \
}; BUTTON * buttonname=&buttonname##_struct_



// Builds a graphical button that uses the graphics_garray to handle graphic
// presses and releases.  Buttonname is the that of the button being
// created.  Flags referes to the configuration flags for the new button.
// Draw_graphic, release_graphic, and press_graphic are pointers to the
// respective graphics.  These are usually generated by pcx2qed, a pc utility
// for generating images from pcx graphics files.  Each of these three graphics
// MUST be defined.  The func_addr is the action to be executed upon press,
// release, or both depending on which configuration flags are set.  The Labels
// are displayed inside the button if the DRAW_TEXT_FLAG is set.

#define NORMBUTTON_FLAGS \
( DRAW_GRAPHIC_FLAG |\
RELEASE_GRAPHIC_FLAG |\
PRESS_GRAPHIC_FLAG |\
C_STYLE_TEXT_FLAG )


#define NORMBUTTON( flags,\
draw_graphic,\
release_graphic,\
press_graphic,\
action, label1, label2, label3, label4, buttonname )\
BUTTON buttonname##_struct_={\
(flags) | NORMBUTTON_FLAGS,\
TO_XADDR((DO_GRAPHIC_ADDR),(DO_GRAPHIC_PAGE)),\
draw_graphic,\
release_graphic,\
press_graphic,\
action,\
action,\
(label1),\
(label2),\
(label3),\
(label4) \
}; BUTTON * buttonname=&buttonname##_struct_


// Menu building macros start here

#define BUTTON_WIDTH    8
#define BUTTON_HEIGHT   32
#define BUTTON_ROWS     4

#if USING_QSC

// this macro slightly differs from the one defined for the paneltouch
#define COLROW_TO_BUTTON( col,row )\
(((col)/BUTTON_WIDTH)*BUTTON_ROWS\
+((row)/BUTTON_HEIGHT)+1)

#else

// this macro slightly differs from the one defined for the Qscreen
#define COLROW_TO_BUTTON( col,row )\
(((col)/BUTTON_WIDTH)*BUTTON_ROWS\
+((row)/BUTTON_HEIGHT))
#endif

#define NEW_MENU MENU_ENTRY


#define SWAP_ADDR_AND_PAGE( address, page ) page, address


// Inserts a graphic into the current menu to be displayed at the screen
// offset of col,row.

#define ADD_GRAPHIC( col, row, action_mask, graphic_obj )\
{ row,\
col,\
(xaddr) graphic_obj,\
TO_XADDR(DO_GRAPHIC_ADDR,DO_GRAPHIC_PAGE),\
action_mask,\
BUTTON_NONLOCAL\
}

// Inserts a button into the current menu to be displayed at the screen
// offset of col,row and the keymap offset (button number) n.

#define ADD_BUTTON( n, col, row, action_mask, button_obj )\
{ row,\
col,\
&button_obj##_struct_,\
TO_XADDR(DO_BUTTON_ADDR,DO_BUTTON_PAGE),\
action_mask,\
n\
}

// Inserts a button into the current menu to be displayed at the screen
// offset of col,row.  The location on the touchscreen is computed
// automatically based on the col,row given.

#define ADD_TOUCH_BUTTON( col, row, action_mask, button_obj )\
{ row,\
col,\
&button_obj##_struct_,\
TO_XADDR(DO_BUTTON_ADDR,DO_BUTTON_PAGE),\
action_mask,\
COLROW_TO_BUTTON( col,row )\
}


// To be placed at the end of a menu to create the Forth array parameter
// field for the C array defined earlier.

//{ { (char *) &(arrayname##_m.xhandle.sixteen_bit.page16),\

#define BUILD_MENU( arrayname, num_elements)\
MENU arrayname##_menu_pf =\
{ { (char *) &(arrayname##_menu_pf.xhandle),\
0,\
sizeof( MENU_ENTRY ),\
1,\
num_elements,\
0,\
0,\
0 },\
(CFORTH_ARRAY *) arrayname\
}; MENU * arrayname##_menu=&arrayname##_menu_pf


// End Macros

#endif      // __QED_GUI_TOOLS__

#include <mosaic/gui_tk/fr_large.h>

// This is the header file for the GUI Software Toolkit.  JLW 4/14/1999

#include <mosaic/gui_tk/to_large.h>

#ifndef __QED_GUI_LIB__
#define __QED_GUI_LIB__

#define __QED_GUI_LIB_VERSION__ 1.7

// Additional type definitions
typedef int     boolean;
// typedef int     addr; // defined in types.h
// typedef int     page;

typedef struct {
    xaddr display_heap_top;         // The top of the display heap being used
    xaddr display_heap_bottom;      // The bottom of the display heap being used
    uint background_fill;           // The contents of this variable are filled
                                    // into the display graphics array when
                                    // clear.graphics is called.  T

    FORTH_ARRAY graphics_garray;    // We need an array for the graphics system
                                    // to use.  This array will be used by the
                                    // graphics calls in the menu system.  It
                                    // may be used by the application code also.

    xaddr display_resource;         // This resource variable manages access to
                                    // the graphics array and hardware.  This
                                    // variable is initialized by
                                    // init.dualmode.display

    uint gr_home_addr;              // Holds the address inside the display
                                    // where the graphics area begins
    uint text_home_addr;            // Holds the address inside the display
                                    // where the text area begins

    uint graphic_rows;              // The number of pixels lines on the display
    uint graphic_cols;              // The number of byte columns on the display
                                    // This depends on the setting of the hard-
                                    // ware Mode A pin on the TC6963 controller
                                    // chip. Not all LCDs bring this pin out,
                                    // but on the standard 240x128 display, it
                                    // is available
                                    // and may be set for either 6 or 8
                                    // pixels/byte.
                                    // This would cause +graphic_cols to have a
                                    // value of either 40 or 30 respectively.

    uint text_rows;                 // The number of text lines on the display
    uint text_cols;                 // The number of text columns

// Menu object globals:

    FORTH_ARRAY keymap_array;
        // The following are provided as an easy means for people to access
        // information about buttons being pressed
    uint current_row;                // The current row of the button pressed
    uint current_col;                // The current col of the button pressed

    uint current_keynum;             // The key index  of the button pressed
    xaddr current_button;            // the xpfa of the button that has just been
                                     // pressed.
#if USING_QSC
// Touchscreen globals:
    uint last_read_time;             // the last time the touchscreen was read
    uint raw_y_coord;                // current uncalibrated y coordinate
    uint raw_x_coord;                // current uncalibrated x coordinate
    uint cal_y_coord;                // current calibrated y coordinate
    uint cal_x_coord;                // current calibrated x coordinate
#endif
// Menu manager globals:
    uint repeat_delay;               // delay time before repeating in TS counts
    uint repeat_period;              // delay between repeat cycles in TS counts
} GUI_VARS;



typedef struct {                // Standard buttons will use this structure
  int flags;                    // the bitmaped flags used by the handler
                                // see above for description


  xaddr graphic_handler_xcfa;   // the xcfa to be EXECUTEd for the graphics
                                // this handler is required to process
                                // the stack picture that will be left for
                                // a graphic object.  It must be a forth
                                // and will be expected to process the the
                                // graphic class of commands.

  xaddr draw_graphic;           // the xpfa of the graphic shown on draw
  xaddr release_graphic;        // the xpfa of the graphic shown on release
  xaddr press_graphic;          // the xpfa of the graphic shown on press


  //page press_handler_page;
  void (*press_handler) ( );    // the xcfa of user code to run when on pressed

  //page release_handler_page;
  void (*release_handler) ( );  // the xcfa of user code to run when on released

                                // The above 2 xcfas may be either C or Forth
                                // given that they do not accept or return
                                // any values.  If there is a need to pass
                                // values  in or out, then global variables must
                                // be used.

        // Now, we include an optional 4 lines text that may be used.
        // These strings are expected to be forth style strings.
        // if this is a problem, then the code will be changed to accomodate
        // C style strings instead.

  char * label4;                 // line 4 text inside button (0-8 characters)
//  page label4_page;
//  char * label4;

  char * label3;                 // line 3 text inside button (0-8 characters)
//  page label3_page;
//  char * label3;

  char * label2;                 // line 2 text inside button (0-8 characters)
//  page label2_page;
//  char * label2;

  char * label1;                 // line 1 text inside button (0-8 characters)
//  page label1_page;
//  char * label4;

} BUTTON;

typedef struct { // Make a new type of structure
  int row;                      // The relative col number for the item
  int col;                      // The relative row number for the item

  BUTTON * obj_xaddr;
  //page object_page;
  //void * object;

  xaddr obj_handler;            // the xcfa of the code that handles the object

// Objects below here are not to be copied into the keymap index array
  uint action_mask;             // A mask to configure which actions may be
                                // passed through to the menu item
  uint button;                  // The relative index for button referencing
                                // +button# must correlate to the graphic
                                // location of the item for touchscreens.
                                // Otherwise, it can simply be used to specify
                                // what element in the keymap array will contain
                                // the item.
} MENU_ENTRY;


typedef struct {
  //page array_ptr_page;
  //char * array_ptr_addr;
  char * array_ptr;
  uint  pfa_currentHeap;
  uint   pfa_bytesPerElement;
  uint   pfa_numdimensions;
  uint   pfa_numCols;
  uint   pfa_numRows;
  uint   pfa_limit2;  // limit2 and limit3 are not used in 2D
  uint   pfa_limit3;  // array, but they must be allocated!
  } CFORTH_ARRAY ;

typedef struct {
  CFORTH_ARRAY arraypf;          // The array parameter field
  CFORTH_ARRAY * xhandle;
  //EXTENDED_ADDR xhandle;
//  page array_page;              // The pointer to the page of the FORTH_ARRAY
//  char * array_addr;            // The pointer to the FORTH_ARRAY
  } FORTH_CONST_ARRAY;

typedef FORTH_CONST_ARRAY MENU;

// Begin Font Stuff
// This is the font structure.  It binds 8 graphic objects into a
// font.  Each graphic object, called a tablet, represents 16 characters.
// Dividing this up makes the shape of the graphics a bit more manageable.
typedef struct {
    xaddr tablet0;
    xaddr tablet1;
    xaddr tablet2;
    xaddr tablet3;
    xaddr tablet4;
    xaddr tablet5;
    xaddr tablet6;
    xaddr tablet7;
    } FONT;

// This macro accepts TVARS and dereferences out the garray from it.
// It is better not to do that in the actual function since so that
// experts may use the low level call to render into an offscreen
// array.  This macro assumes that you want to draw into the onscreen
// GUI buffer.  The other thing this macro does is mark the string as
// a null term string so that Render_Font will know it is coming from C.

#define QUICK_RENDER_FONT(strAddr, column, row, font)\
   (Render_Font(strAddr, (THIS_PAGE+0xFF00), column, row, &tvars, 0, font, (THIS_PAGE)))

// This macro is quite similar to the above, but it must use TVARS since
// it simply direct renders to the LCD.
#define QUICK_DIRECT_RENDER_FONT(strAddr, column, row, font)\
    (Direct_Render_Font(strAddr, (THIS_PAGE+0xFF00), column, row, &tvars, 0, font, (THIS_PAGE)))

// End Font stuff



// ****Automatically generated by JLW forth to C awk script ver 5/5
// This file contains the constants that are defined in a forth program.
// This file was generated on Thu May 06 00:52:36 PDT 1999 by wadejer
// on the machine: circe.procyon.com


// Display configuration constants
#define GRAPHICS_DATA_ADDR                      0x80A0
#define GRAPHICS_CMD_ADDR                       0x80A2
#define AWSET_CMD                               0x00B0
#define AWRESET_CMD                             0x00B2
#define SET_TX_HOME_CMD                         0x0040
#define SET_TX_AREA_CMD                         0x0041
#define SET_GR_HOME_CMD                         0x0042
#define SET_GR_AREA_CMD                         0x0043
#define MODE_CMD                                0x0080
#define DISPLAY_MODE_CMD                        0x0090
#define CURSOR_BLINK                            0x0001
#define CURSOR_ON                               0x0002
#define TEXT_MODE                               0x0004
#define GRAPHICS_MODE                           0x0008
#define LCD_TEXT_ADDR                           0x0000
#define LCD_GRAPHIC_ADDR                        0x0280
#define LINES_PER_CHAR                            0008
#define GRAPHICS_COLUMNS                          0030
#define GRAPHICS_ROWS                             0128
#define TEXT_COLUMNS                              0040
#define TEXT_ROWS                                 0016
#define DISPLAY_HEAP_TOP                        0x0F46A0l
#define DISPLAY_HEAP_BOTTOM                     0x0F3000l
#define DEF_BACKGROUND_FILL                     0x0000

// Graphic Objects Constants
#define GRAPHICS_MASK                           0x001F
#define DRAW_ACTION                             0x0001
#define DIR_DRAW_ACTION                         0x0002
#define REDRAW_ACTION                           0x0004
#define ERASE_ACTION                            0x0008
#define DIR_ERASE_ACTION                        0x0010

// Button Constants
#define BUTTON_MASK                             0x03E0
#define PRESS_REPEAT_ACTION                     0x0020
#define PRESS_ACTION                            0x0040
#define REL_ACTION                              0x0080
#define DRAW_TEXTONLY_ACTION                    0x0100
#define ERASE_TEXTONLY_ACTION                   0x0200

// Button Flags
#define DRAW_GRAPHIC_FLAG                       0x0001
#define RELEASE_GRAPHIC_FLAG                    0x0002
#define PRESS_GRAPHIC_FLAG                      0x0004
#define DIR_DRAW_GRAPHIC_FLAG                   0x0008
#define DIR_RELEASE_GRAPHIC_FLAG                0x0010
#define DIR_PRESS_GRAPHIC_FLAG                  0x0020
#define DRAW_TEXT_FLAG                          0x0040
#define PRESS_HANDLER_FLAG                      0x0080
#define RELEASE_HANDLER_FLAG                    0x0100
#define REPEAT_FLAG                             0x0200
#define TEXT_UPDATE_PRESS_FLAG                  0x0400
#define TEXT_UPDATE_RELEASE_FLAG                0x0800
#define GRAPHICS_UPDATE_PRESS_FLAG              0x1000
#define GRAPHICS_UPDATE_RELEASE_FLAG            0x2000
#define C_STYLE_TEXT_FLAG                       0x4000
#ifndef BEEP_FLAG
#define BEEP_FLAG                               0x8000
#endif        
// Menu Constants
#define MENU_MASK                               0x0C00
#define INIT_ACTION                             0x0400
#define UNINIT_ACTION                           0x0800
#define BUTTON_NULL                             0xFFFF
#define BUTTON_NONLOCAL                         0xFFFE
#define DEFAULT_REPEAT_PERIOD                   0x0010
#define DEFAULT_REPEAT_DELAY                    0x0080

#endif      // __QED_GUI_LIB__
#include <mosaic/gui_tk/fr_large.h>



extern _forth  void Update_Here_With( addr address,
       addr * graphics_resource_addr,
       page graphics_resource_page,
       FORTH_ARRAY * garray_addr,
       page garray_page );

extern _forth  void Update_Graphics ( GUI_VARS * tvars_addr, page tvars_page );

extern _forth  void Update_Text( GUI_VARS * tvars_addr, page tvars_page );

extern _forth  void Update_Text_And_Graphics( GUI_VARS * tvars_addr, page tvars_page );

extern _forth  void Clear_Graphics( GUI_VARS * tvars_addr, page tvars_page );

extern _forth  void Clear_Text( GUI_VARS * tvars_addr, page tvars_page );

extern _forth  void Set_Text_Home_Addr( addr address );

extern _forth  void Set_Gr_Home_Addr( addr address );

extern _forth  void Set_Text_Area( uint columns );

extern _forth  void Set_Gr_Area( uint columns );

extern _forth  void Set_Display_Mode( uint columns );

extern _forth  void Set_Cursor_State( boolean isvisible, boolean isflashing );

extern _forth  void Set_Display_State( boolean graphics, boolean text );

extern _forth  void Set_Text_Mode( uchar modebyte );

extern _forth  void Config_Display(
       uint graphics_cols,
       uint graphics_rows,
       addr graphics_start,
       uchar background_fill,
       uint text_cols,
       uint text_rows,
       addr text_start,
       xaddr heap_bottom,
       xaddr heap_top,
       GUI_VARS * tvars_addr,
       page tvars_page );

extern _forth  void Init_Display( GUI_VARS * tvars_addr, page tvars_page );

extern _forth  void Std_Display( GUI_VARS * tvars_addr, page tvars_page );

extern _forth  void Draw_Graphic( uint col,
       uint row,
       GUI_VARS * tvars_addr,
       page tvars_page,
       xaddr graphic_addr );

extern _forth  void Direct_Draw_Graphic( uint col,
       uint row,
       GUI_VARS * tvars_addr,
       page tvars_page,
       xaddr graphic_addr );

extern _forth  void Direct_Erase_Graphic( uint col,
       uint row,
       GUI_VARS * tvars_addr,
       page tvars_page,
       xaddr graphic_addr );

extern _forth  void Erase_Graphic( uint col,
       uint row,
       GUI_VARS * tvars_addr,
       page tvars_page,
       xaddr graphic_addr );

extern _forth  void Do_Graphic ( uint col,
       uint row,
       GUI_VARS * tvars_addr,
       page tvars_page,
       uint action,
       xaddr graphic_addr );

extern _forth  void Button_Draw_Textonly( uint col,
       uint row,
       GUI_VARS * tvars_addr,
       page tvars_page,
       BUTTON * button_addr );

extern _forth  void Button_Draw( uint col,
       uint row,
       GUI_VARS * tvars_addr,
       page tvars_page,
       BUTTON * button_addr );

extern _forth  void Button_Erase_Textonly( uint col,
       uint row,
       GUI_VARS * tvars_addr,
       page tvars_page,
       BUTTON * button_addr );

extern _forth  void Button_Erase( uint col,
       uint row,
       GUI_VARS * tvars_addr,
       page tvars_page,
       BUTTON * button_addr );

extern _forth  void Button_Press( uint col,
       uint row,
       GUI_VARS * tvars_addr,
       page tvars_page,
       BUTTON * button_addr );

extern _forth  void Button_Repeat( uint col,
       uint row,
       GUI_VARS * tvars_addr,
       page tvars_page,
       BUTTON * button_addr );

extern _forth  void Button_Release( uint col,
       uint row,
       GUI_VARS * tvars_addr,
       page tvars_page,
       BUTTON * button_addr );

extern _forth  void Do_Button( uint col,
       uint row,
       GUI_VARS * tvars_addr,
       page tvars_page,
       uint action,
       BUTTON * button_addr );

extern _forth  void Do_Menu(
   uint col,
   uint row,
   GUI_VARS * tvars_addr,
   page tvars_page,
   uint action,
   MENU * menu_addr );

extern _forth  void Menu_Install( uint offset,
   uint col,
   uint row,
   GUI_VARS * tvars_addr,
   page tvars_page,
   MENU *  menu_addr );

extern _forth  void Menu_Remove(
   uint offset,
   GUI_VARS * tvars_addr,
   page tvars_page,
   MENU *  menu_addr );

extern _forth  void Init_Menu(
   uint offset,
   uint col,
   uint row,
   GUI_VARS * tvars_addr,
   page tvars_page,
   MENU * menu_addr );

extern _forth  void Uninit_Menu(
   uint offset,
   uint col,
   uint row,
   GUI_VARS * tvars_addr,
   page tvars_page,
   MENU * menu_addr );

extern _forth  void Set_Pixel ( int x, int y );

extern _forth  void Clear_Pixel(int x, int y);

extern _forth  void Service_Touch( int buttonID, GUI_VARS * tvars_addr, page tvars_page );

extern _forth  void Menu_Process(  int buttonID, GUI_VARS * tvars_addr, page tvars_page);

extern _forth  void Wait_Then_Service_Touch( GUI_VARS * tvars_addr, page tvars_page );

extern _forth  void Menu_Query(
   GUI_VARS * tvars_addr,
   page tvars_page );

extern _forth  void Init_Touch(
   GUI_VARS * tvars_addr,
   page tvars_page );

extern _forth  void Render_Font_to_buffer(  char * string_addr, page string_page,
       uint col,
       uint row,
       FORTH_ARRAY * garray_addr, page garray_page,
       FONT * font_addr,
       page font_page);

extern _forth  void Render_Font(  char * string_addr, page string_page,
       uint col,
       uint row,
       GUI_VARS * tvars_addr, page tvars_page,
       FONT * font_addr,
       page font_page);

extern _forth  void Direct_Render_Font( char * string_addr, page string_page,
       uint col,
       uint row,
       GUI_VARS * tvars_addr,page tvars_page,
       FONT * font_addr,
       page font_page);
