// This is the C header file.  It contains the prototypes and constants that
// are used in the runtime routines.  The ifndef/define lines below provide an
// interlock so that the contents of this file will be parsed exactly once
// even if it is #included in more than one place within the same source file.

// How to use this file:  Be sure to #include it before library.c.  See the
// example source files.  Only #include library.c once, but #include this file
// in any other source files that contain calls to kernel extensions.

// the following are useful to transform a 32-bit xaddr into separate 16-bit addr, page
#ifndef XADDR_TO_ADDR
#define XADDR_TO_ADDR(xaddress)    ((uint) (0xFFFF & (xaddress)))
#define XADDR_TO_PAGE(xaddress)    ((int) (0xFF & ((xaddress)>>16)))

#endif  //   XADDR_TO_ADDR

#ifndef __KERNEL_EXTENSION_HEADER_FILE__  // The #endif will be in the postamble file
#define __KERNEL_EXTENSION_HEADER_FILE__

