
#define GPS_BUFSIZE		600	// enough for 7 max-size sentence chars plus $ and crlf

#define GPS_PACIFIC_TIME	-8 // PST local_hour_offset, pass to GPS_INIT
#define GPS_MOUNTAIN_TIME	-7 // MST local_hour_offset, pass to GPS_INIT
#define GPS_CENTRAL_TIME	-6 // CST local_hour_offset, pass to GPS_INIT
#define GPS_EASTERN_TIME	-5 // EST local_hour_offset, pass to GPS_INIT
#define GPS_DAYLIGHT_TIME	+1 // ADD to specified time zone offset to get daylight savings

typedef struct gps_struct  	// holds information for this wildcard; only 1 gps per cpu!
{	xaddr	sgps_inbuf;			// holds base xaddr of buffer for sentences coming from gps
	xaddr	sgps_outbuf;		// holds base xaddr of buffer for outgoing sentences: unused!
	int	sgps_local_hour_offset;	// eg, pst (pac std time) = -8, pdt = -7
			// the following are from the $gprmc data from gps sensor:
	int	sgps_utc_hour;			// 00-23 hour
	int	sgps_utc_date;			// 01-31 date of the month
	int	sgps_utc_month;			// 01-12 month of the year
	int	sgps_utc_year;			// 00-99 2-digit year
	int	sgps_local_second;		// 00-59 seconds after minute; utc_second = local_second
	int	sgps_local_minute;		// 00-59 minutes after hour; utc_minute = local_minute
	int	sgps_local_hour;			// 00-23 hour = (utc_hour + local_time_hour_offset) mod 24
	int	sgps_local_date;			// 01-31 date of the month, result of utclocal conversion
	int	sgps_local_month;		// 01-12 month of the year, result of utclocal conversion
	int	sgps_local_year;			// 00-99 2-digit year, result of utclocal conversion
	int	sgps_position_valid;		// holds boolean flag; fld: 'a'=valid pos; 'V'=rcvr warning
	int	sgps_lat_degrees;		// 00-89 degrees latitude
	int	sgps_lat_minutes_intpart; // 00-59 integer latitude minutes
	int	sgps_lat_minutes_fraction; // .xxxx latitude minutes fractional part (ten-thousandths)
	int	sgps_lat_hemisphere;		// ascii 'N' or 'S'
	int	sgps_long_degrees;			// 000-179 degrees longitude
	int	sgps_long_minutes_intpart;	// 00-59 integer longitude minutes
	int	sgps_long_minutes_fraction; // .xxxx longitude minutes fraction part (ten-thousandths)
	int	sgps_long_hemisphere;		// ascii 'E' or 'W'
	int	sgps_tenth_knots;		// = 0-9999 speed over ground; field = 000.0 to 999.9 knots
	int	sgps_course_tenth_degrees;	// = 0-3599 course; field= 000.0 to 359.9 degrees true
	int	sgps_mag_var_tenth_degrees;	// 0-1800 magnetic variation, field= 000.0 to 180.0 degrees
	int	sgps_mag_var_direction; // ascii 'E' or 'W' mag var dir;west var adds to true course
		// the following is from the $gpgsv data from gps sensor:
	int	sgps_numsats_in_view;		// 00-12
		// the following are from the $gpgga data from gps sensor:
	int	sgps_fix_quality;	// contains binary: 0= fix not available; 1 = non-diff fix avail
	int	sgps_numsats_in_use;		// 00-12 = number of satellites in use
	double sgps_altitude_tenth_meters;	// field = -9999.9 to 99999.9 meters rel to SeaLev
			// the following are from the $pgrme data from gps sensor:
	int	sgps_hor_error_tenth_meters;	// 0-9999 est horiz pos err; field=0.0 to 999.9 meters
	int	sgps_vert_error_tenth_meters; // 0-9999 est vert pos err; field = 0.0 to 999.9 meters
	int	sgps_position_error_tenth_meters; // 0-9999 overall pos err; field=0.0 to 999.9 meters
} GPS_STRUCT


extern _forth  xaddr GPS_Inbuf ( void );

extern _forth  int GPS_Good_Fix ( void );

extern _forth  int GPS_Lat_Degrees ( void );

extern _forth  long GPS_Lat_Minutes_Times_10000 ( void );

extern _forth  char GPS_Lat_Hemisphere ( void );

extern _forth  int GPS_Long_Degrees ( void );

extern _forth  long GPS_Long_Minutes_Times_10000 ( void );

extern _forth  char GPS_Long_Hemisphere ( void );

extern _forth  long GPS_Altitude_Meters_Times_10 ( void );

extern _forth  int GPS_Knots_Times_10 ( void );

extern _forth  int GPS_Course_Degrees_Times_10 ( void );

extern _forth  int GPS_Numsats_In_Use ( void );

extern _forth  int GPS_Numsats_In_View ( void );

extern _forth  void GPS_Struct_Init ( xaddr gps_info_xbase, xaddr inbuf, int local_hour_offset );

extern _forth  void GPS_Default_UART_Init ( int module_num );

extern _forth  int GPS_Init ( int local_hour_offset, int module_num );

extern _forth  void GPS_Shutdown ( int shutdown_flag, int module_num );

extern _forth  int GPS_Get_Frame(xaddr bufbase,int starting_os,int max_os,int numsentences,int module_num);

extern _forth  int GPS_Next_Frame ( int module_num );

extern _forth  int GPS_Parse_Sats_In_View ( xaddr buf, int dollar_os, int maxchars );

extern _forth  int GPS_Get_Sats_In_View ( xaddr buf, int maxchars );

extern _forth  int GPS_Parse_Pos_Speed_Course_Time ( xaddr buf, int dollar_os, int maxchars );

extern _forth  int GPS_Get_Pos_Speed_Course_Time ( xaddr buf,  int maxchars );

extern _forth  int GPS_Parse_Altitude_Fix_Numsats ( xaddr buf, int dollar_os, int maxchars );

extern _forth  int GPS_Get_Altitude_Fix_Numsats ( xaddr buf, int maxchars );

extern _forth  int GPS_Parse_Pos_Errors ( xaddr buf, int dollar_os, int maxchars );

extern _forth  int GPS_Get_Pos_Errors ( xaddr buf, int maxchars );

extern _forth  void GPS_Info_Dump ( void );

extern _forth  void GPS_Dump ( int module_num );

extern _forth  int GPS_Frame_Extract ( xaddr buf, int numchars_received );

extern _forth  int GPS_Update ( int module_num );
