#define HTTP_TEXT_HTML_CONTENT		-1	// text/html; charset=utf-8  (default)
#define HTTP_TEXT_PLAIN_CONTENT		0	// text/plain; charset=utf-8
#define HTTP_IMAGE_BITMAP_CONTENT	1	// image/bmp
#define HTTP_IMAGE_PNG_CONTENT		2	// image/png
#define HTTP_IMAGE_GIF_CONTENT		3	// image/gif
#define HTTP_IMAGE_JPG_CONTENT		4	// image/jpeg
#define HTTP_BINARY_DATA_CONTENT	5	// application/octet-stream
#define HTTP_JAVASCRIPT_CONTENT	6	// application/javascript
#define HTTP_TEXT_CSS_CONTENT		7	// text/css; charset=utf-8

#define ETHER_BUFSIZE_DEFAULT 510	// allotted buffer is 512, leaving room for 2byte lcount
#define HTTP_OUTBUFSIZE_DEFAULT 1400 // =max xport TCP payload size, +2byte count =1402
#define HTTP_AUTOSERVE_DEFAULT_ROWS 32	// default #rows in autoserve array, used by setup

#define ETHER_MIN_BUFFER_SIZE 320 // enforced by ether_init for ether_inbuf, ether_outbuf

#define	WIFI_NO_SECURITY		  00 // used to turn off any security/authentication option
// the following are passed as the pairwise_encrypt_method to wifi_security routine:
#define	WIFI_WEP64_PAIR_ENCRYPT	  01
#define	WIFI_WEP128_PAIR_ENCRYPT  02
#define	WIFI_TKIP_PAIR_ENCRYPT	  03
#define	WIFI_CCMP_PAIR_ENCRYPT	  04
// the following are passed as the suite_method to wifi_security routine:
#define	WIFI_WEP_SUITE			  01
#define	WIFI_WPA_SUITE			  02
#define	WIFI_WPA2_SUITE			  03
// the following are passed as the group_encrypt_method to wifi_security routine:
#define	WIFI_WEP_GROUP_ENCRYPT	  01
#define	WIFI_TKIP_GROUP_ENCRYPT	  03
#define	WIFI_CCMP_GROUP_ENCRYPT	  04

_at(ether_revector_module_XADDR) extern  int ether_revector_module;

_at(ether_service_module_XADDR) extern  int ether_service_module;

_at(ether_command_XADDR) extern  ulong ether_command;

_at(ether_response_XADDR) extern  ulong ether_response;

_at(ether_gui_message_XADDR) extern  ulong ether_gui_message;

extern _forth  void WiFi_Module ( int modulenum );

extern _forth  xaddr Ether_Info ( int modulenum );

extern _forth  int WiFi_Check ( int modulenum );

extern _forth  xaddr Ether_My_IP_Ptr ( int modulenum );

extern _forth  xaddr Ether_Gateway_IP_Ptr ( int modulenum );

extern _forth  xaddr Ether_Netmask_Ptr ( int modulenum );

extern _forth  xaddr Ether_Inbuf ( int modulenum );

extern _forth  xaddr Ether_Outbuf ( int modulenum );

extern _forth  uint Ether_Outbufsize ( int modulenum );

extern _forth  uint Ether_Inbufsize ( int modulenum );

extern _forth  void Ether_Set_Inbuf ( xaddr bufbase, int maxnumbytes, int modulenum );

extern _forth  void Ether_Set_Outbuf ( xaddr xbufbase, int maxnumbytes, int modulenum );

extern _forth  xaddr HTTP_Inbuf ( int modulenum );

extern _forth  xaddr HTTP_Outbuf ( int modulenum );

extern _forth  uint HTTP_Outbufsize ( int modulenum );

extern _forth  uint HTTP_Inbufsize ( int modulenum );

extern _forth  void HTTP_Set_Inbuf ( xaddr xbufbase, int maxnumbytes, int modulenum );

extern _forth  void HTTP_Set_Outbuf ( xaddr bufbase, int maxnumbytes, int modulenum );

extern _forth  uint Ether_Error ( int modulenum );

extern _forth  void Ether_Error_Clear ( int modulenum );

extern _forth  xaddr HTTP_Enable_Ptr ( int modulenum );

extern _forth  xaddr Ether_Tunnel_Enable_Ptr ( int modulenum );

extern _forth  uint HTTP_Numbytes_Sent ( int modulenum );

extern _forth  xaddr HTTP_Status_Ptr ( int modulenum );

extern _forth  xaddr HTTP_Timeout_Msec_Ptr ( int modulenum );

extern _forth  xaddr HTTP_Get_Timeout_Msec_Ptr ( int modulenum );

extern _forth  xaddr HTTP_Index_Ptr ( int modulenum );

extern _forth  void HTTP_Is_Autoserve_Array ( xaddr xarraybase, int numrows, int modulenum );

extern _forth  xaddr HTTP_Autoserve_Ptr ( int modulenum );

extern _forth  xaddr HTTP_URL_Ptr ( int modulenum );

extern _forth  int HTTP_URL_Full_Count ( int modulenum );

extern _forth  int HTTP_URL_Base_Count ( int modulenum );

extern _forth  void Ether_Local_IP ( char ip1, char ip2, char ip3, char ip4, int modulenum );

extern _forth  void Ether_Local_Port ( int portnum, int modulenum );

extern _forth  void Ether_Internal_Webserver_Port ( int portnum, int modulenum );

extern _forth  void Ether_Gateway ( char ip1,char ip2,char ip3,char ip4, int subnet_bits, int modulenum );

extern _forth  xaddr Ether_Remote_IP_Ptr ( int modulenum );

extern _forth  xaddr Ether_Remote_Port_Ptr ( int modulenum );

extern _forth  void Ether_DHCP_Name ( xaddr xname_string, int name_cnt, int modulenum );

extern _forth  void Ether_Telnet_Password ( xaddr xpassword_string, int password_cnt, int modulenum );

extern _forth  void Ether_TCP_Control ( char keepalive_sec, char discon_minutes, int send_imm_chars, char flushmode, char packing, int modulenum );

extern _forth  void WiFi_Security ( int authenticate_flag, int suite_method, int pairwise_encrypt_method,	int group_encrypt_method, int key_length, int passphrase_flag, int modulenum );

extern _forth  void WiFi_SSID ( xaddr ssid_buffer_xbase, int count, int modulenum );

extern _forth  void WiFi_Options ( int tx_power_level, int tx_power_manager_flag, int tx_rate, int tx_auto_rate_flag, int adhoc_flag, int adhoc_chan, int modulenum );

extern _forth  void Ether_Cat (xaddr cntedLStrAddr, uint maxChars, xaddr strToAdd, int cntToAdd, uint eol);

extern _forth  void Cat (xaddr countedLStrAddr, uint maxChars, xaddr strToAdd, int cntToAdd, uint eol);

extern _forth  void Ether_Outbuf_Cat ( xaddr xstring, uint count, int modulenum );

extern _forth  void HTTP_Outbuf_Cat ( xaddr xstring, uint count, int modulenum );

extern _forth  void Ether_Emit ( uchar character,  int modulenum );

extern _forth  int Ether_Ask_Emit ( int modulenum );

extern _forth  int Ether_Ask_Key ( int modulenum );

extern _forth  uchar Ether_Key ( int modulenum );

extern _forth  uchar Ether_ASCII_Key ( int modulenum );

extern _forth  void E_Emit ( uchar character );

extern _forth  int E_Ask_Key ( void );

extern _forth  uchar E_Key ( void );

extern _forth  uchar E_ASCII_Key ( void );

extern _forth  void Ether_Shutdown ( int modulenum );

extern _forth  int Ether_Ready_For_Command ( int modulenum );

extern _forth  ulong Ether_Await_Response ( int modulenum );

extern _forth  ulong Ether_Check_Response ( int modulenum );

extern _forth  int Ether_Connect_Status ( int modulenum );

extern _forth  int Ether_Passive_Non_Web_Connection ( int modulenum );

extern _forth  int WS_Is_Open ( int modulenum );

extern _forth  int Ether_Disconnect_During_Send ( int modulenum );

extern _forth  void Ether_Flush_NBytes ( uint maxbytes, uint timeout_msec, int modulenum );

extern _forth  void Ether_Flush ( int modulenum );

extern _forth  void Ether_Add_Data ( xaddr xlbuffer, uint maxbytes, uint timeout_msec, int modulenum );

extern _forth  void Ether_Get_Data ( xaddr xlbuffer, uint maxbytes, uint timeout_msec, int modulenum );

extern _forth  void Ether_Add_Chars ( xaddr xlbuffer, uint maxbytes, uint maxlines, char eol, int discard_alt_eol, int discard_msbit_set, uint timeout_msec, int modulenum );

extern _forth  void Ether_Get_Chars ( xaddr xlbuffer, uint maxbytes, uint maxlines, char eol, int discard_alt_eol, int discard_msbit_set, uint timeout_msec, int modulenum );

extern _forth  void Ether_Get_Line ( xaddr xlbuffer, uint maxbytes, char eol, int discard_alt_eol, int discard_msbit_set, uint timeout_msec, int modulenum );

extern _forth  void Ether_Add_Line ( xaddr xlbuffer, uint maxbytes, char eol, int discard_alt_eol, int discard_msbit_set, uint timeout_msec, int modulenum );

extern _forth  void Ether_Send_Buffer ( xaddr xbuffer, uint count, uint timeout_msec, int modulenum );

extern _forth  void Ether_Send_LBuffer ( xaddr xlbuffer, uint timeout_msec, int modulenum );

extern _forth  void Ether_Send_2Buffers ( xaddr xbuffer1, uint count1, xaddr xbuffer2, uint count2, uint timeout_msec, int modulenum );

extern _forth  int Ether_Encryption ( xaddr key_buffer_xbase, int num_key_bytes, int modulenum );

extern _forth  int WiFi_Encryption_Key ( xaddr key_buffer_xbase, int num_key_bytes, int modulenum );

extern _forth  void Ether_XPort_Defaults ( int modulenum );

extern _forth  void Ether_XPort_Update ( int modulenum );

extern _forth  void Ether_Ping_Request ( char ip1, char ip2, char ip3, char ip4, int modulenum );

extern _forth  void Ether_Ping_Report ( char ip1, char ip2, char ip3, char ip4, int modulenum );

extern _forth  void Ether_IP_Info_Request ( int modulenum );

extern _forth  void Ether_IP_Info_Report ( int modulenum );

extern _forth  void Ether_Disconnect ( int modulenum );

extern _forth  void Ether_Disconnect_Flush ( int modulenum );

extern _forth  void Ether_Connect ( char ip1, char ip2, char ip3, char ip4, int port, int modulenum );

extern _forth  void Ether_Send_Email ( xaddr xemail_body,uint bodycnt,xaddr xhost,int hostcnt, xaddr xsender,int sendercnt,xaddr xrcvr, int rcvrcnt,xaddr xscratchbuf, char dest_ip1,char ip2,char ip3,char ip4,int destport,uint timeout_ms,int module);

extern _forth  int HTTP_Add_Handler ( xaddr url_xstring, int url_count, xaddr (*handler_ptr)(void), int modulenum );

extern _forth  int HTTP_Root( (*handler_ptr)(void), int modulenum );

extern _forth  int HTTP_Add_GUI_Handler ( xaddr url_xstring, int url_count, xaddr (*handler_ptr)(void), int modulenum );

extern _forth  xaddr HTTP_Fieldname_Ptr ( int modulenum );

extern _forth  int HTTP_Fieldname_Count ( int modulenum );

extern _forth  xaddr HTTP_Value_Ptr ( int modulenum );

extern _forth  int HTTP_Value_Count ( int modulenum );

extern _forth  int HTTP_To_Next_Field ( int modulenum );

extern _forth  ulong HTTP_Imagemap ( int modulenum );

extern _forth  void HTTP_Plus_To_Space ( xaddr xstring, int count );

extern _forth  int HTTP_Unescape ( xaddr xstring, int count );

extern _forth  void HTTP_Parse_URL ( xaddr xstring, int count, int modulenum );

extern _forth  uint HTTP_Send_Buffer ( xaddr xbuffer, uint count, int modulenum );

extern _forth  uint HTTP_Send_LBuffer ( xaddr xlbuffer, int modulenum );

extern _forth  long HTTP_Send_Many ( xaddr xbuffer, long count, int modulenum );

extern _forth  uint HTTP_Send_Cstring ( xaddr xbuffer, int modulenum );

extern _forth  long HTTP_Send_Base64 ( xaddr xbuffer, long count, int modulenum );

extern _forth  void HTTP_GUI_Send_Buffer ( xaddr xbuffer, uint count, int modulenum );

extern _forth  void HTTP_GUI_Send_LBuffer ( xaddr xlbuffer, int modulenum );

extern _forth  void HTTP_GUI_Send_2Buffers ( xaddr xbuffer1, uint count1, xaddr xbuffer2, uint count2, int modulenum );

extern _forth  void HTTP_Put_Headers ( xaddr xlbuffer, uint bufsize, int is_ok, int dynamic, int content_type );

extern _forth  uint HTTP_Send_HTML_Headers ( int dynamic, int modulenum );

extern _forth  uint HTTP_Send_Headstart ( xaddr title, int t_cnt, xaddr favicon, int f_cnt, int mod );

extern _forth  long HTTP_Send_Code ( xaddr xbuffer, long count, int content_type, int modulenum );

extern _forth  long HTTP_Send_Img ( xaddr img_data, long img_cnt, int content_type, xaddr alt_text, int alt_cnt, int modulenum );

extern _forth  void HTTP_Default_Handler ( int modulenum );

extern _forth  void HTTP_Server ( int modulenum );

extern _forth  int Ether_Check_GUI ( int modulenum );

extern _forth  uint Ether_Info_Init ( xaddr xinfo,xaddr xautoserve,int numrows,xaddr xbuffer_area_base, xaddr xcmdmail,xaddr xresponsemail,xaddr xguimail,uint etherinbufsize, uint etheroutbufsize,uint httpinbufsize,uint httpoutbufsize,int modulenum);

extern _forth  uint WiFi_Info_Init ( xaddr xinfo,xaddr xautoserve,int numrows,xaddr xbuffer_area_base, xaddr xcmdmail,xaddr xresponsemail,xaddr xguimail,uint etherinbufsize, uint etheroutbufsize,uint httpinbufsize,uint httpoutbufsize,int modulenum);

extern _forth  uint Ether_Init ( xaddr xinfo,xaddr xautoserve,int numrows,xaddr xbuffer_area_base, xaddr xcmdmail,xaddr xresponsemail,xaddr xguimail,uint etherinbufsize, uint etheroutbufsize,uint httpinbufsize,uint httpoutbufsize,int modulenum);

extern _forth  uint WiFi_Init ( xaddr xinfo,xaddr xautoserve,int numrows,xaddr xbuffer_area_base, xaddr xcmdmail,xaddr xresponsemail,xaddr xguimail,uint etherinbufsize, uint etheroutbufsize,uint httpinbufsize,uint httpoutbufsize,int modulenum);

extern _forth  uint Ether_Setup ( xaddr xbuffer_area_base, addr mailbox_base, int modulenum );

extern _forth  uint WiFi_Setup ( xaddr xbuffer_area_base, addr mailbox_base, int modulenum );

extern _forth  uint Ether_Setup_Default ( int modulenum );

extern _forth  uint WiFi_Setup_Default ( int modulenum );

extern _forth  void Ether_Command_Manager ( int modulenum );

extern _forth  void Ether_Connection_Manager ( int modulenum );

extern _forth  void Ether_Service_Loop ( void );

extern _forth  xaddr Ether_Service_Loop_Xcfa ( void );

extern _forth  void Ether_Serial_Revector ( void );

extern _forth  void Ether_Monitor ( void );

extern _forth  xaddr Ether_Monitor_Xcfa ( void );

extern _forth  void Ether_Task_Setup ( TASK* task_base, int modulenum );

extern _forth  void WiFi_Task_Setup ( TASK* task_base, int modulenum );
