
_at(xfat_info_save_XADDR)  xaddr xfat_info_save;

_at(cf_module_XADDR)   int cf_module;

_at(pcc_resource_XADDR)  xaddr  pcc_resource;

_forth  void  Set_CF_Module( int module )
{
#asm
    dey
    dey
    dey
    dey
    ldx #SET_CF_MODULE_ADDR
    stx 2,y
    ldx #SET_CF_MODULE_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int  Read_CF_Module( void )
{
#asm
    dey
    dey
    dey
    dey
    ldx #READ_CF_MODULE_ADDR
    stx 2,y
    ldx #READ_CF_MODULE_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth    xaddr FI( void )
{
#asm
    dey
    dey
    dey
    dey
    ldx #FI_ADDR
    stx 2,y
    ldx #FI_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int PCC_Present( void )
{
#asm
    dey
    dey
    dey
    dey
    ldx #PCC_PRESENT_ADDR
    stx 2,y
    ldx #PCC_PRESENT_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int ATA_Fail ( void )
{
#asm
    dey
    dey
    dey
    dey
    ldx #ATA_FAIL_ADDR
    stx 2,y
    ldx #ATA_FAIL_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int Hidden_Sectors ( void )
{
#asm
    dey
    dey
    dey
    dey
    ldx #HIDDEN_SECTORS_ADDR
    stx 2,y
    ldx #HIDDEN_SECTORS_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int NumSectors_Transferred ( void )
{
#asm
    dey
    dey
    dey
    dey
    ldx #NUMSECTORS_TRANSFERRED_ADDR
    stx 2,y
    ldx #NUMSECTORS_TRANSFERRED_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  ulong Card_Size ( void )
{
#asm
    dey
    dey
    dey
    dey
    ldx #CARD_SIZE_ADDR
    stx 2,y
    ldx #CARD_SIZE_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int ATA_Command( xaddr buffer, ulong startsector, uint numsectors,         int cmd, int transfer_type, int features )
{
#asm
    dey
    dey
    dey
    dey
    ldx #ATA_COMMAND_ADDR
    stx 2,y
    ldx #ATA_COMMAND_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int ATA_Write( xaddr buffer, ulong startsector, uint numsectors )
{
#asm
    dey
    dey
    dey
    dey
    ldx #ATA_WRITE_ADDR
    stx 2,y
    ldx #ATA_WRITE_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int ATA_Read( xaddr buffer, ulong startsector, uint numsectors )
{
#asm
    dey
    dey
    dey
    dey
    ldx #ATA_READ_ADDR
    stx 2,y
    ldx #ATA_READ_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int ATA_ID_Drive( xaddr buffer )
{
#asm
    dey
    dey
    dey
    dey
    ldx #ATA_ID_DRIVE_ADDR
    stx 2,y
    ldx #ATA_ID_DRIVE_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int ATA_Set_Features( int config_contents, int features )
{
#asm
    dey
    dey
    dey
    dey
    ldx #ATA_SET_FEATURES_ADDR
    stx 2,y
    ldx #ATA_SET_FEATURES_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int Init_File_Heap( uint maxopen_files, uint file_bufsize,           xaddr heap_start, xaddr xheap_end )
{
#asm
    dey
    dey
    dey
    dey
    ldx #INIT_FILE_HEAP_ADDR
    stx 2,y
    ldx #INIT_FILE_HEAP_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  xaddr File_Contents( int file_position, int file_id )
{
#asm
    dey
    dey
    dey
    dey
    ldx #FILE_CONTENTS_ADDR
    stx 2,y
    ldx #FILE_CONTENTS_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  ulong Max_File_Size( void )
{
#asm
    dey
    dey
    dey
    dey
    ldx #MAX_FILE_SIZE_ADDR
    stx 2,y
    ldx #MAX_FILE_SIZE_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  ulong File_Size( int file_id )
{
#asm
    dey
    dey
    dey
    dey
    ldx #FILE_SIZE_ADDR
    stx 2,y
    ldx #FILE_SIZE_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  uint Volume_Label( char* string_addr, uint string_page )
{
#asm
    dey
    dey
    dey
    dey
    ldx #VOLUME_LABEL_ADDR
    stx 2,y
    ldx #VOLUME_LABEL_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Clear_File_Error( int file_id )
{
#asm
    dey
    dey
    dey
    dey
    ldx #CLEAR_FILE_ERROR_ADDR
    stx 2,y
    ldx #CLEAR_FILE_ERROR_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int File_Error( int file_id )
{
#asm
    dey
    dey
    dey
    dey
    ldx #FILE_ERROR_ADDR
    stx 2,y
    ldx #FILE_ERROR_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int File_EOF( int file_id )
{
#asm
    dey
    dey
    dey
    dey
    ldx #FILE_EOF_ADDR
    stx 2,y
    ldx #FILE_EOF_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  uint Report_File_Open_Errors( char* stringaddr, uint stringpage, uint maxbytes )
{
#asm
    dey
    dey
    dey
    dey
    ldx #REPORT_FILE_OPEN_ERRORS_ADDR
    stx 2,y
    ldx #REPORT_FILE_OPEN_ERRORS_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  uint Report_File_Errors( int fileid, char* stringaddr, uint stringpage,            uint maxbytes )
{
#asm
    dey
    dey
    dey
    dey
    ldx #REPORT_FILE_ERRORS_ADDR
    stx 2,y
    ldx #REPORT_FILE_ERRORS_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  xaddr File_Time( int file_id )
{
#asm
    dey
    dey
    dey
    dey
    ldx #FILE_TIME_ADDR
    stx 2,y
    ldx #FILE_TIME_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Dir( void )
{
#asm
    dey
    dey
    dey
    dey
    ldx #DIR_ADDR
    stx 2,y
    ldx #DIR_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Dir_Names( void )
{
#asm
    dey
    dey
    dey
    dey
    ldx #DIR_NAMES_ADDR
    stx 2,y
    ldx #DIR_NAMES_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Dir_Open( void )
{
#asm
    dey
    dey
    dey
    dey
    ldx #DIR_OPEN_ADDR
    stx 2,y
    ldx #DIR_OPEN_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int Set_Filesize( ulong size, int file_id )
{
#asm
    dey
    dey
    dey
    dey
    ldx #SET_FILESIZE_ADDR
    stx 2,y
    ldx #SET_FILESIZE_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int File_Flush( int file_id )
{
#asm
    dey
    dey
    dey
    dey
    ldx #FILE_FLUSH_ADDR
    stx 2,y
    ldx #FILE_FLUSH_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int File_Seek( int file_id, long offset, int mode )
{
#asm
    dey
    dey
    dey
    dey
    ldx #FILE_SEEK_ADDR
    stx 2,y
    ldx #FILE_SEEK_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int File_Set_Pos( int file_id, long offset )
{
#asm
    dey
    dey
    dey
    dey
    ldx #FILE_SET_POS_ADDR
    stx 2,y
    ldx #FILE_SET_POS_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int File_Rewind( int file_id )
{
#asm
    dey
    dey
    dey
    dey
    ldx #FILE_REWIND_ADDR
    stx 2,y
    ldx #FILE_REWIND_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  long File_Tell_Pos( int file_id )
{
#asm
    dey
    dey
    dey
    dey
    ldx #FILE_TELL_POS_ADDR
    stx 2,y
    ldx #FILE_TELL_POS_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int File_Close( int file_id )
{
#asm
    dey
    dey
    dey
    dey
    ldx #FILE_CLOSE_ADDR
    stx 2,y
    ldx #FILE_CLOSE_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int File_Open( char* name_addr, uint name_page, int name_count, int access_mode )
{
#asm
    dey
    dey
    dey
    dey
    ldx #FILE_OPEN_ADDR
    stx 2,y
    ldx #FILE_OPEN_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  long File_Write( void* source_addr, uint source_page, ulong numbytes, int file_id )
{
#asm
    dey
    dey
    dey
    dey
    ldx #FILE_WRITE_ADDR
    stx 2,y
    ldx #FILE_WRITE_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  long File_Read( void* dest_addr, uint dest_page, ulong numbytes, int file_id )
{
#asm
    dey
    dey
    dey
    dey
    ldx #FILE_READ_ADDR
    stx 2,y
    ldx #FILE_READ_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int File_Remove( char* name_addr, uint name_page, int name_count )
{
#asm
    dey
    dey
    dey
    dey
    ldx #FILE_REMOVE_ADDR
    stx 2,y
    ldx #FILE_REMOVE_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int File_Rename( char* prior_string_addr, uint prior_string_page, int prior_count, char* new_string_addr, uint new_string_page, int new_count )
{
#asm
    dey
    dey
    dey
    dey
    ldx #FILE_RENAME_ADDR
    stx 2,y
    ldx #FILE_RENAME_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int File_Copy( char* prior_string_addr, uint prior_string_page,     int prior_string_count,     char* new_string_addr, uint new_string_page, int new_string_count )
{
#asm
    dey
    dey
    dey
    dey
    ldx #FILE_COPY_ADDR
    stx 2,y
    ldx #FILE_COPY_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void File_Type( char* name_addr, uint name_page, int name_count )
{
#asm
    dey
    dey
    dey
    dey
    ldx #FILE_TYPE_ADDR
    stx 2,y
    ldx #FILE_TYPE_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  long File_To_Memory( void* dest_addr, uint dest_page, ulong numbytes, int file_id )
{
#asm
    dey
    dey
    dey
    dey
    ldx #FILE_TO_MEMORY_ADDR
    stx 2,y
    ldx #FILE_TO_MEMORY_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void File_To_Page( uint dest_page )
{
#asm
    dey
    dey
    dey
    dey
    ldx #FILE_TO_PAGE_ADDR
    stx 2,y
    ldx #FILE_TO_PAGE_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Page_To_File( uint source_page )
{
#asm
    dey
    dey
    dey
    dey
    ldx #PAGE_TO_FILE_ADDR
    stx 2,y
    ldx #PAGE_TO_FILE_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int File_Getc( int file_id )
{
#asm
    dey
    dey
    dey
    dey
    ldx #FILE_GETC_ADDR
    stx 2,y
    ldx #FILE_GETC_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int File_Putc( char c, int file_id )
{
#asm
    dey
    dey
    dey
    dey
    ldx #FILE_PUTC_ADDR
    stx 2,y
    ldx #FILE_PUTC_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int File_Gets( char* string_addr, uint string_page, uint bufsize, int file_id )
{
#asm
    dey
    dey
    dey
    dey
    ldx #FILE_GETS_ADDR
    stx 2,y
    ldx #FILE_GETS_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int File_Puts( char* source_addr, uint source_page, uint maxchars, int file_id )
{
#asm
    dey
    dey
    dey
    dey
    ldx #FILE_PUTS_ADDR
    stx 2,y
    ldx #FILE_PUTS_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int File_Ungetc( char c, int file_id )
{
#asm
    dey
    dey
    dey
    dey
    ldx #FILE_UNGETC_ADDR
    stx 2,y
    ldx #FILE_UNGETC_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int File_Put_CRLF( int file_id )
{
#asm
    dey
    dey
    dey
    dey
    ldx #FILE_PUT_CRLF_ADDR
    stx 2,y
    ldx #FILE_PUT_CRLF_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int File_Capture( int fileid )
{
#asm
    dey
    dey
    dey
    dey
    ldx #FILE_CAPTURE_ADDR
    stx 2,y
    ldx #FILE_CAPTURE_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void End_Update( void )
{
#asm
    dey
    dey
    dey
    dey
    ldx #END_UPDATE_ADDR
    stx 2,y
    ldx #END_UPDATE_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void File_Interpreter( void )
{
#asm
    dey
    dey
    dey
    dey
    ldx #FILE_INTERPRETER_ADDR
    stx 2,y
    ldx #FILE_INTERPRETER_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  uchar File_Key( void )
{
#asm
    dey
    dey
    dey
    dey
    ldx #FILE_KEY_ADDR
    stx 2,y
    ldx #FILE_KEY_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int File_Ask_Key( void )
{
#asm
    dey
    dey
    dey
    dey
    ldx #FILE_ASK_KEY_ADDR
    stx 2,y
    ldx #FILE_ASK_KEY_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void File_Emit( char c )
{
#asm
    dey
    dey
    dey
    dey
    ldx #FILE_EMIT_ADDR
    stx 2,y
    ldx #FILE_EMIT_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Put_Default_Serial( void )
{
#asm
    dey
    dey
    dey
    dey
    ldx #PUT_DEFAULT_SERIAL_ADDR
    stx 2,y
    ldx #PUT_DEFAULT_SERIAL_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void File_Abort_Action( void )
{
#asm
    dey
    dey
    dey
    dey
    ldx #FILE_ABORT_ACTION_ADDR
    stx 2,y
    ldx #FILE_ABORT_ACTION_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Redirect( int input_file_id, int output_file_id, void(*fn)(), uint fn_page)
{
#asm
    dey
    dey
    dey
    dey
    ldx #REDIRECT_ADDR
    stx 2,y
    ldx #REDIRECT_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Process_File( int input_file_id, int output_file_id )
{
#asm
    dey
    dey
    dey
    dey
    ldx #PROCESS_FILE_ADDR
    stx 2,y
    ldx #PROCESS_FILE_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int Process_Autoexec( int autoexec_echo )
{
#asm
    dey
    dey
    dey
    dey
    ldx #PROCESS_AUTOEXEC_ADDR
    stx 2,y
    ldx #PROCESS_AUTOEXEC_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int Init_File_IO( uint max_open_files, uint file_bufsize,         xaddr heap_start, xaddr heap_end, xaddr xfat_info )
{
#asm
    dey
    dey
    dey
    dey
    ldx #INIT_FILE_IO_ADDR
    stx 2,y
    ldx #INIT_FILE_IO_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int Init_File_System( void )
{
#asm
    dey
    dey
    dey
    dey
    ldx #INIT_FILE_SYSTEM_ADDR
    stx 2,y
    ldx #INIT_FILE_SYSTEM_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Do_Autoexec( void )
{
#asm
    dey
    dey
    dey
    dey
    ldx #DO_AUTOEXEC_ADDR
    stx 2,y
    ldx #DO_AUTOEXEC_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}
