
extern _forth  void  Set_CF_Module( int module );

extern _forth  int  Read_CF_Module( void );

extern _forth    xaddr FI( void );

extern _forth  int PCC_Present( void );
#define SECTOR_SIZE 512
#define FAIL_ID_DRIVE  0x100
#define FAIL_BUSY      0x80
#define FAIL_READY     0x40
#define FAIL_DATAREQ   0x20
#define FAIL_EXT_ERR   0x10
#define FAIL_CMD       0x08
#define FAIL_ADDR      0x04
#define FAIL_NO_CARD   0x02
#define FAIL_ARGS      0x01


extern _forth  int ATA_Fail ( void );

extern _forth  int Hidden_Sectors ( void );

extern _forth  int NumSectors_Transferred ( void );

extern _forth  ulong Card_Size ( void );

extern _forth  int ATA_Command( xaddr buffer, ulong startsector, uint numsectors,         int cmd, int transfer_type, int features );

extern _forth  int ATA_Write( xaddr buffer, ulong startsector, uint numsectors );

extern _forth  int ATA_Read( xaddr buffer, ulong startsector, uint numsectors );

extern _forth  int ATA_ID_Drive( xaddr buffer );

extern _forth  int ATA_Set_Features( int config_contents, int features );

// Result Failure Flags (may be OR'd together)
#define  ERR_ATA_READ                0x01
#define  ERR_ATA_WRITE               0x02
#define  ERR_NOT_DOSFAT_DRIVE        0x04
#define  ERR_INVALID_SECTOR_NUMBER   0x08
#define  ERR_CANNOT_ADD_CLUSTER      0x10
#define  ERR_NEGATIVE_FILE_POSN      0x20
#define  ERR_WRITE_ACCESS_VIOLATION  0x40
#define  ERR_READ_ACCESS_VIOLATION   0x80
#define  ERR_FAIL_ID_DRIVE           0x100

// the following are saved in +file_open_error; set in file_open, check_fileid
#define  ERR_CANNOT_TRUNCATE_FILE    0x200
#define  ERR_FILE_DOES_NOT_EXIST     0x400
#define  ERR_ROOT_DIR_FULL           0x800
#define  ERR_DISK_IS_FULL            0x1000
#define  ERR_TOO_MANY_FILES_OPEN     0x2000
#define  ERR_BAD_OR_UNOPEN_FILEID    0x4000
// final standard error flag, saved in ata_file struct:
#define  ERR_EOF                     0x8000

// file pointer modes for file_seek and its callers:
#define  FROM_START                  1
#define  FROM_END                    2
#define  FROM_CURRENT                3

#define  FILE_MUST_EXIST       0x01  // r and r+ modes: file must exist before open
#define  OLD_FILE_TRUNCATED    0x02  // w and w+ modes: truncate to 0 upon open
#define  READABLE_STREAM       0x04  // r, r+, w+, a+ modes
#define  WRITEABLE_STREAM      0x08  // w, a, r+, w+, a+ modes
#define  WRITEABLE_AT_END_ONLY 0x10  // a, a+ modes; writes start at prior eof.


#define  R_MODE     (FILE_MUST_EXIST | READABLE_STREAM)
#define  W_MODE     (OLD_FILE_TRUNCATED | WRITEABLE_STREAM)
#define  A_MODE     (WRITEABLE_STREAM | WRITEABLE_AT_END_ONLY)
#define  RPLUS_MODE (FILE_MUST_EXIST | READABLE_STREAM | WRITEABLE_STREAM)
#define  WPLUS_MODE (OLD_FILE_TRUNCATED | READABLE_STREAM | WRITEABLE_STREAM)
#define  APLUS_MODE (READABLE_STREAM | WRITEABLE_STREAM | WRITEABLE_AT_END_ONLY)


#define NO_ECHO_FILEID  -2
// passed as output_fileid to process_file to revector emit as drop.

extern _forth  int Init_File_Heap( uint maxopen_files, uint file_bufsize,           xaddr heap_start, xaddr xheap_end );

extern _forth  ulong File_Contents( int file_position, int file_id );

extern _forth  ulong Max_File_Size( void );

extern _forth  ulong File_Size( int file_id );

extern _forth  uint Volume_Label( char* string_addr, uint string_page );

extern _forth  void Clear_File_Error( int file_id );

extern _forth  int File_Error( int file_id );

extern _forth  int File_EOF( int file_id );

extern _forth  uint Report_File_Open_Errors( char* stringaddr, uint stringpage, uint maxbytes );

extern _forth  uint Report_File_Errors( int fileid, char* stringaddr, uint stringpage,            uint maxbytes );

extern _forth  xaddr File_Time( int file_id );

extern _forth  void Dir( void );

extern _forth  void Dir_Names( void );

extern _forth  void Dir_Open( void );

extern _forth  int Set_Filesize( ulong size, int file_id );

extern _forth  int File_Flush( int file_id );

extern _forth  int File_Seek( int file_id, long offset, int mode );

extern _forth  int File_Set_Pos( int file_id, long offset );

extern _forth  int File_Rewind( int file_id );

extern _forth  long File_Tell_Pos( int file_id );

extern _forth  int File_Close( int file_id );

extern _forth  int File_Open( char* name_addr, uint name_page, int name_count, int access_mode );

extern _forth  long File_Write( void* source_addr, uint source_page, ulong numbytes, int file_id );

extern _forth  long File_Read( void* dest_addr, uint dest_page, ulong numbytes, int file_id );

extern _forth  int File_Remove( char* name_addr, uint name_page, int name_count );

extern _forth  int File_Rename( char* prior_string_addr, uint prior_string_page, int prior_count, char* new_string_addr, uint new_string_page, int new_count );

extern _forth  int File_Copy( char* prior_string_addr, uint prior_string_page,     int prior_string_count,     char* new_string_addr, uint new_string_page, int new_string_count );

extern _forth  void File_Type( char* name_addr, uint name_page, int name_count );

extern _forth  long File_To_Memory( void* dest_addr, uint dest_page, ulong numbytes, int file_id );

extern _forth  void File_To_Page( uint dest_page );

extern _forth  void Page_To_File( uint source_page );

extern _forth  int File_Getc( int file_id );

extern _forth  int File_Putc( char c, int file_id );

extern _forth  int File_Gets( char* string_addr, uint string_page, uint bufsize, int file_id );

extern _forth  int File_Puts( char* source_addr, uint source_page, uint maxchars, int file_id );

extern _forth  int File_Ungetc( char c, int file_id );

extern _forth  int File_Put_CRLF( int file_id );

extern _forth  int File_Capture( int fileid );

extern _forth  void End_Update( void );

extern _forth  void File_Interpreter( void );

extern _forth  uchar File_Key( void );

extern _forth  int File_Ask_Key( void );

extern _forth  void File_Emit( char c );

extern _forth  void Put_Default_Serial( void );

extern _forth  void File_Abort_Action( void );

extern _forth  void Redirect( int input_file_id, int output_file_id, void(*fn)(), uint fn_page);

extern _forth  void Process_File( int input_file_id, int output_file_id );

extern _forth  int Process_Autoexec( int autoexec_echo );

extern _forth  int Init_File_IO( uint max_open_files, uint file_bufsize,         xaddr heap_start, xaddr heap_end, xaddr xfat_info );

extern _forth  int Init_File_System( void );

extern _forth  void Do_Autoexec( void );
