#define  MODULE0           0 // valid modules
#define  MODULE1           1
#define  MODULE2           2
#define  MODULE3           3
#define  MODULE4           4
#define  MODULE5           5
#define  MODULE6           6
#define  MODULE7           7

#define  CH_0_7            0 // valid channels
#define  CH_1_7            1
#define  CH_2_7            2
#define  CH_3_7            3
#define  CH_4_7            4
#define  CH_5_7            5
#define  CH_0_1            6
#define  CH_2_3            7
#define  CH_4_5            8
#define  CH_6_7            9
#define  TEST_MODE         10

#define  NORMAL_MODE       0x00 // valid calibrations
#define  SELF_CAL          0x20
#define  ZERO_SELF_CAL     0xC0
#define  FS_SELF_CAL       0xE0
#define  BACKGND_CAL       0xA0
#define  ZERO_SYS_CAL      0x40
#define  FS_SYS_CAL        0x60
#define  SYS_OFFSET_CAL    0x80

#define  GAIN_1            0x00 // valid gains
#define  GAIN_2            0x04
#define  GAIN_4            0x08
#define  GAIN_8            0x0C
#define  GAIN_16           0x10
#define  GAIN_32           0x14
#define  GAIN_64           0x18
#define  GAIN_128          0x1C

#define  BO_ON             0x02 // valid configuration options
#define  BO_OFF            0x00
#define  FSYNC_ON          0x01
#define  FSYNC_OFF         0x00
#define  UNIPOLAR          0x80
#define  BIPOLAR           0x00
#define  WORD_24BIT        0x40
#define  WORD_16BIT        0x00
#define  BOOST_ON          0x20
#define  BOOST_OFF         0x00

#define  INVALID_GAIN      1 // error flags
#define  INVALID_FREQ      2
#define  INVALID_CAL       3
#define  INVALID_CHANNEL   4
#define  INVALID_FSYNC     5
#define  INVALID_BO        6
#define  INVALID_SIZE      7
#define  INVALID_POLARITY  8
#define  TIMEOUT_ERROR     9


extern _forth  void Buffer_On ( void );

extern _forth  void Buffer_Off ( void );

extern _forth  void Sync ( void );

extern _forth  char Read_Digital_IO ( void );

extern _forth  void Use_Onboard_Ref ( void );

extern _forth  void Use_External_Ref ( void );

extern _forth  void Stop_Conversion ( void );

extern _forth  void Software_Reset ( void );

extern _forth  void Reset_AD24 ( void );

extern _forth  ulong AD24_Sample ( void );

extern _forth  ulong AD24_Sample_NP ( void );

extern _forth  int AD24_Multiple ( uint num_sample, xaddr starting_xaddr );

extern _forth  ulong Read_Zero_Cal ( void );

extern _forth  ulong Read_FS_Cal ( void );

extern _forth  int Start_Conversion( char cal_type, uint freq_int, char gain, char pol, char res,
 char bo, char ch );

extern _forth  void Start_Conv_With_Values ( ulong fs_cal_val, ulong zero_cal_val, uint freq_int,
 char gain, char pol, char res, char bo, char fysnc, char ch );

extern _forth  int Init_AD24 ( char module_number );
