
// ******************************** Object Types *******************************

// Used with New_Object method to create a new instance of the object.
#define GRAPHIC 1
#define FONT    2
#define TEXTBOX 3
#define PEN     4
#define PLOT    5
#define BUTTON  6
#define SCREEN  7
#define DATA_ENTRY_KEY 8
#define ACTION_KEY     9
#define SHIFT_KEY      10

// ********************* Pre-instantiated object indicies **********************

// These objects are initialized in Initialize_GUI.
#define GUI_TOOLKIT     0
#define GUI_ERROR       1
#define GUI_DISPLAY     2
#define GUI_TOUCHSCREEN 3
#define GUI_SCREEN0     4
#define GUI_SCREEN1     5
#define GUI_SCREEN2     6
#define GUI_SCREEN3     7
// #define GUI_SCREEN4     8 // Not available for the handheld.
// #define GUI_SCREEN5     9
#define GUI_PEN         10
#define GUI_FONT        11
#define GUI_BUZZER      12
#define GUI_KEYPAD0     13
#define GUI_KEYPAD1     14
#define GUI_KEYPAD2     15
#define GUI_KEYPAD3     16
#define GUI_BATTERY     17
#define GUI_TIMER       18

// **************************** Properties of Objects **************************

// Object properties used by Get_Property or Set_Property
#define WIDTH_IN_PIXELS         0 // Read or write depending on the object.
#define HEIGHT_IN_PIXELS        1 // Read or write depending on the object.

// GUI Ojbect properties.
#define HORIZONTAL_SNAP_TO_GRID 2 // Read only, always true.
#define VERTICAL_SNAP_TO_GRID   3 // Read or write.
#define SERVICE_EVENTS          4 // Read or write.
#define STANDARD_FONT           5 // Read or write.
#define AVAILABLE_HEAP_SPACE    6 // Read only.
#define CURRENT_SCREEN          7 // Read only.

// Error object properties
#define ERROR_CODE              8 // Read or write.
#define ABORT_ON_ERROR          9 // Read or write.

// Buzzer object properties
#define BUZZER_ON               10 // Read or write.
#define BEEP_TIME               11 // Read or write.  In TCNTs (2us).

// Display object properties.
#define BACKLIGHT_ON            12 // Read or write.
#define INVERT_DISPLAY          13 // Read or write.
#define BLANK_DISPLAY           14 // Read or write.
#define CONTRAST                15 // Read or write.
#define BRIGHT_BACKLIGHT        16 // Read or write.

// Touchscreen object properties
#define LAST_EVENT              17 // Read only.
#define RAW_COORDS              18 // Read only.
#define CAL_COORDS              19 // Read only.

// Graphic and Font object property for image data.
#define IMAGE                   20 // Read or write.
#define FONT_WIDTH_DATA         21 // Read or write.

// Textbox object properties
#define TEXTBOX_FONT            22 // Read or write.
#define BORDER                  23 // Read or write. Draws a 1 pixel border around object.
#define INVERT                  24 // Read or write.
#define RENDER                  25 // Read or write.
#define TEXTBOX_ROWS            26 // Read only.
#define STRING_LENGTH           27 // Read only.
#define FIRST_VISIBLE_LINE      28 // Read or write.
#define STRING_LINES            29 // Read only.

// Button object properties
#define DRAW_GRAPHIC            30 // Read or write.
#define PRESS_GRAPHIC           31 // Read or write.
#define RELEASE_GRAPHIC         32 // Read or write.
#define PRESS_EVENT_PROCEDURE   33 // Read or write.
#define HOLD_EVENT_PROCEDURE    34 // Read or write.
#define RELEASE_EVENT_PROCEDURE 35 // Read or write.
#define BUTTON_TEXTBOX          36 // Read or write.
#define BEEP_ON_PRESS           37 // Read or write.
#define BEEP_ON_RELEASE         38 // Read or write.
#define BEEP_ON_HOLD            39 // Read or write.
#define BLOCK_ON_PRESS          40 // Read or write.
#define BLOCK_ON_HOLD           41 // Read or write.
#define BLOCK_ON_RELEASE        42 // Read or write.

// Plot object properties
#define BUFFER_SIZE             43 // Read or write. Size of the data buffer in bytes.

// Screen object properties
#define VISIBLE                 44 // Read only.
#define IN_DISPLAY              45 // Read only.
#define NUM_OBJECTS             46 // Reads num objects in the screen.
#define SCREEN_ADDRESS          47 // Reads address of the screen where data is located.

// Pen object properties
#define TARGET_SCREEN           48 // Read or Write. Screen that pen is drawing to.
#define PEN_TYPE                49 // Read or Write. Set to draw, unset to erase.
#define SHAPE                   50 // Read or Write. Pixel or line.
#define LAST_COORDS             51 // Read only.

// Keypad object properties
#define KEY_POSITION            52 // Read only.
#define PRIOR_KEY_POS           53 // Read only.
#define KEY_CODE                54 // Read only.
#define PRIOR_KEY_CODE          55 // Read only.
#define KEY_EVENT               56 // Read only.
#define PRIOR_KEY_EVENT         57 // Read only.
#define KEY_TYPE                58 // Read only.
#define PRIOR_KEY_TYPE          59 // Read only.
#define PRESS_NUMBER            60 // Read only.
#define KEYPAD_BEEP             61 // Read or write.
#define KEYPAD_BEEP_DURATION    62 // Read or write.
#define SHIFT_STATE             63 // Read or write.
#define DATA_ENTRY_EVENT_PROCEDURE     64 // Read or write.
#define INT_DATA_ENTRY_EVENT_PROCEDURE 65 // Read or write.
#define SHIFT_EVENT_PROCEDURE          66 // Read or write.
#define DATA_ENTRY_TEXTBOX             67 // Read or write.
#define SHIFT_STATE_TEXTBOX            68 // Read or write.

// Data Entry Key Properties
#define NUM_SHIFT_UP_VALUES     69 // Read only.
#define SHIFT_UP_VALUE0         70 // Read or write.
#define SHIFT_UP_VALUE1         71 // Read or write.
#define SHIFT_UP_VALUE2         72 // Read or write.
#define SHIFT_UP_VALUE3         73 // Read or write.
#define SHIFT_UP_VALUE4         74 // Read or write.
#define NUM_SHIFT_DOWN_VALUES   75 // Read only.
#define SHIFT_DOWN_VALUE0       76 // Read or write.
#define SHIFT_DOWN_VALUE1       77 // Read or write.
#define SHIFT_DOWN_VALUE2       78 // Read or write.
#define SHIFT_DOWN_VALUE3       79 // Read or write.
#define SHIFT_DOWN_VALUE4       80 // Read or write.
#define SHIFT_NEUTRAL_VALUE     81 // Read or write.

// Action Key Properties (Uses properties from the button object)

// Shift Key Properties
#define SHIFT_TYPE              82 // Read or write.
#define SHIFT_TOGGLE            83 // Read or write.

// Battery Properties
#define BATTERY_VOLTAGE         84 // Read only.
#define BATTERY_CURRENT         85 // Read only.
#define CHARGER_STATE           86 // Read only.
#define BATTERY_STATE           87 // Read only.


// -------------------------- Misc constants -----------------------------------

// Valuess for pen object properties.  All values are 32 bit numbers.
#define SET   0L          // option for PEN_TYPE to draw a pixel or line.
#define UNSET 1L          // option for PEN_TYPE to erase a pixel or line.

#define POINT 0L          // option for SHAPE to draw or erase a point.
#define LINE  1L          // option for SHAPE to draw or erase a line.

#define INVALID_INDEX -1  // index returned by init_touch or init_display if
                          // there were problems with the initialization.

// Values for the KEY_EVENT and PRIOR_KEY_EVENT property of the keypad object.
// These are 32 bit versions of the events.
#define NO_EVENT      0x0000L
#define PRESS_EVENT   0x1000L
#define HOLD_EVENT    0x2000L
#define RELEASE_EVENT 0x3000L

// Values for the KEY_TYPE and PRIOR_KEY_TYPE property of the keypad object.
// Other values include ACTION_KEY, DATA_ENTRY_KEY, and SHIFT_KEY
#define NO_KEY  0

#define GUI_TRUE   0xFFFFFFFFL // 32 bit value for true. Used in get & set property
#define GUI_FALSE  0x0L        // 32 bit value for false.  Used in get & set property

// Constants used with the Set_Property method to specify the shift key type of
// the shift key object.  The shift key allows users to access additional values
// (up to 5) for data entry keys.
#define SHIFT_NEUTRAL 0x00L
#define SHIFT_UP      0x01L
#define SHIFT_DOWN    0x02L

// Constants used to indicate the battery level and charge state of the battery object.
#define NO_BATTERY       0x00L
#define LOW_BATTERY      0x01L
#define MEDIUM_BATTERY   0x02L
#define FULL_BATTERY     0x03L

// -------------------------- Error constants -----------------------------------

#define NO_ERROR 0

// There was an error reading the id from display controller in Init_Display.
#define DISPLAY_INITIALIZATION_FAILURE 1

// The heap is full.  No room to allocate new objects or resize current ones.
#define HEAP_FULL 2

// Checksum failed for the header of the image. Used in load_graphic and load_font.
#define INVALID_IMAGE 3

// Object reference is invalid. Used in New_Object, Get & Set Prop, Load, Unload, Clear
#define INVALID_OBJECT 4

// Property passed to Set_Property or Get_Property is invalid.
#define INVALID_PROPERTY 5

// Reference does not correspond to a graphic object.  Used in Set_Button_Property.
#define INVALID_GRAPHIC 6

// Reference does not correspond to a font object.  Used in Load_Font.
#define INVALID_FONT 7

// Reference does not correspond to a textbox object. Used in Associate_Font,
// Resize_Textbox, String_To_Textbox, and Textbox_To_String
#define INVALID_TEXTBOX 8

// Reference does not correspond to a pen object.
#define INVALID_PEN 9

// Reference does not correspond to a plot object.
#define INVALID_PLOT 10

// Reference does not correspond to a screen object. Used in Load and Un_Load
#define INVALID_SCREEN 11

// The line number passed to the scrolling textbox to display is not valid.
#define LINE_OUT_OF_RANGE 12

// X must be between 0 and the screen width when specifying a location of an object
// on a screen in Load, Un_Load, and Draw.
#define X_OUT_OF_RANGE 13

// Y must be between 0 and the screen height when specifying a location of an object
// on a screen in Load, Un_Load, and Draw
#define Y_OUT_OF_RANGE 14

// The width passed to Set_Plot_Width: 0 < width <= screen width
#define WIDTH_OUT_OF_RANGE 15

// The height passed to Set_Plot_Height: 0 < height <= screen height
#define HEIGHT_OUT_OF_RANGE 16

// Out of range value passed to Set_Plot_Data: value > plot height
#define DATA_OUT_OF_RANGE 17

// The size of the buffer for a plot must be greater than or equal to the width of
// the plot.
#define BUFFER_SIZE_OUT_OF_RANGE 18

// Initialize_GUI has already been called and a gui task already exists.
#define GUI_EXISTS 19

// Flash write protection is on.  Can't program calibration coefficients into flash.
// Used in Calibrate_Touch
#define FLASH_NOT_PROGRAMMABLE 20

// GUI_SHIFT_UP, GUI_SHIFT_DOWN, or GUI_SHIFT_NEUTRAL was not used with Set_Property.
// Used in Set_Property for Shift Key Objects and for the shift state of the keypad.
#define INVALID_SHIFT_VALUE 21

// The reference does not correspond to a key object.  Used in the Insert Key method.
#define INVALID_KEY 22

// Out of range key position passed to Insert_Key.
#define KEY_POS_OUT_OF_RANGE 23

// The reference does not correspond to a keypad object.  Used in the Insert Key method.
#define INVALID_KEYPAD 24

