
extern _forth  uchar IO_Fetch_Char ( int offset, int module_num );

extern _forth  void IO_Store_Char ( uchar byte, int offset, int module_num );

extern _forth  void IO_Change_Bits ( uchar data, uchar mask, int offset, int module_num );

extern _forth  void IO_Set_Bits ( uchar mask, int offset, int module_num );

extern _forth  void IO_Clear_Bits ( uchar mask, int offset, int module_num );
// put published C constant #defines here:

// ******* CONSTANTS FOR DIGITAL I/O WILDCARD *******

// Note that line designators incorporated into constant names are in decimal base

// Register offsets:
#define DATA_0_3    0x00  // i/o data register
#define DATA_4_7    0x01  // i/o data register
#define DATA_8_11   0x02  // i/o data register
#define DATA_12_15    0x03  // i/o data register
#define DATA_16_19    0x04  // input data register
#define DIR_REG     0x05  // direction register {1=output; 0 = input = default}

// masks to set direction of nibbles via direction register {1=output; 0 = input}:
#define DIR_0_3     0x01
#define DIR_4_7     0x02
#define DIR_8_11    0x04
#define DIR_12_15   0x08
            // lines 16-19 are always inputs

// masks for setting/clearing bits in the associated data register:
#define LINE_0      0x01
#define LINE_1      0x02
#define LINE_2      0x04
#define LINE_3      0x08
#define LINE_4      0x01
#define LINE_5      0x02
#define LINE_6      0x04
#define LINE_7      0x08
#define LINE_8      0x01
#define LINE_9      0x02
#define LINE_10     0x04
#define LINE_11     0x08
#define LINE_12     0x01
#define LINE_13     0x02
#define LINE_14     0x04
#define LINE_15     0x08
#define LINE_16     0x01   // lines 16-19 always inputs, masks allow bit testing
#define LINE_17     0x02
#define LINE_18     0x04
#define LINE_19     0x08

// ********* CONSTANTS FOR AC & DC RELAY WILDCARDS  ************

// NOTE: The AC and DC Relay Wildcards use ACTIVE LOW LOGIC.
//  Thus, to activate/turn on/close the contacts of a relay, write a 1 to it.
//  To deactivate/turn off/open the contacts of a relay, write a 0 to it.
//  After a power up or hardware restart, relays are in the off state.


// Register offsets
#define RELAY_DATA    0x00  // relay data register. pins are always outputs.

// masks for setting/clearing bits in the associated data register:
#define RELAY_0     0x01
#define RELAY_1     0x02
#define RELAY_2     0x04
#define RELAY_3     0x08  // not present on dc relay wildcard


// ******* CONSTANTS FOR POWER I/O WILDCARD *******

// Register offsets
#define POWER_OUT_DATA    0x00  // 8-channel output data register
#define POWER_IN_DATA   0x01  // 4-channel input data register

// masks for setting/clearing bits in the associated data register:
#define POWER_OUT_0     0x01
#define POWER_OUT_1     0x02
#define POWER_OUT_2     0x04
#define POWER_OUT_3     0x08
#define POWER_OUT_4     0x10
#define POWER_OUT_5     0x20
#define POWER_OUT_6     0x40
#define POWER_OUT_7     0x80
#define POWER_IN_0      0x01  // input masks allow bit testing
#define POWER_IN_1      0x02
#define POWER_IN_2      0x04
#define POWER_IN_3      0x08


