
_forth  void Buffer_On ( void )
{
#asm
    dey
    dey
    dey
    dey
    ldx #BUFFER_ON_ADDR
    stx 2,y
    ldx #BUFFER_ON_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Buffer_Off ( void )
{
#asm
    dey
    dey
    dey
    dey
    ldx #BUFFER_OFF_ADDR
    stx 2,y
    ldx #BUFFER_OFF_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Sync ( void )
{
#asm
    dey
    dey
    dey
    dey
    ldx #SYNC_ADDR
    stx 2,y
    ldx #SYNC_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  char Read_Digital_IO ( void )
{
#asm
    dey
    dey
    dey
    dey
    ldx #READ_DIGITAL_IO_ADDR
    stx 2,y
    ldx #READ_DIGITAL_IO_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Use_Onboard_Ref ( void )
{
#asm
    dey
    dey
    dey
    dey
    ldx #USE_ONBOARD_REF_ADDR
    stx 2,y
    ldx #USE_ONBOARD_REF_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Use_External_Ref ( void )
{
#asm
    dey
    dey
    dey
    dey
    ldx #USE_EXTERNAL_REF_ADDR
    stx 2,y
    ldx #USE_EXTERNAL_REF_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Stop_Conversion ( void )
{
#asm
    dey
    dey
    dey
    dey
    ldx #STOP_CONVERSION_ADDR
    stx 2,y
    ldx #STOP_CONVERSION_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Software_Reset ( void )
{
#asm
    dey
    dey
    dey
    dey
    ldx #SOFTWARE_RESET_ADDR
    stx 2,y
    ldx #SOFTWARE_RESET_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Reset_AD24 ( void )
{
#asm
    dey
    dey
    dey
    dey
    ldx #RESET_AD24_ADDR
    stx 2,y
    ldx #RESET_AD24_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  ulong AD24_Sample ( void )
{
#asm
    dey
    dey
    dey
    dey
    ldx #AD24_SAMPLE_ADDR
    stx 2,y
    ldx #AD24_SAMPLE_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  ulong AD24_Sample_NP ( void )
{
#asm
    dey
    dey
    dey
    dey
    ldx #AD24_SAMPLE_NP_ADDR
    stx 2,y
    ldx #AD24_SAMPLE_NP_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int AD24_Multiple ( uint num_sample, xaddr starting_xaddr )
{
#asm
    dey
    dey
    dey
    dey
    ldx #AD24_MULTIPLE_ADDR
    stx 2,y
    ldx #AD24_MULTIPLE_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  ulong Read_Zero_Cal ( void )
{
#asm
    dey
    dey
    dey
    dey
    ldx #READ_ZERO_CAL_ADDR
    stx 2,y
    ldx #READ_ZERO_CAL_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  ulong Read_FS_Cal ( void )
{
#asm
    dey
    dey
    dey
    dey
    ldx #READ_FS_CAL_ADDR
    stx 2,y
    ldx #READ_FS_CAL_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int Start_Conversion( char cal_type, uint freq_int, char gain, char pol, char res,
 char bo, char ch )
{
#asm
    dey
    dey
    dey
    dey
    ldx #START_CONVERSION_ADDR
    stx 2,y
    ldx #START_CONVERSION_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Start_Conv_With_Values ( ulong fs_cal_val, ulong zero_cal_val, uint freq_int,
 char gain, char pol, char res, char bo, char fysnc, char ch )
{
#asm
    dey
    dey
    dey
    dey
    ldx #START_CONV_WITH_VALUES_ADDR
    stx 2,y
    ldx #START_CONV_WITH_VALUES_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int Init_AD24 ( char module_number )
{
#asm
    dey
    dey
    dey
    dey
    ldx #INIT_AD24_ADDR
    stx 2,y
    ldx #INIT_AD24_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}
