// serial channel (port) designators:
#define CHANNEL1     0x01
#define CHANNEL2     0x02

// used to specify protocol:
#define NOT_USED     0x00  // if a channel is not used, it can be powered down
#define RS485        0x21  // must share a set bit with rs422! see Set_Protocols.

// config_reg bit masks, also used to specify protocol (see Set_Protocols):
#define RS422        0x01  // note: rs485 is distinguished from rs422 only by direction_reg
#define RS232        0x02  // bits must be exclusive compared to rs422, rs485

// used to specify parity; numeric values pertain to the line_control_reg:
#define NO_PARITY    0x00     // parity disabled
#define EVEN_PARITY  0x18     // even parity enabled
#define ODD_PARITY   0x08     // odd parity enabled
#define LOW_PARITY   0x38     // parity enabled, parity bit is always 0 at uart
#define HIGH_PARITY  0x28     // parity enabled, parity bit is always 1 at uart

extern _forth  void RS485_Xmit_UART ( int channel_num, int module_num );

extern _forth  void RS485_Rcv_UART ( int channel_num, int module_num );

extern _forth  void Loop_Until_Xmit_Done ( int channel_num, int module_num );

extern _forth  void Wait_Until_Xmit_Done ( int channel_num, int module_num );

extern _forth  void RS485_Rcv_When_Xmit_Done ( int channel_num, int module_num );

extern _forth  void Send_Break ( int channel_num, int module_num );

extern _forth  void End_Break ( int channel_num, int module_num );

extern _forth  void Is_DTR ( int desired_state, int module_num );

extern _forth  void Is_RTS ( int desired_state, int module_num );

extern _forth  int Read_CTS ( int channel_num );

extern _forth  int Read_DSR ( int module_num );

extern _forth  int Read_DCD ( int module_num );

extern _forth  void Set_UART_Number ( int module_num );

extern _forth  int Read_UART_Number ( void );

extern _forth  void Set_Baud ( uint baud, int channel_num, int module_num );

extern _forth  void Set_Data_Format (int numbits, int numStopBits, int parity_code,   int channel_num, int module_num );

extern _forth  int Set_Protocols ( int Ch1_modem_support, int Ch1_protocol,   int Ch2_protocol, int module_num );

extern _forth  void Emit_UART ( uchar character, int channel_num, int module_num );

extern _forth  int Ask_Key_UART ( int channel_num, int module_num );

extern _forth  uchar Key_UART ( int channel_num, int module_num );

extern _forth  void Ch1_Emit ( uchar character );

extern _forth  void Ch2_Emit ( uchar character );

extern _forth  int Ch1_Ask_Key ( void );

extern _forth  int Ch2_Ask_Key ( void );

extern _forth  uchar Ch1_Key ( void );

extern _forth  uchar Ch2_Key ( void );
