
_forth  void RS485_Xmit_UART ( int channel_num, int module_num )
{
#asm
    dey
    dey
    dey
    dey
    ldx #RS485_XMIT_UART_ADDR
    stx 2,y
    ldx #RS485_XMIT_UART_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void RS485_Rcv_UART ( int channel_num, int module_num )
{
#asm
    dey
    dey
    dey
    dey
    ldx #RS485_RCV_UART_ADDR
    stx 2,y
    ldx #RS485_RCV_UART_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Loop_Until_Xmit_Done ( int channel_num, int module_num )
{
#asm
    dey
    dey
    dey
    dey
    ldx #LOOP_UNTIL_XMIT_DONE_ADDR
    stx 2,y
    ldx #LOOP_UNTIL_XMIT_DONE_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Wait_Until_Xmit_Done ( int channel_num, int module_num )
{
#asm
    dey
    dey
    dey
    dey
    ldx #WAIT_UNTIL_XMIT_DONE_ADDR
    stx 2,y
    ldx #WAIT_UNTIL_XMIT_DONE_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void RS485_Rcv_When_Xmit_Done ( int channel_num, int module_num )
{
#asm
    dey
    dey
    dey
    dey
    ldx #RS485_RCV_WHEN_XMIT_DONE_ADDR
    stx 2,y
    ldx #RS485_RCV_WHEN_XMIT_DONE_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Send_Break ( int channel_num, int module_num )
{
#asm
    dey
    dey
    dey
    dey
    ldx #SEND_BREAK_ADDR
    stx 2,y
    ldx #SEND_BREAK_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void End_Break ( int channel_num, int module_num )
{
#asm
    dey
    dey
    dey
    dey
    ldx #END_BREAK_ADDR
    stx 2,y
    ldx #END_BREAK_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Is_DTR ( int desired_state, int module_num )
{
#asm
    dey
    dey
    dey
    dey
    ldx #IS_DTR_ADDR
    stx 2,y
    ldx #IS_DTR_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Is_RTS ( int desired_state, int module_num )
{
#asm
    dey
    dey
    dey
    dey
    ldx #IS_RTS_ADDR
    stx 2,y
    ldx #IS_RTS_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int Read_CTS ( int channel_num )
{
#asm
    dey
    dey
    dey
    dey
    ldx #READ_CTS_ADDR
    stx 2,y
    ldx #READ_CTS_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int Read_DSR ( int module_num )
{
#asm
    dey
    dey
    dey
    dey
    ldx #READ_DSR_ADDR
    stx 2,y
    ldx #READ_DSR_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int Read_DCD ( int module_num )
{
#asm
    dey
    dey
    dey
    dey
    ldx #READ_DCD_ADDR
    stx 2,y
    ldx #READ_DCD_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Set_UART_Number ( int module_num )
{
#asm
    dey
    dey
    dey
    dey
    ldx #SET_UART_NUMBER_ADDR
    stx 2,y
    ldx #SET_UART_NUMBER_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int Read_UART_Number ( void )
{
#asm
    dey
    dey
    dey
    dey
    ldx #READ_UART_NUMBER_ADDR
    stx 2,y
    ldx #READ_UART_NUMBER_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Set_Baud ( uint baud, int channel_num, int module_num )
{
#asm
    dey
    dey
    dey
    dey
    ldx #SET_BAUD_ADDR
    stx 2,y
    ldx #SET_BAUD_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Set_Data_Format (int numbits, int numStopBits, int parity_code,
   int channel_num, int module_num )
{
#asm
    dey
    dey
    dey
    dey
    ldx #SET_DATA_FORMAT_ADDR
    stx 2,y
    ldx #SET_DATA_FORMAT_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int Set_Protocols ( int Ch1_modem_support, int Ch1_protocol,
   int Ch2_protocol, int module_num )
{
#asm
    dey
    dey
    dey
    dey
    ldx #SET_PROTOCOLS_ADDR
    stx 2,y
    ldx #SET_PROTOCOLS_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Emit_UART ( uchar character, int channel_num, int module_num )
{
#asm
    dey
    dey
    dey
    dey
    ldx #EMIT_UART_ADDR
    stx 2,y
    ldx #EMIT_UART_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int Ask_Key_UART ( int channel_num, int module_num )
{
#asm
    dey
    dey
    dey
    dey
    ldx #ASK_KEY_UART_ADDR
    stx 2,y
    ldx #ASK_KEY_UART_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  uchar Key_UART ( int channel_num, int module_num )
{
#asm
    dey
    dey
    dey
    dey
    ldx #KEY_UART_ADDR
    stx 2,y
    ldx #KEY_UART_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Ch1_Emit ( uchar character )
{
#asm
    dey
    dey
    dey
    dey
    ldx #CH1_EMIT_ADDR
    stx 2,y
    ldx #CH1_EMIT_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Ch2_Emit ( uchar character )
{
#asm
    dey
    dey
    dey
    dey
    ldx #CH2_EMIT_ADDR
    stx 2,y
    ldx #CH2_EMIT_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int Ch1_Ask_Key ( void )
{
#asm
    dey
    dey
    dey
    dey
    ldx #CH1_ASK_KEY_ADDR
    stx 2,y
    ldx #CH1_ASK_KEY_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int Ch2_Ask_Key ( void )
{
#asm
    dey
    dey
    dey
    dey
    ldx #CH2_ASK_KEY_ADDR
    stx 2,y
    ldx #CH2_ASK_KEY_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  uchar Ch1_Key ( void )
{
#asm
    dey
    dey
    dey
    dey
    ldx #CH1_KEY_ADDR
    stx 2,y
    ldx #CH1_KEY_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  uchar Ch2_Key ( void )
{
#asm
    dey
    dey
    dey
    dey
    ldx #CH2_KEY_ADDR
    stx 2,y
    ldx #CH2_KEY_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}
