// put published C constant #defines here:

#define THERMO_CHANNEL_1	 1
#define THERMO_CHANNEL_2	 2
#define THERMO_OVERFLOW_MINUS	 0x7FFF
#define THERMO_OVERFLOW_PLUS	 0x8000
#define THERMO_TIMEOUT		 0x7FFE
#define THERMO_VMAX	  		 56.25
#define THERMO_VMIN	 		 -56.25
#define THERMO_VMAX_TIMEOUT 1000.00
#define THERMO_TEMP_INVALID		    -10000.0

#define  TYPE_B	0
#define  TYPE_E	1
#define  TYPE_J	2
#define  TYPE_K	3
#define  TYPE_N	4
#define  TYPE_R	5
#define  TYPE_S	6
#define  TYPE_T	7

#define THERMO_DEGC_TO_DEGF(C)   ( 1.8f * (C) + 32.0f )
#define THERMO_DEGF_TO_DEGC(F)   ( ( (F) - 32.0f ) / 1.8f )
#define THERMO_MV_TO_FAHRENHEIT(T,V) THERMO_DEGC_TO_DEGF( Thermo_mV_To_Temperature( T, V ) )
#define THERMISTOR_FAHRENHEIT(M)   THERMO_DEGC_TO_DEGF( Thermistor_Temperature( M ) )
#define THERMO_CALC_FAHRENHEIT(T,V,A,F) THERMO_DEGC_TO_DEGF(Thermo_Calc_Temperature(T,V,A,F))
#define THERMO_FAHRENHEIT(T,N,S,M) THERMO_DEGC_TO_DEGF( Thermo_Temperature( T, N, S, M ) )


extern _forth  int Thermo_Try_To_Grab ( int modulenum );

extern _forth  int Thermo_Grab ( int modulenum );

extern _forth  void Thermo_Free ( int modulenum );

extern _forth  void Thermo_Init ( int modulenum );

extern _forth  int Thermo_Status ( int modulenum );

extern _forth  int Thermo_New ( int modulenum );

extern _forth  int Thermo_Wait_Til_New ( int channel_num, int modulenum );

extern _forth  int Thermo_Read ( int channel_num, int modulenum );

extern _forth  float Thermo_Counts_To_mV ( int count );

extern _forth  float Thermo_mV ( int channel_num, int modulenum );

extern _forth  float Thermo_mV_To_Temperature ( int thermocouple_type, float millivolts );

extern _forth  float Thermo_Cold_Junction_Model ( int thermocouple_type, float cold_jn_temperature );

extern _forth  float Thermistor_Model ( int count );

extern _forth  float Thermistor_Temperature ( int modulenum );

extern _forth  float Thermo_Calc_Temperature ( int thermocouple_type,float thermocouple_mV,		int thermistor_count, int thermistor_flag);

extern _forth  float Thermo_Temperature ( int thermocouple_type,int chan,int thermistor_flag,int modulenum);
