
_forth  int Thermo_Try_To_Grab ( int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #THERMO_TRY_TO_GRAB_ADDR
    stx 2,y
    ldx #THERMO_TRY_TO_GRAB_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int Thermo_Grab ( int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #THERMO_GRAB_ADDR
    stx 2,y
    ldx #THERMO_GRAB_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Thermo_Free ( int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #THERMO_FREE_ADDR
    stx 2,y
    ldx #THERMO_FREE_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Thermo_Init ( int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #THERMO_INIT_ADDR
    stx 2,y
    ldx #THERMO_INIT_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int Thermo_Status ( int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #THERMO_STATUS_ADDR
    stx 2,y
    ldx #THERMO_STATUS_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int Thermo_New ( int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #THERMO_NEW_ADDR
    stx 2,y
    ldx #THERMO_NEW_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int Thermo_Wait_Til_New ( int channel_num, int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #THERMO_WAIT_TIL_NEW_ADDR
    stx 2,y
    ldx #THERMO_WAIT_TIL_NEW_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int Thermo_Read ( int channel_num, int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #THERMO_READ_ADDR
    stx 2,y
    ldx #THERMO_READ_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  float Thermo_Counts_To_mV ( int count )
{
#asm
    dey
    dey
    dey
    dey
    ldx #THERMO_COUNTS_TO_MV_IEEE_ADDR
    stx 2,y
    ldx #THERMO_COUNTS_TO_MV_IEEE_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  float Thermo_mV ( int channel_num, int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #THERMO_MV_IEEE_ADDR
    stx 2,y
    ldx #THERMO_MV_IEEE_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  float Thermo_mV_To_Temperature ( int thermocouple_type, float millivolts )
{
#asm
    dey
    dey
    dey
    dey
    ldx #THERMO_MV_TO_TEMPERATURE_IEEE_ADDR
    stx 2,y
    ldx #THERMO_MV_TO_TEMPERATURE_IEEE_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  float Thermo_Cold_Junction_Model ( int thermocouple_type, float cold_jn_temperature )
{
#asm
    dey
    dey
    dey
    dey
    ldx #THERMO_COLD_JUNCTION_MODEL_IEEE_ADDR
    stx 2,y
    ldx #THERMO_COLD_JUNCTION_MODEL_IEEE_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  float Thermistor_Model ( int count )
{
#asm
    dey
    dey
    dey
    dey
    ldx #THERMISTOR_MODEL_IEEE_ADDR
    stx 2,y
    ldx #THERMISTOR_MODEL_IEEE_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  float Thermistor_Temperature ( int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #THERMISTOR_TEMPERATURE_IEEE_ADDR
    stx 2,y
    ldx #THERMISTOR_TEMPERATURE_IEEE_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  float Thermo_Calc_Temperature ( int thermocouple_type,float thermocouple_mV,		int thermistor_count, int thermistor_flag)
{
#asm
    dey
    dey
    dey
    dey
    ldx #THERMO_CALC_TEMPERATURE_IEEE_ADDR
    stx 2,y
    ldx #THERMO_CALC_TEMPERATURE_IEEE_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  float Thermo_Temperature ( int thermocouple_type,int chan,int thermistor_flag,int modulenum)
{
#asm
    dey
    dey
    dey
    dey
    ldx #THERMO_TEMPERATURE_IEEE_ADDR
    stx 2,y
    ldx #THERMO_TEMPERATURE_IEEE_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}
