
_forth  void Call_Step_Manager ( void )
{
#asm
    dey
    dey
    dey
    dey
    ldx #CALL_STEP_MANAGER_ADDR
    stx 2,y
    ldx #CALL_STEP_MANAGER_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_at(var_ticks_per_sec_XADDR)  int var_ticks_per_sec;

_forth  xaddr Step_Count ( int motor_number )
{
#asm
    dey
    dey
    dey
    dey
    ldx #STEP_COUNT_ADDR
    stx 2,y
    ldx #STEP_COUNT_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  char Motor_State ( int motor_number )
{
#asm
    dey
    dey
    dey
    dey
    ldx #MOTOR_STATE_ADDR
    stx 2,y
    ldx #MOTOR_STATE_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Start_Ramp ( int direction, int motor_number )
{
#asm
    dey
    dey
    dey
    dey
    ldx #START_RAMP_ADDR
    stx 2,y
    ldx #START_RAMP_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int Ramp_To_Speed ( int direction, int speed, int motor_number )
{
#asm
    dey
    dey
    dey
    dey
    ldx #RAMP_TO_SPEED_ADDR
    stx 2,y
    ldx #RAMP_TO_SPEED_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int Ramp_To_Steady ( int direction, int motor_number )
{
#asm
    dey
    dey
    dey
    dey
    ldx #RAMP_TO_STEADY_ADDR
    stx 2,y
    ldx #RAMP_TO_STEADY_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int From_Speed_To_Stop ( int initial_speed, int motor_number )
{
#asm
    dey
    dey
    dey
    dey
    ldx #FROM_SPEED_TO_STOP_ADDR
    stx 2,y
    ldx #FROM_SPEED_TO_STOP_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int Soft_Stop ( int motor_number )
{
#asm
    dey
    dey
    dey
    dey
    ldx #SOFT_STOP_ADDR
    stx 2,y
    ldx #SOFT_STOP_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int Change_Speed ( int target_speed, int motor_number )
{
#asm
    dey
    dey
    dey
    dey
    ldx #CHANGE_SPEED_ADDR
    stx 2,y
    ldx #CHANGE_SPEED_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Steps_At_Speed ( int direction, int numsteps, int speed, int motor_number )
{
#asm
    dey
    dey
    dey
    dey
    ldx #STEPS_AT_SPEED_ADDR
    stx 2,y
    ldx #STEPS_AT_SPEED_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Steps_At_Steady ( int direction, int numsteps, int motor_number )
{
#asm
    dey
    dey
    dey
    dey
    ldx #STEPS_AT_STEADY_ADDR
    stx 2,y
    ldx #STEPS_AT_STEADY_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Jog_Steps ( int direction, int numsteps, int motor_number )
{
#asm
    dey
    dey
    dey
    dey
    ldx #JOG_STEPS_ADDR
    stx 2,y
    ldx #JOG_STEPS_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void One_Step ( int direction, int motor_number )
{
#asm
    dey
    dey
    dey
    dey
    ldx #ONE_STEP_ADDR
    stx 2,y
    ldx #ONE_STEP_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void E_Stop ( int motor_number )
{
#asm
    dey
    dey
    dey
    dey
    ldx #E_STOP_ADDR
    stx 2,y
    ldx #E_STOP_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Init_Stepper_Status (int jog_start_speed,int steady_speed,int accel, int decel, int port_offset, int port_modulenum, int motor_mask, int halfsteps, int motornum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #INIT_STEPPER_STATUS_ADDR
    stx 2,y
    ldx #INIT_STEPPER_STATUS_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Energize_Stepper ( int motor_number )
{
#asm
    dey
    dey
    dey
    dey
    ldx #ENERGIZE_STEPPER_ADDR
    stx 2,y
    ldx #ENERGIZE_STEPPER_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Clear_Motor_Port ( int motor_number )
{
#asm
    dey
    dey
    dey
    dey
    ldx #CLEAR_MOTOR_PORT_ADDR
    stx 2,y
    ldx #CLEAR_MOTOR_PORT_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Disable_Motor ( int motor_number )
{
#asm
    dey
    dey
    dey
    dey
    ldx #DISABLE_MOTOR_ADDR
    stx 2,y
    ldx #DISABLE_MOTOR_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Set_Stepper_Direction ( int direction, int motor_number )
{
#asm
    dey
    dey
    dey
    dey
    ldx #SET_STEPPER_DIRECTION_ADDR
    stx 2,y
    ldx #SET_STEPPER_DIRECTION_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Zero_Stepper_Arrays ( void )
{
#asm
    dey
    dey
    dey
    dey
    ldx #ZERO_STEPPER_ARRAYS_ADDR
    stx 2,y
    ldx #ZERO_STEPPER_ARRAYS_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}
