
extern _forth  int Read_Motor_Status ( int modulenum );

extern _forth  int To_Motor ( int state, int decay, int pwm, int modulenum );
#define MOTOR_DIR_BRAKE_L  0x00  // Outputs are both set low, motor brakes low
#define MOTOR_DIR_CCW      0x01  // Output 1 high and output 2 low; counter-clockwise
#define MOTOR_DIR_CW       0x02  // Output 1 low and output 2 high; clockwise
#define MOTOR_DIR_BRAKE_H  0x03  // Outputs are both set high, motor brakes high
#define MOTOR_DIR_COAST    0x04  // Outputs are OFF, motor coasts

#define MOTOR_DECAY_MIXED  0x06  // Send to M_DECAY to enable the motor with mixed decay
#define MOTOR_DECAY_FAST   0x05  // Send to M_DECAY to enable the motor with fast decay
#define MOTOR_DECAY_SLOW   0x04  // Send to M_DECAY to enable the motor with slow decay

#define MOTOR_PWM_MAX      0x1F  // Full-scale PWM duty cycle for To_Motor

#define MOTOR_ON_CW(  P, N ) To_Motor( MOTOR_DIR_CW,      MOTOR_DECAY_SLOW, (P), (N) )
#define MOTOR_ON_CCW( P, N ) To_Motor( MOTOR_DIR_CCW,     MOTOR_DECAY_SLOW, (P), (N) )
#define MOTOR_STOP(  N )     To_Motor( MOTOR_DIR_BRAKE_L, MOTOR_DECAY_SLOW, 0,   (N) )
#define MOTOR_COAST( N )     To_Motor( MOTOR_DIR_COAST,   0,                0,   (N) )
