
_forth  void Update_Here_With( addr address,       addr * graphics_resource_addr,       page graphics_resource_page,       FORTH_ARRAY * garray_addr,       page garray_page )
{
#asm
    dey
    dey
    dey
    dey
    ldx #UPDATE_HERE_WITH_ADDR
    stx 2,y
    ldx #UPDATE_HERE_WITH_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Update_Graphics ( GUI_VARS * tvars_addr, page tvars_page )
{
#asm
    dey
    dey
    dey
    dey
    ldx #UPDATE_GRAPHICS_ADDR
    stx 2,y
    ldx #UPDATE_GRAPHICS_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Update_Text( GUI_VARS * tvars_addr, page tvars_page )
{
#asm
    dey
    dey
    dey
    dey
    ldx #UPDATE_TEXT_ADDR
    stx 2,y
    ldx #UPDATE_TEXT_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Update_Text_And_Graphics( GUI_VARS * tvars_addr, page tvars_page )
{
#asm
    dey
    dey
    dey
    dey
    ldx #UPDATE_TEXT_AND_GRAPHICS_ADDR
    stx 2,y
    ldx #UPDATE_TEXT_AND_GRAPHICS_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Clear_Graphics( GUI_VARS * tvars_addr, page tvars_page )
{
#asm
    dey
    dey
    dey
    dey
    ldx #CLEAR_GRAPHICS_ADDR
    stx 2,y
    ldx #CLEAR_GRAPHICS_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Clear_Text( GUI_VARS * tvars_addr, page tvars_page )
{
#asm
    dey
    dey
    dey
    dey
    ldx #CLEAR_TEXT_ADDR
    stx 2,y
    ldx #CLEAR_TEXT_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Set_Text_Home_Addr( addr address )
{
#asm
    dey
    dey
    dey
    dey
    ldx #SET_TEXT_HOME_ADDR_ADDR
    stx 2,y
    ldx #SET_TEXT_HOME_ADDR_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Set_Gr_Home_Addr( addr address )
{
#asm
    dey
    dey
    dey
    dey
    ldx #SET_GR_HOME_ADDR_ADDR
    stx 2,y
    ldx #SET_GR_HOME_ADDR_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Set_Text_Area( uint columns )
{
#asm
    dey
    dey
    dey
    dey
    ldx #SET_TEXT_AREA_ADDR
    stx 2,y
    ldx #SET_TEXT_AREA_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Set_Gr_Area( uint columns )
{
#asm
    dey
    dey
    dey
    dey
    ldx #SET_GR_AREA_ADDR
    stx 2,y
    ldx #SET_GR_AREA_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Set_Display_Mode( uint columns )
{
#asm
    dey
    dey
    dey
    dey
    ldx #SET_DISPLAY_MODE_ADDR
    stx 2,y
    ldx #SET_DISPLAY_MODE_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Set_Cursor_State( boolean isvisible, boolean isflashing )
{
#asm
    dey
    dey
    dey
    dey
    ldx #SET_CURSOR_STATE_ADDR
    stx 2,y
    ldx #SET_CURSOR_STATE_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Set_Display_State( boolean graphics, boolean text )
{
#asm
    dey
    dey
    dey
    dey
    ldx #SET_DISPLAY_STATE_ADDR
    stx 2,y
    ldx #SET_DISPLAY_STATE_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Set_Text_Mode( uchar modebyte )
{
#asm
    dey
    dey
    dey
    dey
    ldx #SET_TEXT_MODE_ADDR
    stx 2,y
    ldx #SET_TEXT_MODE_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Config_Display( uint graphics_cols, uint graphics_rows, addr graphics_start, uchar background_fill, uint text_cols, uint text_rows, addr text_start, xaddr heap_bottom, xaddr heap_top, GUI_VARS * tvars_addr, page tvars_page )
{
#asm
    dey
    dey
    dey
    dey
    ldx #CONFIG_DISPLAY_ADDR
    stx 2,y
    ldx #CONFIG_DISPLAY_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Init_Display( GUI_VARS * tvars_addr, page tvars_page )
{
#asm
    dey
    dey
    dey
    dey
    ldx #INIT_DISPLAY_ADDR
    stx 2,y
    ldx #INIT_DISPLAY_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Std_Display( GUI_VARS * tvars_addr, page tvars_page )
{
#asm
    dey
    dey
    dey
    dey
    ldx #STD_DISPLAY_ADDR
    stx 2,y
    ldx #STD_DISPLAY_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Draw_Graphic( uint col,       uint row,       GUI_VARS * tvars_addr,       page tvars_page,       xaddr graphic_addr )
{
#asm
    dey
    dey
    dey
    dey
    ldx #DRAW_GRAPHIC_ADDR
    stx 2,y
    ldx #DRAW_GRAPHIC_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Direct_Draw_Graphic( uint col,       uint row,       GUI_VARS * tvars_addr,       page tvars_page,       xaddr graphic_addr )
{
#asm
    dey
    dey
    dey
    dey
    ldx #DIRECT_DRAW_GRAPHIC_ADDR
    stx 2,y
    ldx #DIRECT_DRAW_GRAPHIC_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Direct_Erase_Graphic( uint col,       uint row,       GUI_VARS * tvars_addr,       page tvars_page,       xaddr graphic_addr )
{
#asm
    dey
    dey
    dey
    dey
    ldx #DIRECT_ERASE_GRAPHIC_ADDR
    stx 2,y
    ldx #DIRECT_ERASE_GRAPHIC_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Erase_Graphic( uint col,       uint row,       GUI_VARS * tvars_addr,       page tvars_page,       xaddr graphic_addr )
{
#asm
    dey
    dey
    dey
    dey
    ldx #ERASE_GRAPHIC_ADDR
    stx 2,y
    ldx #ERASE_GRAPHIC_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Do_Graphic ( uint col,       uint row,       GUI_VARS * tvars_addr,       page tvars_page,       uint action,       xaddr graphic_addr )
{
#asm
    dey
    dey
    dey
    dey
    ldx #DO_GRAPHIC_ADDR
    stx 2,y
    ldx #DO_GRAPHIC_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Button_Draw_Textonly( uint col,       uint row,       GUI_VARS * tvars_addr,       page tvars_page,       BUTTON * button_addr )
{
#asm
    dey
    dey
    dey
    dey
    ldx #BUTTON_DRAW_TEXTONLY_ADDR
    stx 2,y
    ldx #BUTTON_DRAW_TEXTONLY_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Button_Draw( uint col,       uint row,       GUI_VARS * tvars_addr,       page tvars_page,       BUTTON * button_addr )
{
#asm
    dey
    dey
    dey
    dey
    ldx #BUTTON_DRAW_ADDR
    stx 2,y
    ldx #BUTTON_DRAW_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Button_Erase_Textonly( uint col,       uint row,       GUI_VARS * tvars_addr,       page tvars_page,       BUTTON * button_addr )
{
#asm
    dey
    dey
    dey
    dey
    ldx #BUTTON_ERASE_TEXTONLY_ADDR
    stx 2,y
    ldx #BUTTON_ERASE_TEXTONLY_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Button_Erase( uint col,       uint row,       GUI_VARS * tvars_addr,       page tvars_page,       BUTTON * button_addr )
{
#asm
    dey
    dey
    dey
    dey
    ldx #BUTTON_ERASE_ADDR
    stx 2,y
    ldx #BUTTON_ERASE_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Button_Press( uint col,       uint row,       GUI_VARS * tvars_addr,       page tvars_page,       BUTTON * button_addr )
{
#asm
    dey
    dey
    dey
    dey
    ldx #BUTTON_PRESS_ADDR
    stx 2,y
    ldx #BUTTON_PRESS_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Button_Repeat( uint col,       uint row,       GUI_VARS * tvars_addr,       page tvars_page,       BUTTON * button_addr )
{
#asm
    dey
    dey
    dey
    dey
    ldx #BUTTON_REPEAT_ADDR
    stx 2,y
    ldx #BUTTON_REPEAT_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Button_Release( uint col,       uint row,       GUI_VARS * tvars_addr,       page tvars_page,       BUTTON * button_addr )
{
#asm
    dey
    dey
    dey
    dey
    ldx #BUTTON_RELEASE_ADDR
    stx 2,y
    ldx #BUTTON_RELEASE_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Do_Button( uint col,       uint row,       GUI_VARS * tvars_addr,       page tvars_page,       uint action,       BUTTON * button_addr )
{
#asm
    dey
    dey
    dey
    dey
    ldx #DO_BUTTON_ADDR
    stx 2,y
    ldx #DO_BUTTON_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Do_Menu(   uint col,   uint row,   GUI_VARS * tvars_addr,   page tvars_page,   uint action,   MENU * menu_addr )
{
#asm
    dey
    dey
    dey
    dey
    ldx #DO_MENU_ADDR
    stx 2,y
    ldx #DO_MENU_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Menu_Install( uint offset,   uint col,   uint row,   GUI_VARS * tvars_addr,   page tvars_page,   MENU *  menu_addr )
{
#asm
    dey
    dey
    dey
    dey
    ldx #MENU_INSTALL_ADDR
    stx 2,y
    ldx #MENU_INSTALL_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Menu_Remove(   uint offset,   GUI_VARS * tvars_addr,   page tvars_page,   MENU *  menu_addr )
{
#asm
    dey
    dey
    dey
    dey
    ldx #MENU_REMOVE_ADDR
    stx 2,y
    ldx #MENU_REMOVE_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Init_Menu(   uint offset,   uint col,   uint row,   GUI_VARS * tvars_addr,   page tvars_page,   MENU * menu_addr )
{
#asm
    dey
    dey
    dey
    dey
    ldx #INIT_MENU_ADDR
    stx 2,y
    ldx #INIT_MENU_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Uninit_Menu(   uint offset,   uint col,   uint row,   GUI_VARS * tvars_addr,   page tvars_page,   MENU * menu_addr )
{
#asm
    dey
    dey
    dey
    dey
    ldx #UNINIT_MENU_ADDR
    stx 2,y
    ldx #UNINIT_MENU_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Set_Pixel ( int x, int y )
{
#asm
    dey
    dey
    dey
    dey
    ldx #SET_PIXEL_ADDR
    stx 2,y
    ldx #SET_PIXEL_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Clear_Pixel(int x, int y)
{
#asm
    dey
    dey
    dey
    dey
    ldx #CLEAR_PIXEL_ADDR
    stx 2,y
    ldx #CLEAR_PIXEL_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int Is_Pressed ( void )
{
#asm
    dey
    dey
    dey
    dey
    ldx #IS_PRESSED_ADDR
    stx 2,y
    ldx #IS_PRESSED_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Wait_For_Press ( GUI_VARS * tvars_addr, page tvars_page )
{
#asm
    dey
    dey
    dey
    dey
    ldx #WAIT_FOR_PRESS_ADDR
    stx 2,y
    ldx #WAIT_FOR_PRESS_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Wait_For_Release ( GUI_VARS * tvars_addr, page tvars_page )
{
#asm
    dey
    dey
    dey
    dey
    ldx #WAIT_FOR_RELEASE_ADDR
    stx 2,y
    ldx #WAIT_FOR_RELEASE_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int Read_Touchscreen ( GUI_VARS * tvars_addr, page tvars_page )
{
#asm
    dey
    dey
    dey
    dey
    ldx #READ_TOUCHSCREEN_ADDR
    stx 2,y
    ldx #READ_TOUCHSCREEN_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  long Read_Raw_Coords ( GUI_VARS * tvars_addr, page tvars_page )
{
#asm
    dey
    dey
    dey
    dey
    ldx #READ_RAW_COORDS_ADDR
    stx 2,y
    ldx #READ_RAW_COORDS_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Calibrate_Touchscreen( long raw0, long raw1, long raw2 )
{
#asm
    dey
    dey
    dey
    dey
    ldx #CALIBRATE_TOUCHSCREEN_ADDR
    stx 2,y
    ldx #CALIBRATE_TOUCHSCREEN_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Globalize_TVars ( GUI_VARS * tvars_addr, page tvars_page )
{
#asm
    dey
    dey
    dey
    dey
    ldx #GLOBALIZE_TVARS_ADDR
    stx 2,y
    ldx #GLOBALIZE_TVARS_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int Screen_To_Image ( xaddr buffer, int buffer_size, int format )
{
#asm
    dey
    dey
    dey
    dey
    ldx #SCREEN_TO_IMAGE_ADDR
    stx 2,y
    ldx #SCREEN_TO_IMAGE_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int Graphic_To_Image ( xaddr graphic, xaddr buffer, int buffer_size, int format )
{
#asm
    dey
    dey
    dey
    dey
    ldx #GRAPHIC_TO_IMAGE_ADDR
    stx 2,y
    ldx #GRAPHIC_TO_IMAGE_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  long Simulate_Touch ( int x, int y )
{
#asm
    dey
    dey
    dey
    dey
    ldx #SIMULATE_TOUCH_ADDR
    stx 2,y
    ldx #SIMULATE_TOUCH_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Screen_Has_Changed ( void )
{
#asm
    dey
    dey
    dey
    dey
    ldx #SCREEN_HAS_CHANGED_ADDR
    stx 2,y
    ldx #SCREEN_HAS_CHANGED_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int Has_Screen_Changed ( void )
{
#asm
    dey
    dey
    dey
    dey
    ldx #HAS_SCREEN_CHANGED_ADDR
    stx 2,y
    ldx #HAS_SCREEN_CHANGED_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int Simulated_Touch_To_Image ( long buffer, int buffer_size, int format_id, int x, int y )
{
#asm
    dey
    dey
    dey
    dey
    ldx #SIMULATED_TOUCH_TO_IMAGE_ADDR
    stx 2,y
    ldx #SIMULATED_TOUCH_TO_IMAGE_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Service_Touch( int buttonID, GUI_VARS * tvars_addr, page tvars_page )
{
#asm
    dey
    dey
    dey
    dey
    ldx #SERVICE_TOUCH_ADDR
    stx 2,y
    ldx #SERVICE_TOUCH_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Menu_Process(  int buttonID, GUI_VARS * tvars_addr, page tvars_page)
{
#asm
    dey
    dey
    dey
    dey
    ldx #MENU_PROCESS_ADDR
    stx 2,y
    ldx #MENU_PROCESS_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Wait_Then_Service_Touch( GUI_VARS * tvars_addr, page tvars_page )
{
#asm
    dey
    dey
    dey
    dey
    ldx #WAIT_THEN_SERVICE_TOUCH_ADDR
    stx 2,y
    ldx #WAIT_THEN_SERVICE_TOUCH_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Menu_Query(   GUI_VARS * tvars_addr,   page tvars_page )
{
#asm
    dey
    dey
    dey
    dey
    ldx #MENU_QUERY_ADDR
    stx 2,y
    ldx #MENU_QUERY_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Init_Touch(   GUI_VARS * tvars_addr,   page tvars_page )
{
#asm
    dey
    dey
    dey
    dey
    ldx #INIT_TOUCH_ADDR
    stx 2,y
    ldx #INIT_TOUCH_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Render_Font_to_buffer(  char * string_addr, page string_page,       uint col,       uint row,       FORTH_ARRAY * garray_addr, page garray_page,       FONT * font_addr,       page font_page)
{
#asm
    dey
    dey
    dey
    dey
    ldx #RENDER_FONT_TO_BUFFER_ADDR
    stx 2,y
    ldx #RENDER_FONT_TO_BUFFER_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Render_Font(  char * string_addr, page string_page,       uint col,       uint row,       GUI_VARS * tvars_addr, page tvars_page,       FONT * font_addr,       page font_page)
{
#asm
    dey
    dey
    dey
    dey
    ldx #RENDER_FONT_ADDR
    stx 2,y
    ldx #RENDER_FONT_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Direct_Render_Font( char * string_addr, page string_page,       uint col,       uint row,       GUI_VARS * tvars_addr,page tvars_page,       FONT * font_addr,       page font_page)
{
#asm
    dey
    dey
    dey
    dey
    ldx #DIRECT_RENDER_FONT_ADDR
    stx 2,y
    ldx #DIRECT_RENDER_FONT_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}
