
_forth  void Initialize_GUI ( xaddr heap_start, xaddr heap_end )
{
#asm
    dey
    dey
    dey
    dey
    ldx #INITIALIZE_GUI_ADDR
    stx 2,y
    ldx #INITIALIZE_GUI_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int New_Object ( int object_type )
{
#asm
    dey
    dey
    dey
    dey
    ldx #NEW_OBJECT_ADDR
    stx 2,y
    ldx #NEW_OBJECT_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Set_Property ( int object, int property, ulong value )
{
#asm
    dey
    dey
    dey
    dey
    ldx #SET_PROPERTY_ADDR
    stx 2,y
    ldx #SET_PROPERTY_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  ulong Get_Property ( int object, int property )
{
#asm
    dey
    dey
    dey
    dey
    ldx #GET_PROPERTY_ADDR
    stx 2,y
    ldx #GET_PROPERTY_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Load ( int screen, int object, int x_coord, int y_coord )
{
#asm
    dey
    dey
    dey
    dey
    ldx #LOAD_ADDR
    stx 2,y
    ldx #LOAD_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Un_Load ( int screen, int object, int x_coord, int y_coord )
{
#asm
    dey
    dey
    dey
    dey
    ldx #UN_LOAD_ADDR
    stx 2,y
    ldx #UN_LOAD_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int Read_Error ( void )
{
#asm
    dey
    dey
    dey
    dey
    ldx #READ_ERROR_ADDR
    stx 2,y
    ldx #READ_ERROR_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Clear_Error ( void )
{
#asm
    dey
    dey
    dey
    dey
    ldx #CLEAR_ERROR_ADDR
    stx 2,y
    ldx #CLEAR_ERROR_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Buzz ( void )
{
#asm
    dey
    dey
    dey
    dey
    ldx #BUZZ_ADDR
    stx 2,y
    ldx #BUZZ_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Refresh ( int screen )
{
#asm
    dey
    dey
    dey
    dey
    ldx #REFRESH_ADDR
    stx 2,y
    ldx #REFRESH_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Redraw ( int screen )
{
#asm
    dey
    dey
    dey
    dey
    ldx #REDRAW_ADDR
    stx 2,y
    ldx #REDRAW_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Copy_Screen ( int source_screen, int destination_screen )
{
#asm
    dey
    dey
    dey
    dey
    ldx #COPY_SCREEN_ADDR
    stx 2,y
    ldx #COPY_SCREEN_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Draw ( int x_coord, int y_coord )
{
#asm
    dey
    dey
    dey
    dey
    ldx #DRAW_ADDR
    stx 2,y
    ldx #DRAW_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Clear ( int object )
{
#asm
    dey
    dey
    dey
    dey
    ldx #CLEAR_ADDR
    stx 2,y
    ldx #CLEAR_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Calibrate ( ulong raw_coord0, ulong raw_coord1, ulong raw_coord2 )
{
#asm
    dey
    dey
    dey
    dey
    ldx #CALIBRATE_ADDR
    stx 2,y
    ldx #CALIBRATE_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Add_Data ( int plot, int value )
{
#asm
    dey
    dey
    dey
    dey
    ldx #ADD_DATA_ADDR
    stx 2,y
    ldx #ADD_DATA_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Delete_Character ( int textbox )
{
#asm
    dey
    dey
    dey
    dey
    ldx #DELETE_CHARACTER_ADDR
    stx 2,y
    ldx #DELETE_CHARACTER_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Add_Character ( int textbox, int character )
{
#asm
    dey
    dey
    dey
    dey
    ldx #ADD_CHARACTER_ADDR
    stx 2,y
    ldx #ADD_CHARACTER_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Insert_Key ( int keypad, int key, int key_position )
{
#asm
    dey
    dey
    dey
    dey
    ldx #INSERT_KEY_ADDR
    stx 2,y
    ldx #INSERT_KEY_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Initialize_Battery ( void )
{
#asm
    dey
    dey
    dey
    dey
    ldx #INITIALIZE_BATTERY_ADDR
    stx 2,y
    ldx #INITIALIZE_BATTERY_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Read_Battery ( void )
{
#asm
    dey
    dey
    dey
    dey
    ldx #READ_BATTERY_ADDR
    stx 2,y
    ldx #READ_BATTERY_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Schedule_Event ( ulong event, ulong time_interval, ulong start_time, ulong stop_time )
{
#asm
    dey
    dey
    dey
    dey
    ldx #SCHEDULE_EVENT_ADDR
    stx 2,y
    ldx #SCHEDULE_EVENT_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Remove_Event ( ulong event )
{
#asm
    dey
    dey
    dey
    dey
    ldx #REMOVE_EVENT_ADDR
    stx 2,y
    ldx #REMOVE_EVENT_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Service_GUI_Events ( void )
{
#asm
    dey
    dey
    dey
    dey
    ldx #SERVICE_GUI_EVENTS_ADDR
    stx 2,y
    ldx #SERVICE_GUI_EVENTS_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void String_To_Textbox ( int object, char *strAddr, int strPage, int count )
{
#asm
    dey
    dey
    dey
    dey
    ldx #CSTRING_TO_TEXTBOX_ADDR
    stx 2,y
    ldx #CSTRING_TO_TEXTBOX_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int Textbox_To_String ( int object )
{
#asm
    dey
    dey
    dey
    dey
    ldx #CTEXTBOX_TO_STRING_ADDR
    stx 2,y
    ldx #CTEXTBOX_TO_STRING_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}
