
#define FD_INBUF_INSTANCE 0x034000 // 4Kbyte (0x1000) used by FD_Init_Buffers_Default

typedef struct
{	char FD_SECONDS_OVER_2;	// bits 0-4 seconds/2: valid range = 0-29
		char FD_MINUTES;			// bits 5-10 minutes, valid range = 0-59
		char FD_HOURS;				// bits 11-15 hours, valid range = 0-23
		char FD_DAYS;				// bits 16-20 days, valid range = 1-31
		char FD_MONTHS;			// bits 21-24 months, valid range = 1-12
		int  FD_YEAR;			   // bits 25-31 year, valid range = 1980{0} to 2107{127}
	// Note: for 16-bit date value, use top 16bits only (days/month/year)
} FD_DATETIME_STRUCT_DEF

#define FD_BAUD_115200	1152	// 115200 baud
#define FD_BAUD_57600	576 	// 57600 baud
#define FD_BAUD_38400	384 	// 38400 baud
#define FD_BAUD_19200	192 	// 19200 baud
#define FD_BAUD_9600		96  	// 9600 baud

#define FD_DATETIME_STRUCT(MODNUM) ((FD_DATETIME_STRUCT_DEF*)(int) FD_Datetime_Struct(MODNUM))


extern _forth  xaddr FD_Info( int modulenum );

extern _forth  xaddr FD_Inbuf( int modulenum );

extern _forth  uint FD_Inbuf_Size( int modulenum );

extern _forth  uint FD_Inbuf_Numbytes( int modulenum );

extern _forth  void FD_Set_Inbuf_Numbytes( uint numbytes, int modulenum );

extern _forth  uint FD_Outbuf_Numbytes( int modulenum );

extern _forth  void FD_Setup_Inbuf( xaddr inbuf, uint numbytes, int modulenum );

extern _forth  xaddr FD_Resource( int modulenum );

extern _forth  void FD_Resource_Get( int modulenum );

extern _forth  void FD_Resource_Release( int modulenum );

extern _forth  int FD_Error( int modulenum );

extern _forth  void FD_Clear_Error( int modulenum );

extern _forth  void FD_Set_Max_Msec_Wait( uint msec_wait, int modulenum );

extern _forth  void FD_Set_Startup_Msec_Wait( uint msec_wait, int modulenum );

extern _forth  uint FD_Max_Msec_Wait( int modulenum );

extern _forth  uint FD_Startup_Msec_Wait( int modulenum );

extern _forth  xaddr FD_Command_Response_Buf( int modulenum );

extern _forth  void FD_Erase_Command_Response_Buf( int modulenum );

extern _forth  xaddr FD_Command_Out_Buf( int modulenum );

extern _forth  xaddr FD_Datetime_Struct( int modulenum );

extern _forth  xaddr FD_Datetime_String_Buf( int modulenum );

extern _forth  xaddr FD_Filename_Buf( int modulenum );

extern _forth  int FD_Unpack_Datetime( ulong date, xaddr datetime_struct );

extern _forth  ulong FD_Pack_Datetime( xaddr datetime_struct );

extern _forth  uint FD_C_String_Length( xaddr string_addr, uint maxlength );

extern _forth  void FD_Datetime_To_String( xaddr datetime_struct, xaddr string_buf );

extern _forth  int FD_Unpack_Date( uint date, xaddr datetime_struct );

extern _forth  uint FD_Pack_Date( xaddr datetime_struct );

extern _forth  void FD_Date_To_String( xaddr datetime_struct, xaddr string_buf );

extern _forth  uint FD_Buffer_Write( xaddr src_buf, uint numbytes, uint max_msec_per_line, int modulenum );

extern _forth  uint FD_Buffer_Read( xaddr dest_buf, uint numbytes, uint max_msec_per_line, int modulenum );

extern _forth  void FD_Vdrive_On( int modulenum );

extern _forth  void FD_Vdrive_Off( int modulenum );

extern _forth  void FD_Vdrive_Power_Cycle( int modulenum );

extern _forth  int FD_Sync_Cap_E( int modulenum );

extern _forth  int FD_Sync_Small_e( int modulenum );

extern _forth  int FD_Disk_Status( int modulenum );

extern _forth  int FD_Short_Cmd_Set( int modulenum );

extern _forth  int FD_Input_Binary( int modulenum );

extern _forth  int FD_Set_Baud( uint baud_over_100, ulong baud_divisor, int modulenum );

extern _forth  int FD_Set_Baud_Rate( uint baud_over_100, int modulenum );

extern _forth  int FD_Firmware_Version( int modulenum );

extern _forth  int FD_Print_Firmware_Version( int modulenum );

extern _forth  int FD_CD_Dot_Dot( int modulenum );

extern _forth  int FD_Change_Directory( xaddr filename_string, int modulenum );

extern _forth  int FD_Delete_Subdirectory( xaddr filename_string, int modulenum );

extern _forth  int FD_Make_Subdirectory( xaddr name_string, int modulenum );

extern _forth  int FD_Delete_File( xaddr filename_string, int modulenum );

extern _forth  int FD_Open_File_For_Write( xaddr filename_string, int modulenum );

extern _forth  int FD_Close_File( xaddr filename_string, int modulenum );

extern _forth  int FD_Open_File_For_Read( xaddr filename_string, int modulenum );

extern _forth  int FD_Make_Subdirectory_Datetime( xaddr name_string, long datetime, int modulenum );

extern _forth  int FD_Open_File_For_Write_Datetime( xaddr filename_string, long datetime, int modulenum );

extern _forth  int FD_Rename_File1_As_File2( xaddr name1_string, xaddr name2_string, int modulenum );

extern _forth  int FD_Free_Space_Kbytes( int modulenum );

extern _forth  int FD_Print_Free_Space_Kbytes( int modulenum );

extern _forth  int FD_Free_Space_Kbytes_Extended( int modulenum );

extern _forth  int FD_Print_Free_Space_Kbytes_Extended( int modulenum );

extern _forth  int FD_Disk_Serial_Number( int modulenum );

extern _forth  int FD_Print_Disk_Serial_Number( int modulenum );

extern _forth  int FD_Disk_Volume_Label( int modulenum );

extern _forth  int FD_Print_Disk_Volume_Label( int modulenum );

extern _forth  int FD_ID_Disk_Drive( int modulenum );

extern _forth  int FD_Print_ID_Disk_Drive( int modulenum );

extern _forth  int FD_Seek_To_File_Position( long file_position, int modulenum );

extern _forth  int FD_Dir_File( xaddr filename_string, int modulenum );

extern _forth  int FD_Print_Dir_File( xaddr filename_string, int modulenum );

extern _forth  int FD_Dir_File_Time( xaddr filename_string, int modulenum );

extern _forth  int FD_Print_Dir_File_Time( xaddr filename_string, int modulenum );

extern _forth  int FD_Dir( int modulenum );

extern _forth  int FD_Print_Dir( int modulenum );

extern _forth  ulong FD_Write_To_File( xaddr buffer, uint numbytes, int modulenum );

extern _forth  ulong FD_Get_File_Size( xaddr filename, int modulenum );

extern _forth  ulong FD_Read_From_File( xaddr buf, uint numbytes, ulong file_pos, xaddr file, int module );

extern _forth  ulong FD_Read_Entire_File( xaddr buf, xaddr filename_string, int module );

extern _forth  uint FD_Init_Buffers( xaddr info_struct,xaddr inbuf,uint inbuf_numbytes,int baud,int module);

extern _forth  uint FD_Init_Buffers_Default( int runtime_baud_over_100, int modulenum );

extern _forth  int FD_Init_Comms( uint prior_baud_over_100, int runtime_baud_over_100, int modulenum );

extern _forth  int FD_Confirm_Comms( int modulenum );

extern _forth  int FD_Wait_Til_Disk_Ready( int modulenum );

extern _forth  int FD_Init_All( int baud_over_100, int modulenum );

extern _forth  int FD_Coldstart( int baud_over_100, int modulenum );

extern _forth  int FD_Coldstart_Default( int modulenum );

extern _forth  int FD_Coldstart_Diagnose( int echo_incoming,int echo_outgoing,int baud_over_100,int module);
