
_forth  xaddr FD_Info( int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #FD_INFO_ADDR
    stx 2,y
    ldx #FD_INFO_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  xaddr FD_Inbuf( int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #FD_INBUF_ADDR
    stx 2,y
    ldx #FD_INBUF_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  uint FD_Inbuf_Size( int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #FD_INBUF_SIZE_ADDR
    stx 2,y
    ldx #FD_INBUF_SIZE_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  uint FD_Inbuf_Numbytes( int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #FD_INBUF_NUMBYTES_ADDR
    stx 2,y
    ldx #FD_INBUF_NUMBYTES_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void FD_Set_Inbuf_Numbytes( uint numbytes, int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #FD_SET_INBUF_NUMBYTES_ADDR
    stx 2,y
    ldx #FD_SET_INBUF_NUMBYTES_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  uint FD_Outbuf_Numbytes( int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #FD_OUTBUF_NUMBYTES_ADDR
    stx 2,y
    ldx #FD_OUTBUF_NUMBYTES_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void FD_Setup_Inbuf( xaddr inbuf, uint numbytes, int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #FD_SETUP_INBUF_ADDR
    stx 2,y
    ldx #FD_SETUP_INBUF_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  xaddr FD_Resource( int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #FD_RESOURCE_ADDR
    stx 2,y
    ldx #FD_RESOURCE_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void FD_Resource_Get( int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #FD_RESOURCE_GET_ADDR
    stx 2,y
    ldx #FD_RESOURCE_GET_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void FD_Resource_Release( int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #FD_RESOURCE_RELEASE_ADDR
    stx 2,y
    ldx #FD_RESOURCE_RELEASE_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int FD_Error( int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #FD_ERROR_ADDR
    stx 2,y
    ldx #FD_ERROR_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void FD_Clear_Error( int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #FD_CLEAR_ERROR_ADDR
    stx 2,y
    ldx #FD_CLEAR_ERROR_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void FD_Set_Max_Msec_Wait( uint msec_wait, int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #FD_SET_MAX_MSEC_WAIT_ADDR
    stx 2,y
    ldx #FD_SET_MAX_MSEC_WAIT_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void FD_Set_Startup_Msec_Wait( uint msec_wait, int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #FD_SET_STARTUP_MSEC_WAIT_ADDR
    stx 2,y
    ldx #FD_SET_STARTUP_MSEC_WAIT_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  uint FD_Max_Msec_Wait( int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #FD_MAX_MSEC_WAIT_ADDR
    stx 2,y
    ldx #FD_MAX_MSEC_WAIT_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  uint FD_Startup_Msec_Wait( int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #FD_STARTUP_MSEC_WAIT_ADDR
    stx 2,y
    ldx #FD_STARTUP_MSEC_WAIT_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  xaddr FD_Command_Response_Buf( int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #FD_COMMAND_RESPONSE_BUF_ADDR
    stx 2,y
    ldx #FD_COMMAND_RESPONSE_BUF_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void FD_Erase_Command_Response_Buf( int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #FD_ERASE_COMMAND_RESPONSE_BUF_ADDR
    stx 2,y
    ldx #FD_ERASE_COMMAND_RESPONSE_BUF_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  xaddr FD_Command_Out_Buf( int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #FD_COMMAND_OUT_BUF_ADDR
    stx 2,y
    ldx #FD_COMMAND_OUT_BUF_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  xaddr FD_Datetime_Struct( int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #FD_DATETIME_STRUCT_ADDR
    stx 2,y
    ldx #FD_DATETIME_STRUCT_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  xaddr FD_Datetime_String_Buf( int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #FD_DATETIME_STRING_BUF_ADDR
    stx 2,y
    ldx #FD_DATETIME_STRING_BUF_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  xaddr FD_Filename_Buf( int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #FD_FILENAME_BUF_ADDR
    stx 2,y
    ldx #FD_FILENAME_BUF_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int FD_Unpack_Datetime( ulong date, xaddr datetime_struct )
{
#asm
    dey
    dey
    dey
    dey
    ldx #FD_UNPACK_DATETIME_ADDR
    stx 2,y
    ldx #FD_UNPACK_DATETIME_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  ulong FD_Pack_Datetime( xaddr datetime_struct )
{
#asm
    dey
    dey
    dey
    dey
    ldx #FD_PACK_DATETIME_ADDR
    stx 2,y
    ldx #FD_PACK_DATETIME_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  uint FD_C_String_Length( xaddr string_addr, uint maxlength )
{
#asm
    dey
    dey
    dey
    dey
    ldx #FD_C_STRING_LENGTH_ADDR
    stx 2,y
    ldx #FD_C_STRING_LENGTH_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void FD_Datetime_To_String( xaddr datetime_struct, xaddr string_buf )
{
#asm
    dey
    dey
    dey
    dey
    ldx #FD_DATETIME_TO_STRING_ADDR
    stx 2,y
    ldx #FD_DATETIME_TO_STRING_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int FD_Unpack_Date( uint date, xaddr datetime_struct )
{
#asm
    dey
    dey
    dey
    dey
    ldx #FD_UNPACK_DATE_ADDR
    stx 2,y
    ldx #FD_UNPACK_DATE_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  uint FD_Pack_Date( xaddr datetime_struct )
{
#asm
    dey
    dey
    dey
    dey
    ldx #FD_PACK_DATE_ADDR
    stx 2,y
    ldx #FD_PACK_DATE_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void FD_Date_To_String( xaddr datetime_struct, xaddr string_buf )
{
#asm
    dey
    dey
    dey
    dey
    ldx #FD_DATE_TO_STRING_ADDR
    stx 2,y
    ldx #FD_DATE_TO_STRING_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  uint FD_Buffer_Write( xaddr src_buf, uint numbytes, uint max_msec_per_line, int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #FD_BUFFER_WRITE_ADDR
    stx 2,y
    ldx #FD_BUFFER_WRITE_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  uint FD_Buffer_Read( xaddr dest_buf, uint numbytes, uint max_msec_per_line, int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #FD_BUFFER_READ_ADDR
    stx 2,y
    ldx #FD_BUFFER_READ_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void FD_Vdrive_On( int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #FD_VDRIVE_ON_ADDR
    stx 2,y
    ldx #FD_VDRIVE_ON_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void FD_Vdrive_Off( int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #FD_VDRIVE_OFF_ADDR
    stx 2,y
    ldx #FD_VDRIVE_OFF_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void FD_Vdrive_Power_Cycle( int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #FD_VDRIVE_POWER_CYCLE_ADDR
    stx 2,y
    ldx #FD_VDRIVE_POWER_CYCLE_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int FD_Sync_Cap_E( int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #FD_SYNC_CAP_E_ADDR
    stx 2,y
    ldx #FD_SYNC_CAP_E_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int FD_Sync_Small_e( int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #FD_SYNC_SMALL_E_ADDR
    stx 2,y
    ldx #FD_SYNC_SMALL_E_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int FD_Disk_Status( int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #FD_DISK_STATUS_ADDR
    stx 2,y
    ldx #FD_DISK_STATUS_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int FD_Short_Cmd_Set( int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #FD_SHORT_CMD_SET_ADDR
    stx 2,y
    ldx #FD_SHORT_CMD_SET_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int FD_Input_Binary( int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #FD_INPUT_BINARY_ADDR
    stx 2,y
    ldx #FD_INPUT_BINARY_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int FD_Set_Baud( uint baud_over_100, ulong baud_divisor, int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #FD_SET_BAUD_ADDR
    stx 2,y
    ldx #FD_SET_BAUD_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int FD_Set_Baud_Rate( uint baud_over_100, int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #FD_SET_BAUD_RATE_ADDR
    stx 2,y
    ldx #FD_SET_BAUD_RATE_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int FD_Firmware_Version( int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #FD_FIRMWARE_VERSION_ADDR
    stx 2,y
    ldx #FD_FIRMWARE_VERSION_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int FD_Print_Firmware_Version( int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #FD_PRINT_FIRMWARE_VERSION_ADDR
    stx 2,y
    ldx #FD_PRINT_FIRMWARE_VERSION_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int FD_CD_Dot_Dot( int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #FD_CD_DOT_DOT_ADDR
    stx 2,y
    ldx #FD_CD_DOT_DOT_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int FD_Change_Directory( xaddr filename_string, int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #FD_CHANGE_DIRECTORY_ADDR
    stx 2,y
    ldx #FD_CHANGE_DIRECTORY_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int FD_Delete_Subdirectory( xaddr filename_string, int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #FD_DELETE_SUBDIRECTORY_ADDR
    stx 2,y
    ldx #FD_DELETE_SUBDIRECTORY_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int FD_Make_Subdirectory( xaddr name_string, int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #FD_MAKE_SUBDIRECTORY_ADDR
    stx 2,y
    ldx #FD_MAKE_SUBDIRECTORY_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int FD_Delete_File( xaddr filename_string, int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #FD_DELETE_FILE_ADDR
    stx 2,y
    ldx #FD_DELETE_FILE_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int FD_Open_File_For_Write( xaddr filename_string, int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #FD_OPEN_FILE_FOR_WRITE_ADDR
    stx 2,y
    ldx #FD_OPEN_FILE_FOR_WRITE_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int FD_Close_File( xaddr filename_string, int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #FD_CLOSE_FILE_ADDR
    stx 2,y
    ldx #FD_CLOSE_FILE_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int FD_Open_File_For_Read( xaddr filename_string, int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #FD_OPEN_FILE_FOR_READ_ADDR
    stx 2,y
    ldx #FD_OPEN_FILE_FOR_READ_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int FD_Make_Subdirectory_Datetime( xaddr name_string, long datetime, int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #FD_MAKE_SUBDIRECTORY_DATETIME_ADDR
    stx 2,y
    ldx #FD_MAKE_SUBDIRECTORY_DATETIME_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int FD_Open_File_For_Write_Datetime( xaddr filename_string, long datetime, int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #FD_OPEN_FILE_FOR_WRITE_DATETIME_ADDR
    stx 2,y
    ldx #FD_OPEN_FILE_FOR_WRITE_DATETIME_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int FD_Rename_File1_As_File2( xaddr name1_string, xaddr name2_string, int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #FD_RENAME_FILE1_AS_FILE2_ADDR
    stx 2,y
    ldx #FD_RENAME_FILE1_AS_FILE2_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int FD_Free_Space_Kbytes( int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #FD_FREE_SPACE_KBYTES_ADDR
    stx 2,y
    ldx #FD_FREE_SPACE_KBYTES_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int FD_Print_Free_Space_Kbytes( int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #FD_PRINT_FREE_SPACE_KBYTES_ADDR
    stx 2,y
    ldx #FD_PRINT_FREE_SPACE_KBYTES_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int FD_Free_Space_Kbytes_Extended( int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #FD_FREE_SPACE_KBYTES_EXTENDED_ADDR
    stx 2,y
    ldx #FD_FREE_SPACE_KBYTES_EXTENDED_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int FD_Print_Free_Space_Kbytes_Extended( int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #FD_PRINT_FREE_SPACE_KBYTES_EXTENDED_ADDR
    stx 2,y
    ldx #FD_PRINT_FREE_SPACE_KBYTES_EXTENDED_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int FD_Disk_Serial_Number( int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #FD_DISK_SERIAL_NUMBER_ADDR
    stx 2,y
    ldx #FD_DISK_SERIAL_NUMBER_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int FD_Print_Disk_Serial_Number( int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #FD_PRINT_DISK_SERIAL_NUMBER_ADDR
    stx 2,y
    ldx #FD_PRINT_DISK_SERIAL_NUMBER_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int FD_Disk_Volume_Label( int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #FD_DISK_VOLUME_LABEL_ADDR
    stx 2,y
    ldx #FD_DISK_VOLUME_LABEL_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int FD_Print_Disk_Volume_Label( int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #FD_PRINT_DISK_VOLUME_LABEL_ADDR
    stx 2,y
    ldx #FD_PRINT_DISK_VOLUME_LABEL_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int FD_ID_Disk_Drive( int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #FD_ID_DISK_DRIVE_ADDR
    stx 2,y
    ldx #FD_ID_DISK_DRIVE_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int FD_Print_ID_Disk_Drive( int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #FD_PRINT_ID_DISK_DRIVE_ADDR
    stx 2,y
    ldx #FD_PRINT_ID_DISK_DRIVE_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int FD_Seek_To_File_Position( long file_position, int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #FD_SEEK_TO_FILE_POSITION_ADDR
    stx 2,y
    ldx #FD_SEEK_TO_FILE_POSITION_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int FD_Dir_File( xaddr filename_string, int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #FD_DIR_FILE_ADDR
    stx 2,y
    ldx #FD_DIR_FILE_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int FD_Print_Dir_File( xaddr filename_string, int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #FD_PRINT_DIR_FILE_ADDR
    stx 2,y
    ldx #FD_PRINT_DIR_FILE_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int FD_Dir_File_Time( xaddr filename_string, int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #FD_DIR_FILE_TIME_ADDR
    stx 2,y
    ldx #FD_DIR_FILE_TIME_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int FD_Print_Dir_File_Time( xaddr filename_string, int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #FD_PRINT_DIR_FILE_TIME_ADDR
    stx 2,y
    ldx #FD_PRINT_DIR_FILE_TIME_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int FD_Dir( int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #FD_DIR_ADDR
    stx 2,y
    ldx #FD_DIR_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int FD_Print_Dir( int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #FD_PRINT_DIR_ADDR
    stx 2,y
    ldx #FD_PRINT_DIR_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  ulong FD_Write_To_File( xaddr buffer, uint numbytes, int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #FD_WRITE_TO_FILE_ADDR
    stx 2,y
    ldx #FD_WRITE_TO_FILE_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  ulong FD_Get_File_Size( xaddr filename, int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #FD_GET_FILE_SIZE_ADDR
    stx 2,y
    ldx #FD_GET_FILE_SIZE_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  ulong FD_Read_From_File( xaddr buf, uint numbytes, ulong file_pos, xaddr file, int module )
{
#asm
    dey
    dey
    dey
    dey
    ldx #FD_READ_FROM_FILE_ADDR
    stx 2,y
    ldx #FD_READ_FROM_FILE_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  ulong FD_Read_Entire_File( xaddr buf, xaddr filename_string, int module )
{
#asm
    dey
    dey
    dey
    dey
    ldx #FD_READ_ENTIRE_FILE_ADDR
    stx 2,y
    ldx #FD_READ_ENTIRE_FILE_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  uint FD_Init_Buffers( xaddr info_struct,xaddr inbuf,uint inbuf_numbytes,int baud,int module)
{
#asm
    dey
    dey
    dey
    dey
    ldx #FD_INIT_BUFFERS_ADDR
    stx 2,y
    ldx #FD_INIT_BUFFERS_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  uint FD_Init_Buffers_Default( int runtime_baud_over_100, int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #FD_INIT_BUFFERS_DEFAULT_ADDR
    stx 2,y
    ldx #FD_INIT_BUFFERS_DEFAULT_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int FD_Init_Comms( uint prior_baud_over_100, int runtime_baud_over_100, int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #FD_INIT_COMMS_ADDR
    stx 2,y
    ldx #FD_INIT_COMMS_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int FD_Confirm_Comms( int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #FD_CONFIRM_COMMS_ADDR
    stx 2,y
    ldx #FD_CONFIRM_COMMS_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int FD_Wait_Til_Disk_Ready( int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #FD_WAIT_TIL_DISK_READY_ADDR
    stx 2,y
    ldx #FD_WAIT_TIL_DISK_READY_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int FD_Init_All( int baud_over_100, int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #FD_INIT_ALL_ADDR
    stx 2,y
    ldx #FD_INIT_ALL_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int FD_Coldstart( int baud_over_100, int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #FD_COLDSTART_ADDR
    stx 2,y
    ldx #FD_COLDSTART_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int FD_Coldstart_Default( int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #FD_COLDSTART_DEFAULT_ADDR
    stx 2,y
    ldx #FD_COLDSTART_DEFAULT_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int FD_Coldstart_Diagnose( int echo_incoming,int echo_outgoing,int baud_over_100,int module)
{
#asm
    dey
    dey
    dey
    dey
    ldx #FD_COLDSTART_DIAGNOSE_ADDR
    stx 2,y
    ldx #FD_COLDSTART_DIAGNOSE_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}
