
_forth  void Cat (xaddr countedLStrAddr, uint maxChars, xaddr strToAdd, int cntToAdd, uint eol)
{
#asm
    dey
    dey
    dey
    dey
    ldx #CAT_ADDR
    stx 2,y
    ldx #CAT_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_at(ether_revector_module_XADDR)  int ether_revector_module;

_at(ether_service_module_XADDR)  int ether_service_module;

_at(ether_command_XADDR)  ulong ether_command;

_at(ether_response_XADDR)  ulong ether_response;

_at(ether_gui_message_XADDR)  ulong ether_gui_message;

_forth  void WiFi_Module ( int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #WIFI_MODULE_ADDR
    stx 2,y
    ldx #WIFI_MODULE_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  xaddr Ether_Info ( int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #ETHER_INFO_ADDR
    stx 2,y
    ldx #ETHER_INFO_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int WiFi_Check ( int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #WIFI_CHECK_ADDR
    stx 2,y
    ldx #WIFI_CHECK_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  xaddr Ether_My_IP_Ptr ( int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #ETHER_MY_IP_PTR_ADDR
    stx 2,y
    ldx #ETHER_MY_IP_PTR_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  xaddr Ether_Gateway_IP_Ptr ( int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #ETHER_GATEWAY_IP_PTR_ADDR
    stx 2,y
    ldx #ETHER_GATEWAY_IP_PTR_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  xaddr Ether_Netmask_Ptr ( int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #ETHER_NETMASK_PTR_ADDR
    stx 2,y
    ldx #ETHER_NETMASK_PTR_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  xaddr Ether_Inbuf ( int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #ETHER_INBUF_ADDR
    stx 2,y
    ldx #ETHER_INBUF_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  xaddr Ether_Outbuf ( int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #ETHER_OUTBUF_ADDR
    stx 2,y
    ldx #ETHER_OUTBUF_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  uint Ether_Outbufsize ( int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #ETHER_OUTBUFSIZE_ADDR
    stx 2,y
    ldx #ETHER_OUTBUFSIZE_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  uint Ether_Inbufsize ( int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #ETHER_INBUFSIZE_ADDR
    stx 2,y
    ldx #ETHER_INBUFSIZE_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Ether_Set_Inbuf ( xaddr bufbase, int maxnumbytes, int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #ETHER_SET_INBUF_ADDR
    stx 2,y
    ldx #ETHER_SET_INBUF_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Ether_Set_Outbuf ( xaddr xbufbase, int maxnumbytes, int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #ETHER_SET_OUTBUF_ADDR
    stx 2,y
    ldx #ETHER_SET_OUTBUF_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  xaddr HTTP_Inbuf ( int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #HTTP_INBUF_ADDR
    stx 2,y
    ldx #HTTP_INBUF_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  xaddr HTTP_Outbuf ( int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #HTTP_OUTBUF_ADDR
    stx 2,y
    ldx #HTTP_OUTBUF_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  uint HTTP_Outbufsize ( int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #HTTP_OUTBUFSIZE_ADDR
    stx 2,y
    ldx #HTTP_OUTBUFSIZE_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  uint HTTP_Inbufsize ( int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #HTTP_INBUFSIZE_ADDR
    stx 2,y
    ldx #HTTP_INBUFSIZE_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void HTTP_Set_Inbuf ( xaddr xbufbase, int maxnumbytes, int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #HTTP_SET_INBUF_ADDR
    stx 2,y
    ldx #HTTP_SET_INBUF_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void HTTP_Set_Outbuf ( xaddr bufbase, int maxnumbytes, int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #HTTP_SET_OUTBUF_ADDR
    stx 2,y
    ldx #HTTP_SET_OUTBUF_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  uint Ether_Error ( int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #ETHER_ERROR_ADDR
    stx 2,y
    ldx #ETHER_ERROR_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Ether_Error_Clear ( int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #ETHER_ERROR_CLEAR_ADDR
    stx 2,y
    ldx #ETHER_ERROR_CLEAR_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  xaddr HTTP_Enable_Ptr ( int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #HTTP_ENABLE_PTR_ADDR
    stx 2,y
    ldx #HTTP_ENABLE_PTR_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  xaddr Ether_Tunnel_Enable_Ptr ( int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #ETHER_TUNNEL_ENABLE_PTR_ADDR
    stx 2,y
    ldx #ETHER_TUNNEL_ENABLE_PTR_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  uint HTTP_Numbytes_Sent ( int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #HTTP_NUMBYTES_SENT_ADDR
    stx 2,y
    ldx #HTTP_NUMBYTES_SENT_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  xaddr HTTP_Status_Ptr ( int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #HTTP_STATUS_PTR_ADDR
    stx 2,y
    ldx #HTTP_STATUS_PTR_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  xaddr HTTP_Timeout_Msec_Ptr ( int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #HTTP_TIMEOUT_MSEC_PTR_ADDR
    stx 2,y
    ldx #HTTP_TIMEOUT_MSEC_PTR_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  xaddr HTTP_Get_Timeout_Msec_Ptr ( int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #HTTP_GET_TIMEOUT_MSEC_PTR_ADDR
    stx 2,y
    ldx #HTTP_GET_TIMEOUT_MSEC_PTR_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  xaddr HTTP_Index_Ptr ( int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #HTTP_INDEX_PTR_ADDR
    stx 2,y
    ldx #HTTP_INDEX_PTR_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void HTTP_Is_Autoserve_Array ( xaddr xarraybase, int numrows, int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #HTTP_IS_AUTOSERVE_ARRAY_ADDR
    stx 2,y
    ldx #HTTP_IS_AUTOSERVE_ARRAY_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  xaddr HTTP_Autoserve_Ptr ( int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #HTTP_AUTOSERVE_PTR_ADDR
    stx 2,y
    ldx #HTTP_AUTOSERVE_PTR_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  xaddr HTTP_Default_Handler_Ptr ( int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #HTTP_DEFAULT_HANDLER_PTR_ADDR
    stx 2,y
    ldx #HTTP_DEFAULT_HANDLER_PTR_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  xaddr HTTP_URL_Ptr ( int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #HTTP_URL_PTR_ADDR
    stx 2,y
    ldx #HTTP_URL_PTR_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int HTTP_URL_Full_Count ( int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #HTTP_URL_FULL_COUNT_ADDR
    stx 2,y
    ldx #HTTP_URL_FULL_COUNT_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int HTTP_URL_Base_Count ( int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #HTTP_URL_BASE_COUNT_ADDR
    stx 2,y
    ldx #HTTP_URL_BASE_COUNT_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Ether_Local_IP ( char ip1, char ip2, char ip3, char ip4, int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #ETHER_LOCAL_IP_ADDR
    stx 2,y
    ldx #ETHER_LOCAL_IP_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Ether_Local_Port ( int portnum, int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #ETHER_LOCAL_PORT_ADDR
    stx 2,y
    ldx #ETHER_LOCAL_PORT_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Ether_Internal_Webserver_Port ( int portnum, int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #ETHER_INTERNAL_WEBSERVER_PORT_ADDR
    stx 2,y
    ldx #ETHER_INTERNAL_WEBSERVER_PORT_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Ether_Gateway ( char ip1,char ip2,char ip3,char ip4, int subnet_bits, int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #ETHER_GATEWAY_ADDR
    stx 2,y
    ldx #ETHER_GATEWAY_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  xaddr Ether_Remote_IP_Ptr ( int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #ETHER_REMOTE_IP_PTR_ADDR
    stx 2,y
    ldx #ETHER_REMOTE_IP_PTR_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  xaddr Ether_Remote_Port_Ptr ( int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #ETHER_REMOTE_PORT_PTR_ADDR
    stx 2,y
    ldx #ETHER_REMOTE_PORT_PTR_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Ether_DHCP_Name ( xaddr xname_string, int name_cnt, int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #ETHER_DHCP_NAME_ADDR
    stx 2,y
    ldx #ETHER_DHCP_NAME_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Ether_Telnet_Password ( xaddr xpassword_string, int password_cnt, int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #ETHER_TELNET_PASSWORD_ADDR
    stx 2,y
    ldx #ETHER_TELNET_PASSWORD_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Ether_TCP_Control ( char keepalive_sec, char discon_minutes, int send_imm_chars, char flushmode, char packing, int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #ETHER_TCP_CONTROL_ADDR
    stx 2,y
    ldx #ETHER_TCP_CONTROL_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void WiFi_Security ( int authenticate_flag, int suite_method, int pairwise_encrypt_method,	int group_encrypt_method, int key_length, int passphrase_flag, int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #WIFI_SECURITY_ADDR
    stx 2,y
    ldx #WIFI_SECURITY_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void WiFi_SSID ( xaddr ssid_buffer_xbase, int count, int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #WIFI_SSID_ADDR
    stx 2,y
    ldx #WIFI_SSID_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void WiFi_Options ( int tx_power_level, int tx_power_manager_flag, int tx_rate, int tx_auto_rate_flag, int adhoc_flag, int adhoc_chan, int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #WIFI_OPTIONS_ADDR
    stx 2,y
    ldx #WIFI_OPTIONS_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Ether_Emit ( uchar character,  int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #ETHER_EMIT_ADDR
    stx 2,y
    ldx #ETHER_EMIT_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int Ether_Ask_Emit ( int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #ETHER_ASK_EMIT_ADDR
    stx 2,y
    ldx #ETHER_ASK_EMIT_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int Ether_Ask_Key ( int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #ETHER_ASK_KEY_ADDR
    stx 2,y
    ldx #ETHER_ASK_KEY_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  uchar Ether_Key ( int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #ETHER_KEY_ADDR
    stx 2,y
    ldx #ETHER_KEY_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  uchar Ether_ASCII_Key ( int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #ETHER_ASCII_KEY_ADDR
    stx 2,y
    ldx #ETHER_ASCII_KEY_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void E_Emit ( uchar character )
{
#asm
    dey
    dey
    dey
    dey
    ldx #E_EMIT_ADDR
    stx 2,y
    ldx #E_EMIT_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int E_Ask_Key ( void )
{
#asm
    dey
    dey
    dey
    dey
    ldx #E_ASK_KEY_ADDR
    stx 2,y
    ldx #E_ASK_KEY_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  uchar E_Key ( void )
{
#asm
    dey
    dey
    dey
    dey
    ldx #E_KEY_ADDR
    stx 2,y
    ldx #E_KEY_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  uchar E_ASCII_Key ( void )
{
#asm
    dey
    dey
    dey
    dey
    ldx #E_ASCII_KEY_ADDR
    stx 2,y
    ldx #E_ASCII_KEY_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Ether_Outbuf_Cat ( xaddr xstring, uint count, int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #ETHER_OUTBUF_CAT_ADDR
    stx 2,y
    ldx #ETHER_OUTBUF_CAT_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void HTTP_Outbuf_Cat ( xaddr xstring, uint count, int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #HTTP_OUTBUF_CAT_ADDR
    stx 2,y
    ldx #HTTP_OUTBUF_CAT_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Ether_Shutdown ( int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #ETHER_SHUTDOWN_ADDR
    stx 2,y
    ldx #ETHER_SHUTDOWN_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int Ether_Ready_For_Command ( int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #ETHER_READY_FOR_COMMAND_ADDR
    stx 2,y
    ldx #ETHER_READY_FOR_COMMAND_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  ulong Ether_Await_Response ( int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #ETHER_AWAIT_RESPONSE_ADDR
    stx 2,y
    ldx #ETHER_AWAIT_RESPONSE_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  ulong Ether_Check_Response ( int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #ETHER_CHECK_RESPONSE_ADDR
    stx 2,y
    ldx #ETHER_CHECK_RESPONSE_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int Ether_Connect_Status ( int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #ETHER_CONNECT_STATUS_ADDR
    stx 2,y
    ldx #ETHER_CONNECT_STATUS_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int Ether_Passive_Non_Web_Connection ( int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #ETHER_PASSIVE_NON_WEB_CONNECTION_ADDR
    stx 2,y
    ldx #ETHER_PASSIVE_NON_WEB_CONNECTION_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int Ether_Disconnect_During_Send ( int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #ETHER_DISCONNECT_DURING_SEND_ADDR
    stx 2,y
    ldx #ETHER_DISCONNECT_DURING_SEND_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Ether_Flush_NBytes ( uint maxbytes, uint timeout_msec, int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #ETHER_FLUSH_NBYTES_ADDR
    stx 2,y
    ldx #ETHER_FLUSH_NBYTES_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Ether_Flush ( int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #ETHER_FLUSH_ADDR
    stx 2,y
    ldx #ETHER_FLUSH_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Ether_Add_Data ( xaddr xlbuffer, uint maxbytes, uint timeout_msec, int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #ETHER_ADD_DATA_ADDR
    stx 2,y
    ldx #ETHER_ADD_DATA_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Ether_Get_Data ( xaddr xlbuffer, uint maxbytes, uint timeout_msec, int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #ETHER_GET_DATA_ADDR
    stx 2,y
    ldx #ETHER_GET_DATA_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Ether_Add_Chars ( xaddr xlbuffer, uint maxbytes, uint maxlines, char eol, int discard_alt_eol, int discard_msbit_set, uint timeout_msec, int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #ETHER_ADD_CHARS_ADDR
    stx 2,y
    ldx #ETHER_ADD_CHARS_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Ether_Get_Chars ( xaddr xlbuffer, uint maxbytes, uint maxlines, char eol, int discard_alt_eol, int discard_msbit_set, uint timeout_msec, int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #ETHER_GET_CHARS_ADDR
    stx 2,y
    ldx #ETHER_GET_CHARS_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Ether_Get_Line ( xaddr xlbuffer, uint maxbytes, char eol, int discard_alt_eol, int discard_msbit_set, uint timeout_msec, int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #ETHER_GET_LINE_ADDR
    stx 2,y
    ldx #ETHER_GET_LINE_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Ether_Add_Line ( xaddr xlbuffer, uint maxbytes, char eol, int discard_alt_eol, int discard_msbit_set, uint timeout_msec, int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #ETHER_ADD_LINE_ADDR
    stx 2,y
    ldx #ETHER_ADD_LINE_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Ether_Send_Buffer ( xaddr xbuffer, uint count, uint timeout_msec, int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #ETHER_SEND_BUFFER_ADDR
    stx 2,y
    ldx #ETHER_SEND_BUFFER_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Ether_Send_LBuffer ( xaddr xlbuffer, uint timeout_msec, int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #ETHER_SEND_LBUFFER_ADDR
    stx 2,y
    ldx #ETHER_SEND_LBUFFER_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Ether_Send_2Buffers ( xaddr xbuffer1, uint count1, xaddr xbuffer2, uint count2, uint timeout_msec, int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #ETHER_SEND_2BUFFERS_ADDR
    stx 2,y
    ldx #ETHER_SEND_2BUFFERS_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int Ether_Encryption ( xaddr key_buffer_xbase, int num_key_bytes, int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #ETHER_ENCRYPTION_ADDR
    stx 2,y
    ldx #ETHER_ENCRYPTION_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int WiFi_Encryption_Key ( xaddr key_buffer_xbase, int num_key_bytes, int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #WIFI_ENCRYPTION_KEY_ADDR
    stx 2,y
    ldx #WIFI_ENCRYPTION_KEY_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Ether_XPort_Defaults ( int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #ETHER_XPORT_DEFAULTS_ADDR
    stx 2,y
    ldx #ETHER_XPORT_DEFAULTS_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Ether_XPort_Update ( int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #ETHER_XPORT_UPDATE_ADDR
    stx 2,y
    ldx #ETHER_XPORT_UPDATE_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Ether_Ping_Request ( char ip1, char ip2, char ip3, char ip4, int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #ETHER_PING_REQUEST_ADDR
    stx 2,y
    ldx #ETHER_PING_REQUEST_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Ether_Ping_Report ( char ip1, char ip2, char ip3, char ip4, int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #ETHER_PING_REPORT_ADDR
    stx 2,y
    ldx #ETHER_PING_REPORT_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Ether_IP_Info_Request ( int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #ETHER_IP_INFO_REQUEST_ADDR
    stx 2,y
    ldx #ETHER_IP_INFO_REQUEST_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Ether_IP_Info_Report ( int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #ETHER_IP_INFO_REPORT_ADDR
    stx 2,y
    ldx #ETHER_IP_INFO_REPORT_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Ether_Disconnect ( int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #ETHER_DISCONNECT_ADDR
    stx 2,y
    ldx #ETHER_DISCONNECT_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Ether_Disconnect_Flush ( int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #ETHER_DISCONNECT_FLUSH_ADDR
    stx 2,y
    ldx #ETHER_DISCONNECT_FLUSH_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Ether_Connect ( char ip1, char ip2, char ip3, char ip4, int port, int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #ETHER_CONNECT_ADDR
    stx 2,y
    ldx #ETHER_CONNECT_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int HTTP_Add_Handler ( xaddr url_xstring, int url_count, xaddr (*handler_ptr)(void), int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #HTTP_ADD_HANDLER_ADDR
    stx 2,y
    ldx #HTTP_ADD_HANDLER_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int HTTP_Add_GUI_Handler ( xaddr url_xstring, int url_count, xaddr (*handler_ptr)(void), int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #HTTP_ADD_GUI_HANDLER_ADDR
    stx 2,y
    ldx #HTTP_ADD_GUI_HANDLER_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  xaddr HTTP_Fieldname_Ptr ( int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #HTTP_FIELDNAME_PTR_ADDR
    stx 2,y
    ldx #HTTP_FIELDNAME_PTR_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int HTTP_Fieldname_Count ( int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #HTTP_FIELDNAME_COUNT_ADDR
    stx 2,y
    ldx #HTTP_FIELDNAME_COUNT_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  xaddr HTTP_Value_Ptr ( int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #HTTP_VALUE_PTR_ADDR
    stx 2,y
    ldx #HTTP_VALUE_PTR_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int HTTP_Value_Count ( int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #HTTP_VALUE_COUNT_ADDR
    stx 2,y
    ldx #HTTP_VALUE_COUNT_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int HTTP_To_Next_Field ( int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #HTTP_TO_NEXT_FIELD_ADDR
    stx 2,y
    ldx #HTTP_TO_NEXT_FIELD_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  TWO_INTS HTTP_Imagemap ( int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #HTTP_IMAGEMAP_ADDR
    stx 2,y
    ldx #HTTP_IMAGEMAP_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void HTTP_Plus_To_Space ( xaddr xstring, int count )
{
#asm
    dey
    dey
    dey
    dey
    ldx #HTTP_PLUS_TO_SPACE_ADDR
    stx 2,y
    ldx #HTTP_PLUS_TO_SPACE_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int HTTP_Unescape ( xaddr xstring, int count )
{
#asm
    dey
    dey
    dey
    dey
    ldx #HTTP_UNESCAPE_ADDR
    stx 2,y
    ldx #HTTP_UNESCAPE_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void HTTP_Parse_URL ( xaddr xstring, int count, int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #HTTP_PARSE_URL_ADDR
    stx 2,y
    ldx #HTTP_PARSE_URL_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  uint HTTP_Send_Buffer ( xaddr xbuffer, uint count, int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #HTTP_SEND_BUFFER_ADDR
    stx 2,y
    ldx #HTTP_SEND_BUFFER_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  uint HTTP_Send_LBuffer ( xaddr xlbuffer, int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #HTTP_SEND_LBUFFER_ADDR
    stx 2,y
    ldx #HTTP_SEND_LBUFFER_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  uint HTTP_Send_2Buffers ( xaddr xbuffer1, uint count1, xaddr xbuffer2, uint count2,							int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #HTTP_SEND_2BUFFERS_ADDR
    stx 2,y
    ldx #HTTP_SEND_2BUFFERS_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void HTTP_GUI_Send_Buffer ( xaddr xbuffer, uint count, int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #HTTP_GUI_SEND_BUFFER_ADDR
    stx 2,y
    ldx #HTTP_GUI_SEND_BUFFER_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void HTTP_GUI_Send_LBuffer ( xaddr xlbuffer, int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #HTTP_GUI_SEND_LBUFFER_ADDR
    stx 2,y
    ldx #HTTP_GUI_SEND_LBUFFER_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void HTTP_GUI_Send_2Buffers ( xaddr xbuffer1, uint count1, xaddr xbuffer2, uint count2, int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #HTTP_GUI_SEND_2BUFFERS_ADDR
    stx 2,y
    ldx #HTTP_GUI_SEND_2BUFFERS_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void HTTP_Put_Header ( xaddr xlbuffer, uint bufsize )
{
#asm
    dey
    dey
    dey
    dey
    ldx #HTTP_PUT_HEADER_ADDR
    stx 2,y
    ldx #HTTP_PUT_HEADER_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void HTTP_Put_Content_Type ( xaddr xlbuffer, uint bufsize, int dynamic, int content_type )
{
#asm
    dey
    dey
    dey
    dey
    ldx #HTTP_PUT_CONTENT_TYPE_ADDR
    stx 2,y
    ldx #HTTP_PUT_CONTENT_TYPE_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void HTTP_Default_Handler ( int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #HTTP_DEFAULT_HANDLER_ADDR
    stx 2,y
    ldx #HTTP_DEFAULT_HANDLER_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void HTTP_Server ( int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #HTTP_SERVER_ADDR
    stx 2,y
    ldx #HTTP_SERVER_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int Ether_Check_GUI ( int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #ETHER_CHECK_GUI_ADDR
    stx 2,y
    ldx #ETHER_CHECK_GUI_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Ether_Send_Email ( xaddr xemail_body,uint bodycnt,xaddr xhost,int hostcnt, xaddr xsender,int sendercnt,xaddr xrcvr, int rcvrcnt,xaddr xscratchbuf, char dest_ip1,char ip2,char ip3,char ip4,int destport,uint timeout_ms,int module)
{
#asm
    dey
    dey
    dey
    dey
    ldx #ETHER_SEND_EMAIL_ADDR
    stx 2,y
    ldx #ETHER_SEND_EMAIL_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int Ether_Info_Init ( xaddr xinfo,xaddr xautoserve,int numrows,xaddr xbuffer_area_base, xaddr xcmdmail,xaddr xresponsemail,xaddr xguimail,uint etherinbufsize, uint etheroutbufsize,uint httpinbufsize,uint httpoutbufsize,int modulenum)
{
#asm
    dey
    dey
    dey
    dey
    ldx #ETHER_INFO_INIT_ADDR
    stx 2,y
    ldx #ETHER_INFO_INIT_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  int WiFi_Info_Init ( xaddr xinfo,xaddr xautoserve,int numrows,xaddr xbuffer_area_base, xaddr xcmdmail,xaddr xresponsemail,xaddr xguimail,uint etherinbufsize, uint etheroutbufsize,uint httpinbufsize,uint httpoutbufsize,int modulenum)
{
#asm
    dey
    dey
    dey
    dey
    ldx #WIFI_INFO_INIT_ADDR
    stx 2,y
    ldx #WIFI_INFO_INIT_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  uint Ether_Init ( xaddr xinfo,xaddr xautoserve,int numrows,xaddr xbuffer_area_base, xaddr xcmdmail,xaddr xresponsemail,xaddr xguimail,uint etherinbufsize, uint etheroutbufsize,uint httpinbufsize,uint httpoutbufsize,int modulenum)
{
#asm
    dey
    dey
    dey
    dey
    ldx #ETHER_INIT_ADDR
    stx 2,y
    ldx #ETHER_INIT_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  uint WiFi_Init ( xaddr xinfo,xaddr xautoserve,int numrows,xaddr xbuffer_area_base, xaddr xcmdmail,xaddr xresponsemail,xaddr xguimail,uint etherinbufsize, uint etheroutbufsize,uint httpinbufsize,uint httpoutbufsize,int modulenum)
{
#asm
    dey
    dey
    dey
    dey
    ldx #WIFI_INIT_ADDR
    stx 2,y
    ldx #WIFI_INIT_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  uint Ether_Setup ( xaddr xbuffer_area_base, addr mailbox_base, int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #ETHER_SETUP_ADDR
    stx 2,y
    ldx #ETHER_SETUP_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  uint WiFi_Setup ( xaddr xbuffer_area_base, addr mailbox_base, int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #WIFI_SETUP_ADDR
    stx 2,y
    ldx #WIFI_SETUP_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  uint Ether_Setup_Default ( int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #ETHER_SETUP_DEFAULT_ADDR
    stx 2,y
    ldx #ETHER_SETUP_DEFAULT_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  uint WiFi_Setup_Default ( int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #WIFI_SETUP_DEFAULT_ADDR
    stx 2,y
    ldx #WIFI_SETUP_DEFAULT_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Ether_Command_Manager ( int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #ETHER_COMMAND_MANAGER_ADDR
    stx 2,y
    ldx #ETHER_COMMAND_MANAGER_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Ether_Connection_Manager ( int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #ETHER_CONNECTION_MANAGER_ADDR
    stx 2,y
    ldx #ETHER_CONNECTION_MANAGER_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Ether_Service_Loop ( void )
{
#asm
    dey
    dey
    dey
    dey
    ldx #ETHER_SERVICE_LOOP_ADDR
    stx 2,y
    ldx #ETHER_SERVICE_LOOP_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Ether_Task_Setup ( TASK* task_base, int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #ETHER_TASK_SETUP_ADDR
    stx 2,y
    ldx #ETHER_TASK_SETUP_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void WiFi_Task_Setup ( TASK* task_base, int modulenum )
{
#asm
    dey
    dey
    dey
    dey
    ldx #WIFI_TASK_SETUP_ADDR
    stx 2,y
    ldx #WIFI_TASK_SETUP_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Ether_Serial_Revector ( void )
{
#asm
    dey
    dey
    dey
    dey
    ldx #ETHER_SERIAL_REVECTOR_ADDR
    stx 2,y
    ldx #ETHER_SERIAL_REVECTOR_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}

_forth  void Ether_Monitor ( void )
{
#asm
    dey
    dey
    dey
    dey
    ldx #ETHER_MONITOR_ADDR
    stx 2,y
    ldx #ETHER_MONITOR_PAGE
    stx 0,y
    bsr _forth?Execute
#endasm
}
