// put published C constant #defines here:

// DAC channels
#define DAC12_CH0 0x00
#define DAC12_CH1 0x10
#define DAC12_CH2 0x20
#define DAC12_CH3 0x30
#define DAC12_CH4 0x40
#define DAC12_CH5 0x50
#define DAC12_CH6 0x60
#define DAC12_CH7 0x70

// DAC Reference options
#define INT_2V_DAC12 0x06
#define INT_1V_DAC12 0x04
#define EXT_DAC12    0x00

// Valid channels for the 16-bit A/D, singled ended sampling (analog ground is the
// negative input channel)
#define AD16_CH0 0x04
#define AD16_CH1 0x44
#define AD16_CH2 0x14
#define AD16_CH3 0x54
#define AD16_CH4 0x24
#define AD16_CH5 0x64
#define AD16_CH6 0x34
#define AD16_CH7 0x74

// Differential channel options.  The first number represents the positive input
// channel and the second number represents the negative input channel.  Remember,
// the positive input channel cannot go below the negative input channel (this A/D
// cannot read negative voltages).  Also, the negative input channel cannot go above
// 1.25v.
#define AD16_CH0_CH1 0x00
#define AD16_CH1_CH0 0x40
#define AD16_CH2_CH3 0x10
#define AD16_CH3_CH2 0x50
#define AD16_CH4_CH5 0x20
#define AD16_CH5_CH4 0x60
#define AD16_CH6_CH7 0x30
#define AD16_CH7_CH6 0x70


extern _forth  void To_DAC12 ( int value, int channel_num, int module_num );

extern _forth  void Update_DAC12 ( int module_num );

extern _forth  void Delay_Update_DAC12 ( int module_num );

extern _forth  void To_All_DACs ( int value, int module_num );

extern _forth  uint AD16_Sample ( int channel_num, int module_num );

extern _forth  void AD16_Multiple ( xaddr buffer, uint interval, uint num_samples, int channel_num,
                      int module_num );

extern _forth  void Init_Analog_IO ( int reference, int module_num );
