#!/usr/bin/perl -w -T
use CGI qw/:standard/;
# use CGI::Cookie;

use strict;
use diagnostics;

delete @ENV{qw(IFS PATH CDPATH ENV BASH_ENV)};   # Clean up security parils

our $error="<h1 class=\"error\">Error:</h1><br>";
our $tmproot="/tmp/mosaic-kem-";
our $zip_outfilename="packages.zip";  # Default save as filename for user's
                                      # browser
our %packages;  # Packages is a hash with the package names as the keys,
                # and each member is an anonymous hash inside.

our $css_style_sheet;
our $been_built;   # printed at the top of the page upon sucessful building
                  # of a package.
our $schemapath="./schemas";
our $schema_explanation;  # String containing the html that explains schemas
our @schemas;             # list of schemas to offer; list also dictates
                          # the order they are offered

our @kemoutput;           # Array containing the output of kem detail_list
our @kembuildoutput;      # Array containing the output of kem build
our @packages_to_build;   # Array listing the selected backage

our $session_id='';       # Holds a random number that is the session ID
our $nocookies=0;         # Flag indicating if this browser likes cookies
our $no_footer=0;         # State variable to prevent the </html> from being
                          # printed at the end of the page
our $schema;
our $kemtmp;              # The path to which a backage is built
our $instance_id=script_name();

our $show_all_versions=0;   # Default for whether all versions are shown or only the most recent

# Instead of specifying the libpath here, we want to have it be specified as part of the main form
# The opening page must either assume a default, or not show the list at all until
# the user specifies.
our $buildcmd="/usr/bin/perl -T ./bin/kem.pl build ";
our $listcmd="/usr/bin/perl -T ./bin/kem.pl detail_list ";
our $maintitle="<B><FONT SIZE=+2 color=blue> Kernel Extension Manager </FONT></B>";

our $overflow_err_msg=<<ENDHTML;
Not enough memory available for the kernel exensions you selected.  Contact Mosaic Industries
with any questions.  See below for the raw output of the KEM tool.
ENDHTML

our $debugging_cgi=0;     # causes addional debugging info to be added to html
our $low_level_debugging=0;     # causes addional debugging info to be added to html

our $rooturl=""; # virtual_host;
our $session_id_url="";   # Set this to have it added to all redirects and links

sub run_kem_list();
sub scan_for_packages(\%);
sub normal_opening();
sub run_kem_build();
sub do_top();
sub print_schema_form();
sub show_packages_table();
sub set_schema($);
sub do_cookies();

# #####################################################################
# #####################################################################
# ####
# ####   Runtime follows
# ####


# #### Two main cases:  Parameters have been specified; and parameters have not
# #### specified

# Lets read a configuration file first.  This'll make life much simpler for us
do ($schemapath."/kemcgi.pl");   # This is just a perl script to be evaluated

do_cookies();   # This will set up the session ID and might reload the
                # page in the process.  There is always a sessionid,
                # base url,
# This next test can probably be removed
if (!defined($session_id))    # This should be impossible
{
  print STDERR "This is strange.  We had to be kicked back due to not having a session ID\n"
    if ($low_level_debugging);
  print redirect("$rooturl$instance_id");  # If no session ID provided,
  $no_footer=1;                           # Force 'em back
  exit(0);
}
# End section that should probably be removed.


if (!defined param('schema'))
{ # Since we weren't told what schema, we must get that information with a form
  do_top();     # Main top level entry for no parameters.  There is nothing
                # else to do after printing the form, so we exit
  exit(0);      # Program termination
}
else
{
  # the schema parameter was specified.  The schema affects everything we do now
  set_schema(param('schema'));  # Call the function to set the schema parameter

  if (param('downloadzip'))    # They clicked the download link after generation
  {

    $no_footer=1;      # Prevent the printing of the </html> at the end
    print "Content-Disposition: filename=\"$zip_outfilename\";\n";
    print "Content-Type: zip/application;\n\n";
    # my $inbyte;
    open ZIPFILE,"<", "$kemtmp.zip";
    while (!eof(ZIPFILE))
    {
      print getc(ZIPFILE);
    }
    close(ZIPFILE);
    exit(0);
  }

  normal_opening();               # We can go ahead and sent the intro since it's not
                                  # a file download
  if (run_kem_list())
  {
    print STDERR "Kem list returned with an error: $listcmd\n";
    exit(1);  # Bail
  }
  scan_for_packages(%packages);   # Now we have the packages hash ready
                                  # to be used for showing a table or
                                  # for use in building

  # ################################################################
  # ################################################################
  # #
  # # CASE:  Parameter, moreinfo was specified
  # #
  if (param('moreinfo'))
  {   #
    my $moreinfoname=param('moreinfo');
    $moreinfoname =~ s/[^[:alnum:]\-_\.]//g; # ** Sanitized **
    if (!defined($packages{$moreinfoname}))
    {
      print $error,"You have requested information on an invalid package: ",
      $moreinfoname;
      exit(1);
    }

    my $infofile=$packages{$moreinfoname}->{'info'}; # This contains the full path

    if (!open INFOFILE, '<', $infofile)
    {
      print $error;
      printf "Could not open %s\n",$infofile;
    }
    else
    {
      # Simple test here to determine if we should place <pre> tags around
      # the data we are going to send from the file.  Notice that this method
      # provides complete isolation from the actual library as this CGI acts
      # as a proxy.
      print h4('You have requested information about ',$moreinfoname);
      if (!($infofile =~ /html?$/))
      {  # It is not html content, so preformat it
        print "<pre>";
      }
      # Insert the file's contents
      while (<INFOFILE>)
      {
        print $_;
      }
      close (INFOFILE);
      if (!($infofile =~ /html?$/))

      {  # It is not html content, so preformat it
        print "</pre>";
      }
      print "<p>";
    }
  }

  # ################################################################
  # ################################################################
  # #
  # # CASE:  Parameter, build package, was specified
  # #
  if (param('Build package'))
  {
  # Build package - This part is executed for a package that is being
  # built.  This function actually builds the output
    foreach (param)
    {
      next if s/[^[:alnum:]\-_\.]//g;    # Sanitize before using as a key
      if ((param($_)eq'on') && defined($packages{$_}))
      {
#        print "<br>You want package: $_<br>";
        push @packages_to_build, $_;
      }
    }
    if (run_kem_build())
    {
      exit(1);
    }
    exit(0);
  }

  # If we haven't been caught yet, then we should go ahead and show the choices
  show_packages_table();

  exit(0);
}

END
{
#  print "Script finished<br>";
  if (!$no_footer)
  {
    print "\n</html>\n";   # Any thing else can go here..
  }
}


# #####################################################################
# #####################################################################
# ####
# ####   Subroutines follow
# ####

sub do_top()
{
  # ################################################################
  # ################################################################
  # #
  # # CASE:  No parameters specified - Top level entry
  # #   This section must generate a web form that collects
  # #   the schema information.
  # #
  # #
  print STDERR "Do_Top entered\n"
    if ($low_level_debugging);
  # Code has been changed so that do_cookies has __always__ been called so the session
  # ID and the url have been set.  The $nocookies variable
  normal_opening();         # Print all the normal stuff that starts each page
  print_schema_form();      # Generates the form asking the user for their product type
  print STDERR "do_top function exitted\n"
    if ($low_level_debugging);

}

sub print_schema_form()
{
  my $kemoptions="";
  $kemoptions .="sessionid=$session_id&nocookies=true&" if ($nocookies);
  print $schema_explanation;
  for my $i (0 .. $#schemas)
  {
    my $schemaname=$schemas[$i]{'path'};
    #print STDERR "Looking at schema $i\n";
    print <<ENDHTML;
<a href=\"$instance_id?$kemoptions
schema=$i\">
$schemas[$i]{'description'}
<br>
<img src=\"$schemas[$i]{'photo'}\">
</a>
<p>
ENDHTML
  }

}


sub show_packages_table()
{
  # ################################################################
  # ################################################################
  # #
  # # CASE:  The schema has been specified, so we know what library directory to use
  # #


  # low level testing
  print "<br><font size=+1 color=lime><b><em>Available kernel extensions</em></b></font><br>";
  print "Click on the extensions below to see a description.<br>";

# ****** Beginning of table - Requires that the package list have already been obtained
  print start_form;

  print '<table border= 1>';
  print '<tr><th height=30 width=100>Name</th><th width=300>Description</th><th>Version</th><th>Date</th></tr>';
  my $lastpkgname="";

  # To create the proper order, we make a little array here to store the package list
  # We want a-z sorting of package names, but like named packages should be sorted in
  # descending sorting order.
  my @sortedlist;
  my @sublist;      # list of each package name for sorting out version numbers
  my $seenbefore=0;
  foreach (sort(keys(%packages)))
  {
    if ($packages{$_}->{'name'} eq $lastpkgname)  # used for formatting for multiple versions
    {
      # insert before last
      #my $tmp=$sortedlist[-1];
      #$sortedlist[-1]=$_;
      #push @sortedlist,$tmp;
      unshift @sublist, $_;       # not the first time- prepend this element

    } else {
      # Append after last

      push @sortedlist,@sublist;
      #shift @sublist foreach (@sublist);     # clear out sublist
      @sublist=();
      push @sublist,$_;           # start it out anew with this element
    }
    $lastpkgname=$packages{$_}->{'name'};
  }
  push @sortedlist,@sublist;

  foreach (@sortedlist)
  {
    my $name=$_;    # name of each hask key, which is "pkgname_v<version>"
    $seenbefore=0;
    $seenbefore=1 if ($packages{$_}->{'name'} eq $lastpkgname);
    $lastpkgname=$packages{$_}->{'name'};

    my $pkgname=$packages{$name}->{'name'};
    my $description=$packages{$name}->{'description'};
    my $version=$packages{$name}->{'version'};
    my $date=$packages{$name}->{'date'};
    #print "I can see $name\n";
    my $kemoptions="moreinfo=$name&schema=$schema";
    $kemoptions .="&sessionid=$session_id&nocookies=true" if ($nocookies);

         # Do this once per package
    print "\n\n\n";
    if ($show_all_versions || !$seenbefore )
    {   # Only print it if we are to show all versions
      if ($seenbefore)
      {
        print '<tr bgcolor="red">';
      }
      else
      {
        print '<tr>';
      }
      print "<td>";
      print "<input type=\"checkbox\" name=\"$name\" value=\"on\" />",
          "<a href=\"$instance_id?$kemoptions\">";
      print "<i>" if($seenbefore);
      print $pkgname;
      print "</i>" if($seenbefore);
      print "</a>";

      print "</td><td>$description";
      print "</td>";
      print "<td>$version</td>";
      print "<td>$date</td>\n";
      print '</tr>';
    }
  }


  print "</table>\n";
  print "<input type=hidden name=schema value=$schema>";
  if ($nocookies)
  {
    print "<input type=hidden name=sessionid value=$session_id>";
    print "<input type=hidden name=nocookies value=true>";
  }

  print submit('Build package'),reset('Clear Selections'),end_form;
# ******* End of table

  exit(0);      # Ensure termination
}


sub set_schema($)
{
  # This function accepts a schema as a parameter and indexes it into a config file
  # to resolve the specifed schema.
  $schema=$_[0];             # WARNING.  THIS COMES FROM A PARAMETER

  # open the schema file and point to the desired schema
  if ( $schema =~ /^\d+$/ && $schema >= 0 && $schema < @schemas )
  {
    $buildcmd.=" -u $schemapath/$schemas[$schema]->{'path'} ";  # Tack on the config file path
    $listcmd.=" -u $schemapath/$schemas[$schema]->{'path'} ";   # Tack on the config file path
    # print STDERR "build and list are $buildcmd and $listcmd\n";
  }
  else
  { # A nonexistant schema has been requested
    do_top();
    exit(0);
  }

}

sub do_cookies()
{
  # This routine does one of three things: read the session ID from the client,
  # place a test cookie on the client and reload, or see that the $nocookies
  # variable has been set and go ahead and generate a session ID and continue


  # Cookie testing.  This is only true when called with a redirect instigated
  # by do_cookies The only purpose of this command is to determine how to redirect.
  # calling the script with nocookies is a way of bypassing this automatic test process.
  if (param('testcookies')) # we will go in here via a redirect after trying
                            # to set a cookie.
  { # we've been called to test cookiedom
    $no_footer=1;   # Either way, we're redirecting, so no footer
    print STDERR "Testcookies param specified\n"
      if ($low_level_debugging);

    if (cookie('testcookie'))
    {
      print STDERR "testcookie was found; sesID will have been set.  Redirecting to main URL.\n"
        if ($low_level_debugging);
      print redirect("$rooturl$instance_id");   # Loop back into itself, but now
      exit(0);                          # the sessionID is set
    }
    else
    {
      print STDERR "testcookie not found; sesID not set.  Redirecting with nocookies param URL.\n"
        if ($low_level_debugging);
      print redirect("$rooturl$instance_id?nocookies=true");
      exit(0);
    }
  }

  # If the nocookies param is specified, then either the requesting url wanted
  # to disable cookie usage alltogether, or a previous execution of this function
  # redirected the browser to this url.  The second case is the one that will
  # almost always apply.
  $nocookies=1 if (param('nocookies'));
  # It the above was true, then we must only generate a session ID if one
  # was not already specified as a param.


  if ($nocookies)
  { # In this case, we just go ahead and generate a new session ID

    if (param("sessionid"))
    { # Ahh, we already have a session ID, so lets clean up and leave.

      $session_id=param("sessionid");   # INPUTING OUTSIDE DATA.
      $session_id =~ s/[^[:alnum:]]//g; #  ** Sanitized **

      print STDERR "Do Cookies using a param passed session id since nocookies is also specified\n"
        if ($low_level_debugging);
    }
    else
    {
      $session_id=int(rand(100000000000));
      print STDERR "Do Cookies created new session ID after discovering this browser doesn't do cookies\n"
        if ($low_level_debugging);
    }
    $session_id_url="&"."sessionid=".$session_id;  # This will be added to all URLs
    # the $nocookies variable will cause the form and other urls to have
    # the session ID added


    $kemtmp=$tmproot.$session_id;   # Assign the tmp dir path
    $buildcmd.=" -o $kemtmp ";
    return;   # Exit here to go on to the rest of the page having generated
              # a session ID.

  }

  # If here, then ether the browser accepts cookies or we don't know for sure yet
  my $cookie = cookie ('SessionID');   # Try to read a cookie
  if ($cookie)
  { # yes,we do know this browser! Our cookie was on it


    $session_id=$cookie;              # Set the session ID variable
                                      # from the cookie
    $session_id =~ s/[^[:alnum:]\-_]//g; #  sanitized in case of nasty cookie!!
    print STDERR "Do Cookies just discovered that we have a nice browser\n"
      if ($low_level_debugging);      # This also means that our session ID is
                                      # already determined

    $kemtmp=$tmproot.$session_id;   # Assign the tmp dir path
    $buildcmd.=" -o $kemtmp ";
  }
  else
  { # We don't know this browser yet.  Put 2 cookies on it and do a reload
    # New Session.  The browser doesn't know us.
    # Make a new session ID
    $session_id=int(rand(100000000000));

    $cookie = cookie( -name=> 'SessionID',
                      -value=> $session_id  );
    my $testcookie = cookie(  -name=> 'testcookie',
                              -value=> 'working' );

    print redirect(
        -URL  =>  "$rooturl$instance_id?testcookies=true",
        -COOKIE =>  [$testcookie,$cookie] );
#        -COOKIE =>  $cookie );
    #print "Set-Cookie: $cookie\n";
    #print "Set-Cookie: $testcookie\n";

# JLW 7.15.2007 bugfix- no putting -cookie in the same statement with redirect
#        -cookie => [$cookie,$testcookie] ); # Set the cookie, but we don't know if they'll
                              # like it.
    print "\n";
    $no_footer=1;

    #print STDERR "Did this: rooturl is $rooturl and instance id $instance_id  Then this ?testcookies=true";
    print STDERR "Do Cookies has placed a session ID and test cookie on the browser.\n"
      if ($low_level_debugging);

    exit(0);  # Script terminates here.
  }
}


sub normal_opening()
{
  # first, look to see if we know this browser
  print header( -expires=>'now' );  # print the header without the cookie
  print start_html(
      -title=>'Kernel Extension Manager',
      -BGCOLOR=>'black',
      -TEXT=>'white',
      -ALINK=>'white',
      -VLINK=>'grey',
      -LINK=>'grey');

  print $css_style_sheet;
  #    frame: void;
  #    margin-left: -4%;

  #    border-width: 2px;
  #    border-color: white;

  # print "So you don't like cookies?" if ($nocookies);
  print $maintitle;

  print hr;

  print "<font color=blue>Session ID:</font> ",
      "<font color=red>", $session_id, "</font>",br;
  print "Connected from: ",remote_host(),br;
  print "Web server: ", server_software,"@",server_name,br;
  print "Using $instance_id",br;
  if ($debugging_cgi)
  {
    print "Referred by: ",referer(),br if (referer());
    print "Connected to virtual host: ",virtual_host,br;
    print "Connected to realhost: ", server_name,br;

    if (param)
    {
      my $keys=scalar(param);
      print "We got $keys parameters<br>\n";
      foreach my $this_key (param)
      {
        printf "We got %s -- > %s",$this_key,param($this_key);
        print br;
      }
    }
    else
    {
      print "No parameters",br;
    }

    print "<hr>";
  }

  #  print "<BODY>";
  #  print '<BODY TEXT="#000000" BGCOLOR="#FFFFFF" LINK="#0000EF" VLINK="#55188A" ALINK="#FF0000">';
}



sub run_kem_build()
{

  if (!-e $kemtmp)
  {
    $kemtmp =~ /^([\w -\/]+)$/;
    $kemtmp = $1;
    system("mkdir $kemtmp");
    die "Error: Couldn't create tmp directory, $kemtmp\n" if ($?);
  }

  # New code as of 10.5.2007
  # Collect the garbage from previous runs.  This is cheesy, but
  # should work.  We simply look for files in the tmp space that
  # begin with kem2.2-, are owned by us, and are more than a day old.
  # Such directories get deleted.
  while (glob ($tmproot."*"))
  {
    # print STDERR "Got $_\n";
    if ((-o $_) && (-M $_)>1) # If owned by us and > 1 day old
    {
      $_ =~ /^([\w -\/]+)$/;
      my $rmtmp=$1;
      system ("rm -rf \"$rmtmp\"");     # Recursively delete any matches
    }
  }


  my $pid;    # The PID of the child process
  die "Error: Cannot fork to run the kem utility." unless
    defined ( $pid=open( KEMBUILD, "-|"));
  # if we're still here, then we just forked our brains out.
  if (!$pid)
  { # If the pid is zero, then we are the kid
    # Ok, as the kid, we exec the kembuild, and then we die.  All the while
    # pumping the filehandle with our stdout.

    $buildcmd =~ /^([\w -\/]+)$/;
    $buildcmd=$1;
    my @pkgstobuild;
    foreach (@packages_to_build)
    {
      $_ =~ /^([\w -\/]+)$/;
      push @pkgstobuild, $1;
    }
    exec ("$buildcmd @pkgstobuild")
      or die "Can't get the kem started for the build";
    # Ok, since execution was totally transfered to the kem, we're done here.
  }
  else
  { # If the $pid is non-zero, then we are the parent.
    # So, we are the parent and as such, we are to read the filehandle of the
    # child process (the kem) until it is dead.

    while (<KEMBUILD>)
    {
    #    print "Line $line:$_";
      s/[\r\n]//g;    # Strip any eol
      push @kembuildoutput, "$_\n";      # Append the line to the kemlist buffer
    }
    close (KEMBUILD);  # Block till exit

    if ($?)   # $? is the numeric exit status of the command
    { # There was an error.  Now let's handle specific error codes we report differently
      if ($?==25600)
      {
        print "\n<font color=red>";
        print $overflow_err_msg;
      }
      else
      {
        print "\n<font color=red>";
        print $error;
        printf "With an unhandled error, the exit status was %d.  ",$?;
        print '<a href="http://www.mosaic-industries.com/embedded-systems/dokuwiki/help-for-readers/contact-us">';
        print "Contact Mosaic Industries</a> for assistance.<br>\n";
        print "$buildcmd @packages_to_build<br></font>";
      }

      print "<font color=lime><pre>";

      foreach (@kembuildoutput)
      {
        print "$_";
      }
      print "</pre></font>";
      return($?);
    }
    else
    {   # Exited without an error
      print "\n";
      print $been_built;  # print top of page for has been built

      foreach (@kembuildoutput)
      {
        print "$_";     # some content dependent colorization would be nice here
      }

      print "</pre></font><p><font size=+1 color=yellow>Creating a zip file for you:</font><p><font color=lime><pre>";

      $kemtmp =~ /^([\w -\/]+)$/;
      $kemtmp=$1;
      my $pkzip_path_freebsd="/usr/local/bin/zip";       # Verio shared hosting
      my $pkzip_path_generic="zip";                       # assuming zip can be executed by just typing zip
      my $p7zip_path_debian="/usr/bin/7z";               # Debian Jessie p7zip-full package
      my $zip_fileargs="$kemtmp.zip $kemtmp/*";
      my $zip="$pkzip_path_generic -j -m $zip_fileargs";
      $zip="$p7zip_path_debian a -bd -tzip $zip_fileargs" if (-e $p7zip_path_debian);

      print $zip,"\n";
      print "ZIP ERROR!!!\n" if( system $zip );
      print "</pre></font>";

      # provide a downloadable link to the zip file here.
      # Will have to have a session ID to make this work
      print "You may download your zip file <a href=\"$instance_id?downloadzip=$session_id&schema=$schema";
      print "&nocookies=true" if $nocookies;
      print $session_id_url."\">here</a>";
      return(0);
    }
  }
  #    system ('rm -rf /tmp/kemtmp');
}


sub run_kem_list()
{
  # Executes the kem detail_list command and fills the @kemoutput adday with
  # the raw data that is output from the kem.
  # This function will have the same exit status as the call to kem.

  # print STDERR "First it was ".$listcmd."\n";
  $listcmd =~ /^([\w -\/]+)$/;
  $listcmd=$1;
  # print STDERR "THEN it was ".$listcmd."\n";
  open KEMLIST, '-|', "$listcmd";

  while (<KEMLIST>)
  {
    #  print "In run_kem_list:$_";
    s/[\r\n]//g;    # Strip any eol
    push @kemoutput, "$_\n";      # Append the line to the kemlist buffer
  }
  close (KEMLIST);  # Block till exit
  if ($?)   # $? is the numeric exit status of the command
  {
    print "\n";
    print $error;
    printf "With an error, the exit status was %d<br>\n",$?;
    print "<pre>";
    foreach (@kemoutput)
    {

      print "$_<br>";
    }
    print "</pre>";
    return($?);
  }
  # If we're still here, then the exit status was 0.

  # printf "the exit status of the kem execution was %d<br>\n",$?;
  # printf "of %d lines there were %d",$line,scalar(@kemoutput);

  #  print "<h2>Raw output of function call</h2>";
  #  print "<pre>";
  #  foreach (@kemoutput)
  #  {
  #    print "$_";
  #  }
  #  print "</pre>";
  return($?);
}


sub scan_for_packages(\%)     # Populate a hash with the package information
{
  my $name;
  my $packages_ref=$_[0];
  my $list_started=0;
  my %package_description;
  foreach (@kemoutput)
  {
    if ($list_started)
    {
    if ($_ =~ /---end listing---/)
      {
        $list_started=0;
      }
      else
      { # We are somewhere in the middle of the listing.
        # We do this once per line
        s/[\r\n]//g;    # Strip off any cr/lfs
        s/\s+$//;       # Strip ending apace
        if ($_ =~ /^Package Name:  (.*)/)
        {
          # We have a package name line- This is a new hash key
          # print "\n\nGot a package name line: $1\n\n";
          # $name=$1;                  # Set the name var to the pkg name
          $package_description{'name'}=$1;
          # $package_description={}; # Just a blank init
        }
        elsif ($_ =~ /^Package Description:  (.*)/)
        {
          $package_description{'description'}=$1;
        }
        elsif ($_ =~ /^Package Version:  (.*)/)
        {
          $package_description{'version'}=$1;
        }
        elsif ($_ =~ /^Package Date:  (.*)/)
        {
          $package_description{'date'}=$1;
        }
        elsif ($_ =~ /^Web Info File:  (.*)/)
        {
          $package_description{'info'}=$1;
        }
        elsif ($_ =~ /^$/ )
        {
          # the line was blank- process the previous entry
          # We should have a full $package_description hash
          $name=$package_description{'name'}."_v".$package_description{'version'};
          $packages_ref->{$name}={};    # create anonymous hash for this entry
          # Copy the hash
          $packages_ref->{$name}->{$_}=$package_description{$_}
            foreach(keys(%package_description));
        }
      }
    }
    else
    { # List not started
      $list_started=1   # WE use the line printed at the top of the text table as our
        if ($_ =~ /---begin listing---/);
    }
  }
}
