\ This is your Forth library file.  This file provides you with
\ access to the kernel extension(s) you have installed.  Be sure that
\ you have downloaded the install.txt file prior to this.  You only
\ have to download install.txt once.  Even a factory cleanup won't
\ erase it.  This file defines in the Forth dictionary all the
\ symbols used.  It also provides a generic memory map.  Feel free
\ to change it if necessary, and be carefull if you change the pointers
\ in code that is downloaded after this file.

hex                             \ Set the base to hex
which.map 0=        \ Only if in standard map, copy flash contents to ram
 iftrue 4 page.to.ram   \ and switch maps
        5 page.to.ram   \
        6 page.to.ram  download.map
 endiftrue

0000 4 dp x!        \ Start definitions at page 4
0000 6 np x!        \ and start names half way up page 6

anew kxlibrary
15 width !
\ ----Beginning of package memory allocation listing----
\ Package GUI_Toolkit_QSC_v1.7   Code: 070000 - 072264 Vars: 008e00 - 008e04
\ ----End of package memory allocation listing----
\
\ ----Beginning of memory usage diagram----
\ ** Vars usage each block is 0x100 bytes.  X=Used x=partially used .=not used
\ Vars 00: Range: 008e00 - 00ae00 Used:0004 [x...............................]
\ Vars 01: Range: 00b000 - 00b3ef Used:0000 [....]
\
\ ** Code usage each block is 0x400 bytes.  X=Used x=partially used .=not used
\ Code 00: Range: 070000 - 077fff Used:2264 [XXXXXXXXx.......................]
\ Code 01: Range: 0d0000 - 0d7fff Used:0000 [................................]
\ ----End of memory usage diagram----

\ The Kernel Extensions used 0x0004 actual bytes of variable space
base @ hex din 008e04 vp x! base !

base @ hex
\ Variables for Kernel Extension Package: GUI_Toolkit_QSC
vp x@
vp x!
\ Symbols for Kernel Extension Package: GUI_Toolkit_QSC
dp x@
din 070c4f dp x! create BUTTON_RELEASE
din 0710fa dp x! create SET_PIXEL
din 07026d dp x! create SET_TEXT_AREA
din 071626 dp x! create READ_RAW_COORDS
din 071cfd dp x! create WAIT_THEN_SERVICE_TOUCH
din 07027d dp x! create SET_GR_AREA
din 0702a6 dp x! create SET_CURSOR_STATE
din 070162 dp x! create BYTES_TO_DISPLAY
din 0702e9 dp x! create SET_DISPLAY_STATE
din 0701f8 dp x! create UPDATE_TEXT_AND_GRAPHICS
din 071cf9 dp x! create MENU_PROCESS
din 070b29 dp x! create BUTTON_PRESS
din 0707a0 dp x! create DO_GRAPHIC
din 07024d dp x! create SET_TEXT_HOME_ADDR
din 071137 dp x! create CLEAR_PIXEL
din 07059a dp x! create DRAW_GRAPHIC
din 07154a dp x! create WAIT_FOR_PRESS
din 070e5f dp x! create DO_MENU
din 0701d1 dp x! create UPDATE_TEXT
din 071676 dp x! create CALIBRATE_TOUCHSCREEN
din 070166 dp x! create UPDATE_HERE_WITH
din 070a1f dp x! create BUTTON_ERASE_TEXTONLY
din 0708d6 dp x! create BUTTON_DRAW_TEXTONLY
din 070229 dp x! create CLEAR_TEXT
din 07025d dp x! create SET_GR_HOME_ADDR
din 07101c dp x! create INIT_MENU
din 07053a dp x! create STD_DISPLAY
din 0701aa dp x! create UPDATE_GRAPHICS
din 071b12 dp x! create SERVICE_TOUCH
din 07156b dp x! create WAIT_FOR_RELEASE
din 070691 dp x! create DIRECT_ERASE_GRAPHIC
din 07032c dp x! create SET_TEXT_MODE
din 071f02 dp x! create INIT_TOUCH
din 0705f6 dp x! create DIRECT_DRAW_GRAPHIC
din 0720e2 dp x! create DIRECT_RENDER_FONT
din 0709aa dp x! create BUTTON_DRAW
din 0720ce dp x! create RENDER_FONT
din 070fb4 dp x! create MENU_REMOVE
din 070c1b dp x! create BUTTON_REPEAT
din 07028d dp x! create SET_DISPLAY_MODE
din 070740 dp x! create ERASE_GRAPHIC
din 0715a9 dp x! create READ_TOUCHSCREEN
din 07105b dp x! create UNINIT_MENU
din 070202 dp x! create CLEAR_GRAPHICS
din 070d11 dp x! create DO_BUTTON
din 07033c dp x! create CONFIG_DISPLAY
din 0703a8 dp x! create INIT_DISPLAY
din 071fa3 dp x! create RENDER_FONT_TO_BUFFER
din 071efe dp x! create MENU_QUERY
din 070f13 dp x! create MENU_INSTALL
din 070ab4 dp x! create BUTTON_ERASE
dp x!
base !

\ Beginning raw forthfile for package: GUI_Toolkit_QSC
-1 constant USING_QSC \ set flag for compile time conditionals

anew Touch_Tools        \ Cue up the NP
hex
\ **********************************************************************
\ **
\ **    Program global variables
\ **        Since this program will be usable from C and Forth and shipped
\ **        precompiled, all variables must be stored in a structure that
\ **        the user can allocate later.
\ **

structure.begin: gui_vars
    xaddr-> +display_heap_top       \ The top of the display heap being used
    xaddr-> +display_heap_bottom    \ The bottom of the display heap being used
    int->   +background_fill        \ The contents of this variable are filled
                                    \ into the display graphics array when
                                    \ clear.graphics is called.  T
    array.pf
    bytes-> +graphics_garray        \ We need an array for the graphics system
                                    \ to use.  This array will be used by the
                                    \ graphics calls in the menu system.  It
                                    \ may be used by the application code also.

    xaddr-> +display_resource       \ This resource variable manages access to
                                    \ the graphics array and hardware.  This
                                    \ variable is initialized by
                                    \ init.dualmode.display

    int-> +gr_home_addr             \ Holds the address inside the display
                                    \ where the graphics area begins
    int-> +text_home_addr           \ Holds the address inside the display
                                    \ where the text area begins

    int-> +graphic_rows             \ The number of pixels lines on the display
    int-> +graphic_cols             \ The number of byte columns on the display
                                    \ This depends on the setting of the hard-
                                    \ ware Mode A pin on the TC6963 controller
                                    \ chip. Not all LCDs bring this pin out,
                                    \ but on the standard 240x128 display, it
                                    \ is available
                                    \ and may be set for either 6 or 8
                                    \ pixels/byte.
                                    \ This would cause +graphic_cols to have a
                                    \ value of either 40 or 30 respectively.

    int-> +text_rows                \ The number of text lines on the display
    int-> +text_cols                \ The number of text columns

\ Menu object globals:
    array.pf
    bytes-> +keymap_array
        \ The following are provided as an easy means for people to access
        \ information about buttons being pressed
    int-> +current_row              \ The current row of the button pressed
    int-> +current_col              \ The current col of the button pressed
    int-> +current_keynum           \ The key index  of the button pressed
    xaddr-> +current_button         \ the xpfa of the button that has just been
                                    \ pressed.
USING_QSC
iftrue
\ Touchscreen globals (only for Q-line):
    int-> +last_read_time           \ the last time the touchscreen was read
    int-> +raw_y_coord              \ current uncalibrated y coordinate
    int-> +raw_x_coord              \ current uncalibrated x coordinate
    int-> +cal_y_coord              \ current calibrated y coordinate
    int-> +cal_x_coord              \ current calibrated x coordinate
endiftrue

\ Menu manager globals:
    int-> +repeat_delay             \ delay time before repeating in TS counts
    int-> +repeat_period            \ delay between repeat cycles in TS counts
structure.end

structure.begin: std_button    \ Standard buttons will use this structure
  int->   +flags                \ the bitmaped flags used by the handler
                                \ see above for description

  xaddr-> +graphic_handler_xcfa \ the xcfa to be EXECUTEd for the graphics
                                \ this handler is required to process
                                \ the stack picture that will be left for
                                \ a graphic object.  It must be a forth
                                \ and will be expected to process the the
                                \ graphic class of commands.

  xaddr-> +draw_graphic         \ the xpfa of the graphic shown on draw
  xaddr-> +release_graphic      \ the xpfa of the graphic shown on release
  xaddr-> +press_graphic        \ the xpfa of the graphic shown on press

  xaddr-> +press_handler        \ the xcfa of user code to run when on pressed
  xaddr-> +release_handler      \ the xcfa of user code to run when on released
                                \ The above 2 xcfas may be either C or Forth
                                \ given that they do not accept or return
                                \ any values.  If there is a need to pass
                                \ values  in or out, then global variables must
                                \ be used.

        \ Now, we include an optional 4 lines text that may be used.
        \ These strings are expected to be forth style strings.
        \ if this is a problem, then the code will be changed to accomodate
        \ C style strings instead.
  xaddr-> +label1               \ line 4 text inside button (0-8 characters)
  xaddr-> +label2               \ line 3 text inside button (0-8 characters)
  xaddr-> +label3               \ line 2 text inside button (0-8 characters)
  xaddr-> +label4               \ line 1 text inside button (0-8 characters)
structure.end
structure.begin: std_keymap_entry \ Make a new type of structure
  int->   +row                  \ The relative col number for the item
  int->   +col                  \ The relative row number for the item
  xaddr-> +object               \ the xpfa of the object located here
  xaddr-> +obj_handler          \ the xcfa of the code that handles the object
structure.end


structure.begin: std_menu_entry \ Make a new type of structure
  std_keymap_entry struct->     +keymap_entry
  int->   +action_mask          \ A mask to configure which actions may be
                                \ passed through to the menu item
  int->   +button               \ The relative index for button referencing
                                \ +button# must correlate to the graphic
                                \ location of the item for touchscreens.
                                \ Otherwise, it can simply be used to specify
                                \ what element in the keymap array will contain
                                \ the item.
structure.end



\ This is what a menu array entry looks like. Only elements of std_keymap_entry
\ are copied to the keymap array upon menu install.  The rel button index
\ is used to determine where in the keymap array the menu should be installed.
\ There are certain values that the REL button index may contain to denote
\ special meanings like *BUTTON_NONLOCAL and *BUTTON_NULL.  Any other value for
\ The index will be considered an array index and will be copied into the
\ keymap array.

\ pf+0    |-----------------------|
\         |   Rel row number      | <---*std_menu_entry and std_keymap_entry
\ pf+2    |-----------------------|
\         |   Rel col number      | <---*std_menu_entry and std_keymap_entry
\ pf+4    |-----------------------|
\         |   Object XPFA         | <---*std_menu_entry and std_keymap_entry
\ pf+8    |-----------------------|
\         |   Obj Handler XCFA    | <---*std_menu_entry and std_keymap_entry
\ pf+C    |-----------------------|
\         |   action mask         | <---Only present in std_menu_entry
\ pf+E    |-----------------------|
\         |   Rel button index    | <---Only present in std_menu_entry
\         |-----------------------|


structure.begin:    array_pf       \ A forth array parameter field
  xaddr->   +handle                 \ The xaddr of the handle for the heap item
  addr->    +cur_heap               \ The addr of the top of the heap
  int->     +bytes_per_element      \ The number of bytes in each element
  int->     +num_dimensions         \ The number of dimensions
  int->     +num_cols               \ The number of columns
  int->     +num_rows               \ The number of rows
  int->     +num_pages              \ The 3rd dimension
  int->     +num_books              \ The 4th dimension
structure.end

structure.begin:     const_array_pf \ A constant forth array parameter field
  array_pf struct->  +array_pf      \ The regular forth array parameter field
  xaddr->            +heapitem_handle \ The extra 4 bytes for the heap handle
structure.end
structure.begin: font_structure
  xaddr-> +tablet0
  xaddr-> +tablet1
  xaddr-> +tablet2
  xaddr-> +tablet3
  xaddr-> +tablet4
  xaddr-> +tablet5
  xaddr-> +tablet6
  xaddr-> +tablet7
structure.end
hex
parity drop 18 +
     constant  *PRIOR_CURSOR_STATE
                                    \ We use parity only as a reference point
                                    \ from which to calculate the address
                                    \ of the system variable known as
                                    \ *prior.cursor.state.  Here, we are simply
                                    \ defining it as a constant.  This 8 bit
                                    \ location shadows the display mode byte.

80A0 constant  GRAPHICS_DATA_ADDR   \ The address of the data register
80A2 constant  GRAPHICS_CMD_ADDR    \ The address of the command register
                                    \ These will never change on the QED
                                    \ platform.

00B0 constant  AWSET_CMD            \ The command to start auto write mode in
                                    \ a toshiba display.
00B2 constant  AWRESET_CMD          \ The command that ends the auto write mode
                                    \ in a toshiba display.
                                    \ mode

0040 constant  SET_TX_HOME_CMD      \ command byte to set text home addr
0041 constant  SET_TX_AREA_CMD      \ Command byte to set text area
0042 constant  SET_GR_HOME_CMD      \ command byte to set graphics home addr
0043 constant  SET_GR_AREA_CMD      \ command byte to set graphics area

0080 constant  MODE_CMD             \ OR with lower 4 bits to set the way in
                                    \ which the text interacts with the
                                    \ graphics.  This command should not be
                                    \ confused with the display_mode_cmd.

0090 constant  DISPLAY_MODE_CMD     \ Command that sets the display mode
                                    \ according to the lower 4 bits
0001 constant  CURSOR_BLINK         \ Bit that determines the blinking status
                                    \ of the cursor
0002 constant  CURSOR_ON            \ Bit that determines if the cursor is
                                    \ visible
0004 constant  TEXT_MODE            \ mode bit for text mode
0008 constant  GRAPHICS_MODE        \ mode bit for graphics mode
000F constant  MODE_MASK            \ A handy mask for filtering the mode bits
0000 constant  OR_TEXT              \ Text mode= OR with graphics (default)
0001 constant  EXOR_TEXT            \ Text mode= EXOR with graphics
0003 constant  AND_TEXT             \ Text mode= And with graphics

decimal
0000    constant     LCD_TEXT_ADDR      \ the 16 bit addr in the display memory
                                        \ at which the text area starts
0640    constant     LCD_GRAPHIC_ADDR   \ the 16 bit addr in the display memory

0008    constant     LINES_PER_CHAR     \ Number of pixel lines in a character

0040    constant     GRAPHICS_COLUMNS   \ # of graphic bytes per display line
0128    constant     GRAPHICS_ROWS      \ # of graphic rows in a display column

0040    constant     TEXT_COLUMNS       \ # of text columns
0016    constant     TEXT_ROWS          \ # of text rows

hex
47FF 0F xconstant    DISPLAY_HEAP_TOP    \ These constants determine the
3000 0F xconstant    DISPLAY_HEAP_BOTTOM \ location of the custom display heap
                                        \ A heap of 1800 bytes is just enough
                                        \ to accomodate a 40 x 16 text layer,
                                        \ a 40x128 graphics later, and a
                                        \ 20 x 12 keymap array plus the handles

00  constant  DEF_BACKGROUND_FILL   \ The default background color for
                                    \ background.fill

hex
\ *graphic action flags and masks:
001F CONSTANT  GRAPHICS_MASK        \ Action mask for graphics type actions

0001 CONSTANT  DRAW_ACTION          \ Tells an object to draw itself to the
                                    \ graphics array, graphics.garray.
                                    \ The display is not updated.

0002 CONSTANT  DIR_DRAW_ACTION      \ Tells an object to draw itself directly
                                    \ to the LCD without changing the display
                                    \ array, Graphics_Garray (member of struct
                                    \ TVars).

0004 CONSTANT  REDRAW_ACTION        \ Tells an object to redraw itself; This
                                    \ command is often an alias to DRAW.ACTION

0008 CONSTANT  ERASE_ACTION         \ Tells an object to erase itself

0010 CONSTANT  DIR_ERASE_ACTION     \ Tells an object to erase itself

hex
\ *Button flags and masks:
03E0 constant  BUTTON_MASK           \ Mask for button class commands

0100 constant  DRAW_TEXTONLY_ACTION  \ Tells a button to draw only it's text
0200 constant  ERASE_TEXTONLY_ACTION \ Tells a button to erase only it's text

0020 constant  PRESS_REPEAT_ACTION
0040 constant  PRESS_ACTION          \ Tells a button that it has been pressed
0080 constant  REL_ACTION            \ Tells a button that it has been released


\ *Control flags for button objects

0001 constant DRAW_GRAPHIC_FLAG        \ display graphic when drawn
0002 constant RELEASE_GRAPHIC_FLAG     \ display graphic when released
0004 constant PRESS_GRAPHIC_FLAG       \ display graphic when pressed
0008 constant DIR_DRAW_GRAPHIC_FLAG    \ directly draw to screen on draw
0010 constant DIR_RELEASE_GRAPHIC_FLAG \ directly draw to screen on release
0020 constant DIR_PRESS_GRAPHIC_FLAG   \ directly draw to screen on press


0040 constant DRAW_TEXT_FLAG           \ display text when drawn

0080 constant PRESS_HANDLER_FLAG       \ execute a pressed handler
0100 constant RELEASE_HANDLER_FLAG     \ execute a released handler

0200 constant REPEAT_FLAG              \ execute pressed XCFA as repeating

0400 constant TEXT_UPDATE_PRESS_FLAG   \ call update.text on press
0800 constant TEXT_UPDATE_RELEASE_FLAG \ call update.text on release

1000 constant GRAPHICS_UPDATE_PRESS_FLAG    \ call update.graphics on press
2000 constant GRAPHICS_UPDATE_RELEASE_FLAG  \ call update.graphics on release
4000 constant C_STYLE_TEXT_FLAG             \ Indicates C style string labels
8000 constant BEEP_FLAG                     \ Used by gui builder


\ *Menu actions:
0C00 constant  MENU_MASK        \ Mask for menu class commands

0400 constant  INIT_ACTION      \ Tells a menu object to initialize
0800 constant  UNINIT_ACTION    \ Tells a menu object to uninitialize

FFFF constant  BUTTON_NULL      \ Special value for the button# offset in a
                                \ menu to signify a vacant menu entry

FFFE constant  BUTTON_NONLOCAL  \ Special value for the button# offset in a
                                \ menu to signify that a menu entry does not
                                \ map to a place in the keymap array thus it
                                \ will not be added to or deleted from the
                                \ keymap array.  This is used to have addional
                                \ objects in a menu that do things like draw
                                \ borders and title boxes as part of a menu's
                                \ initialisation.  Any graphic objects should
                                \ use this value.

decimal
10 constant  DEFAULT_REPEAT_PERIOD      \ 50 msec repeat rate assuming 5 msec
                                        \ timeslice period
80 constant  DEFAULT_REPEAT_DELAY       \ 400 msec delay

\ End of Constants and Structures

\ ***********************************************************************
\ ****
\ ****

\ The pbject building functions go here.
decimal
5  constant BUTTON_COLS         \ The total number of cols on the touchscreen
4  constant BUTTON_ROWS         \ The total number of rows on the touchscreen
8  constant BUTTON_WIDTH        \ Buttons are 8 cols wide
32 constant BUTTON_HEIGHT       \ Buttons are 32 pixel lines

GRAPHICS_MASK
DRAW_TEXTONLY_ACTION    or
ERASE_TEXTONLY_ACTION   or
constant                    DRAW_MASK   \ This is a convinient action mask
                                        \ to use in menus


: blank_button
  ( flags\xcfa1\xpfa1\xpfa2\xpfa3\xcfa2\xcfa3\x$addr1\x$addr2\x$addr3\x$addr4 <name> -- )

\ glossary entry here

  locals{ x&label4 x&label3 x&label2 x&label1 x&release_action x&press_action
    x&press_graphic x&release_graphic x&draw_graphic | x&struct_addr }
  std_button d.instance:                \ Create an instance
  here std_button xn-
  to x&struct_addr                      \ save the xaddr of the button

        ( flags -- )
  x&struct_addr +flags !                \ Store the flags
  cfa.for do_graphic    x&struct_addr +graphic_handler_xcfa     x!
  x&draw_graphic        x&struct_addr +draw_graphic             x!
  x&release_graphic     x&struct_addr +release_graphic          x!
  x&press_graphic       x&struct_addr +press_graphic            x!
  x&press_action        x&struct_addr +press_handler            x!
  x&release_action      x&struct_addr +release_handler          x!
  x&label1              x&struct_addr +label1                   x!
  x&label2              x&struct_addr +label2                   x!
  x&label3              x&struct_addr +label3                   x!
  x&label4              x&struct_addr +label4                   x!
  ;

USING_QSC not
iftrue     \ QED version only
  \ this is definied for compatibility.  it is non-unique
  unique.msg @ 0 unique.msg !
  : blankbutton blank_button ;
  unique.msg !    \ restore old uniqueness setting

endiftrue


DRAW_GRAPHIC_FLAG
RELEASE_GRAPHIC_FLAG            or
DIR_RELEASE_GRAPHIC_FLAG        or
PRESS_GRAPHIC_FLAG              or
DIR_PRESS_GRAPHIC_FLAG          or      constant        FASTBUTTON_FLAGS


: fastbutton
  ( flags\xpfa1\xpfa2\xpfa3\xcfa2\x$addr1\x$addr2\x$addr3\x$addr4 <name> -- )

\ Glossary entry here

  locals{ x&label4 x&label3 x&label2 x&label1 x&action
    x&press_graphic x&release_graphic x&draw_graphic }

    ( flags -- )
  FASTBUTTON_FLAGS or

  x&draw_graphic                \ graphic for draw action
  x&release_graphic             \ graphic for release action
  x&press_graphic               \ graphic for press action
  x&action                      \ we use action twice so that it can serve as the
  x&action                      \ press or release handler depending on the flags.
  x&label1                      \ Text line 1
  x&label2                      \ Text line 2
  x&label3                      \ Text line 3
  x&label4                      \ Text line 4
  blank_button                   \ Call the routine to build it.
  ;



DRAW_GRAPHIC_FLAG
RELEASE_GRAPHIC_FLAG            or
PRESS_GRAPHIC_FLAG              or
GRAPHICS_UPDATE_RELEASE_FLAG    or
GRAPHICS_UPDATE_PRESS_FLAG      or      constant        NORMBUTTON_FLAGS


: normbutton
  ( flags\xpfa1\xpfa2\xpfa3\xcfa2\x$addr1\x$addr2\x$addr3\x$addr4 <name> -- )

\ Glossary entry here

  locals{ x&label4 x&label3 x&label2 x&label1 x&action
    x&press_graphic x&release_graphic x&draw_graphic }

    ( flags -- )
  NORMBUTTON_FLAGS or

  x&draw_graphic                \ graphic for draw action
  x&release_graphic             \ graphic for release action
  x&press_graphic               \ graphic for press action
  x&action                      \ we use action twice so that it can serve as the
  x&action                      \ press or release handler depending on the flags.
  x&label1                      \ Text line 1
  x&label2                      \ Text line 2
  x&label3                      \ Text line 3
  x&label4                      \ Text line 4
  blank_button                  \ Call the routine to build it.
  ;


\ Menu macros

: new_menu: ( <name> -- xpfa )
    \ Starts a new menu with the given name.  Xpfa is that of the array that
    \ new_menu: just created.  Initially, there will be 0 elements in the
    \ array.

  const_array_pf d.instance:

  here const_array_pf xn-
  locals{ x&addr }
  x&addr +heapitem_handle x&addr +handle x!     \ The xaddress of the handle
  0               x&addr +cur_heap !            \ current heap base addr
  std_menu_entry  x&addr +bytes_per_element !   \ number of bytes per element
  1               x&addr +num_dimensions !      \ number of dimensions
  0               x&addr +num_cols !            \ Rows
  0               x&addr +num_rows !            \ Cols
  0               x&addr +num_pages !           \ Pages
  0               x&addr +num_books !           \ Books
  here            x&addr +heapitem_handle x!    \ Init the heap_handle to point
                                                \ here
  x&addr
  ;


: colrow_to_button ( col\row -- button# )
    \ Converts from a row and column to a button index number.

  BUTTON_HEIGHT /
  swap BUTTON_WIDTH / BUTTON_ROWS * +
[ USING_QSC
iftrue ]     \ Q-line version
  1+
[
endiftrue ]
  ;


: add_graphic ( xpfa1\col\row\mask\xpfa2 -- xpfa1 )
    \ Adds another element to the array being built with xpfa1 as its parameter
    \ field.  The new element begins at the current location in the dictionary
    \ and moves DP forward.  Row and col are the relative location on the screen
    \ where the button will be built.
    \ Xpfa2 is the parameter field of the button object.  Mask is anded
    \ with any action passed in with do_menu.  Any action whose bit not set in
    \ mask will be ignored.

  7 needed
  here
  locals{ x&here x&graphic_obj &mask &row &col }
    ( xpfa1 -- )
  xdup +num_cols xdup @ 1+ -rot !               \ Modify the array pf
    ( xpfa1 -- )

  std_menu_entry allot                          \ Move the dp forward

  &row x&here +row !                            \ Store the row
  &col x&here +col !                            \ Store the col
  x&graphic_obj x&here +object x!               \ Store the button xpfa
  cfa.for do_graphic x&here +obj_handler x!     \ Store the button's handler
  &mask x&here +action_mask !                   \ Store the action mask
  BUTTON_NONLOCAL x&here +button !              \ Store the button number
  ;


: add_button ( xpfa1\n\col\row\mask\xpfa2 -- xpfa1 )
    \ Adds another element to the array being built with xpfa1 as its parameter
    \ field.  The new element begins at the current location in the dictionary
    \ and moves DP forward.  Row and col are the relative location on the screen
    \ where the button will be built.  N is the relative offset for the keymap
    \ index. Xpfa2 is the parameter field of the button object.  Mask is anded
    \ with any action passed in with do_menu.  Any action whose bit not set in
    \ mask will be ignored.

  8 needed
  here
  locals{ x&here x&button_obj &mask &row &col &n }
    ( xpfa1 -- )
  xdup +num_cols xdup @ 1+ -rot !               \ Modify the array pf
    ( xpfa1 -- )

  std_menu_entry allot          \ Move the dp forward

  &row x&here +row !                            \ Store the row
  &col x&here +col !                            \ Store the col
  x&button_obj x&here +object x!                \ Store the button xpfa
  cfa.for do_button x&here +obj_handler x!      \ Store the button's handler
  &mask x&here +action_mask !                   \ Store the action mask
  &n x&here +button !                           \ Store the button number
  ;


: add_touch_button ( xpfa1\col\row\mask\xpfa2 -- xpfa1 )
    \ Adds another element to the array being built with xpfa1 as its parameter
    \ field.  Row and col are the relative location on the screen where the
    \ button will be built.  The button number (touch location) is determined
    \ automatically from the row and col based of the constants in gui_tk10.4th.
    \ Xpfa2 is the parameter field of the button object.  Mask is anded with
    \ any action passed in with do_menu.  Any action whose bit not set in
    \ mask will be ignored.

  7 needed
  locals{ x&button_obj &mask }                  \ Get these out of the way
  2dup                                          \ Make a copy of row and col
  colrow_to_button                              \ Convert to a button number
  -rot                                          \ Put the button# under row\col
  &mask                                         \ Restore from earlier
  x&button_obj                                  \ Restore from earlier
    ( xpfa1\button#\col\row\mask\xpfa2 -- )
  add_button                                    \ Call the fundamental function
  ;


: build_menu ( xpfa -- )
  xdrop
  ;

\ End of raw forthfile for package: GUI_Toolkit_QSC
\ End of Forth library file
\ Save RAM pages to flash and preserve pointers.  to restore after cold,
\ download.map 1 page.to.ram 2 page.to.ram 3 page.to.ram restore
4 page.to.flash
5 page.to.flash
6 page.to.flash
save
